/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.delegate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.delegate.DelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.InvocationBehavior;
import org.eclipse.ocl.pivot.internal.delegate.ValidationBehavior;
import org.eclipse.ocl.pivot.internal.delegate.ValidationDelegate;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class DelegateEClassifierAdapter
extends AdapterImpl {
    protected Map<String, ValidationDelegate> validationDelegateMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull DelegateEClassifierAdapter getAdapter(@NonNull EClassifier eClassifier) {
        DelegateEClassifierAdapter adapter;
        EList eAdapters;
        EList eList = eAdapters = eClassifier.eAdapters();
        synchronized (eList) {
            adapter = (DelegateEClassifierAdapter)EcoreUtil.getAdapter((List)eAdapters, DelegateEClassifierAdapter.class);
            if (adapter == null) {
                adapter = new DelegateEClassifierAdapter();
                eAdapters.add((Object)adapter);
            }
        }
        return adapter;
    }

    public @Nullable ValidationDelegate getValidationDelegate(@NonNull String delegateURI) {
        if (this.validationDelegateMap == null) {
            this.getValidationDelegates();
        }
        return this.validationDelegateMap.get(delegateURI);
    }

    public synchronized @NonNull Map<String, ValidationDelegate> getValidationDelegates() {
        Map<String, ValidationDelegate> validationDelegateMap2 = this.validationDelegateMap;
        if (validationDelegateMap2 == null) {
            EClassifier eClassifier = ClassUtil.nonNullState(this.getTarget());
            this.validationDelegateMap = validationDelegateMap2 = new HashMap<String, ValidationDelegate>();
            List factories = ValidationBehavior.INSTANCE.getFactories(eClassifier);
            if (eClassifier instanceof EClass) {
                for (EOperation eOperation : ((EClass)eClassifier).getEOperations()) {
                    if (eOperation == null || !EcoreUtil.isInvariant((EOperation)eOperation)) continue;
                    List<DelegateDomain> opDelegateDomains = InvocationBehavior.INSTANCE.getDelegateDomains(eOperation);
                    for (DelegateDomain opDelegateDomain : opDelegateDomains) {
                        ValidationDelegate.Factory opFactory;
                        if (opDelegateDomain == null || (opFactory = ValidationBehavior.INSTANCE.getFactory(opDelegateDomain, eClassifier)) == null || factories.contains(opFactory)) continue;
                        factories.add(opFactory);
                    }
                }
            }
            if (!factories.isEmpty()) {
                for (ValidationDelegate.Factory factory : factories) {
                    ValidationDelegate validationDelegate = factory.createValidationDelegate(eClassifier);
                    if (validationDelegate == null) continue;
                    validationDelegateMap2.put(factory.getURI(), validationDelegate);
                }
            }
        }
        return validationDelegateMap2;
    }

    public EClassifier getTarget() {
        return (EClassifier)super.getTarget();
    }

    public boolean isAdapterForType(Object type) {
        return type == DelegateEClassifierAdapter.class;
    }

    public void setTarget(Notifier newTarget) {
        EClassifier resourceSet = (EClassifier)newTarget;
        super.setTarget((Notifier)resourceSet);
    }
}

