/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.dtd.util;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.ant.internal.ui.dtd.util.AntDTDUtilMessages;
import org.eclipse.ant.internal.ui.dtd.util.FactoryObject;
import org.eclipse.ant.internal.ui.dtd.util.IMapHolder;
import org.eclipse.ant.internal.ui.dtd.util.SortedSet;

public class SortedMap
implements FactoryObject {
    private SortedSet fSet;
    private IMapHolder fHolder;
    private SortedMap fNext;

    public SortedMap(IMapHolder holder, Comparator<Object> comp) {
        this.fHolder = holder;
        this.fSet = new SortedSet(holder, comp);
    }

    public SortedMap(Comparator<Object> comp) {
        this.fSet = new SortedSet(comp);
    }

    public SortedMap(IMapHolder holder) {
        this.fHolder = holder;
        this.fSet = new SortedSet(holder);
    }

    public SortedMap() {
        this.fSet = new SortedSet();
    }

    public void setMapHolder(IMapHolder holder) {
        this.fHolder = holder;
        this.fSet.setKeyHolder(holder);
    }

    public void setComparator(Comparator<Object> comp) {
        this.fSet.setComparator(comp);
    }

    public boolean containsKey(Object key) {
        return this.fSet.contains(key);
    }

    public boolean containsKeyIdentity(Object key) {
        return this.fSet.containsIdentity(key);
    }

    public Object put(Object key, Object val) {
        Object[] values = this.fHolder.getValues();
        int index = this.fSet.indexOf(key);
        Object result = index >= 0 && values != null ? values[index] : null;
        int i = this.fSet.internalAdd(key, false);
        if (i >= 0) {
            this.internalPut(i, val);
        }
        return result;
    }

    protected void internalPut(int i, Object val) {
        Object[] values = this.fHolder.getValues();
        if (values == null) {
            values = new Object[]{val};
            return;
        }
        Object[] tmp = new Object[values.length + 1];
        System.arraycopy(values, 0, tmp, 0, i);
        tmp[i] = val;
        System.arraycopy(values, i, tmp, i + 1, values.length - i);
        this.fHolder.setValues(tmp);
    }

    public int putAlways(Object key, Object val) {
        int i = this.fSet.internalAdd(key, true);
        this.internalPut(i, val);
        return i;
    }

    public void append(Object key, Object val) {
        Object[] values = this.fHolder.getValues();
        int len = values != null ? values.length : 0;
        this.fSet.internalAdd(len, key);
        this.internalPut(len, val);
    }

    public Object get(Object key) {
        Object[] values = this.fHolder.getValues();
        if (values == null) {
            return null;
        }
        int i = this.fSet.indexOf(key);
        if (i >= 0) {
            return values[i];
        }
        return null;
    }

    public Object getIdentity(Object key) {
        Object[] values = this.fHolder.getValues();
        if (values == null) {
            return null;
        }
        int i = this.fSet.indexOfIdentity(key);
        if (i >= 0) {
            return values[i];
        }
        return null;
    }

    public Object[] keys() {
        return this.fSet.members();
    }

    public Object[] values() {
        Object[] values = this.fHolder.getValues();
        if (values == null) {
            return new Object[0];
        }
        return values;
    }

    public Iterator<?> keyIterator() {
        return new ArrayIterator();
    }

    public Iterator<?> valueIterator() {
        return new ArrayIterator();
    }

    public void remove(int i) {
        Object[] values = this.fHolder.getValues();
        if (values == null) {
            throw new IllegalArgumentException(MessageFormat.format(AntDTDUtilMessages.SortedMap_remove__0___in_empty_map_2, Integer.toString(i)));
        }
        this.fSet.remove(i);
        Object[] tmp = new Object[values.length - 1];
        System.arraycopy(values, 0, tmp, 0, i);
        System.arraycopy(values, i + 1, tmp, i, values.length - i - 1);
        this.fHolder.setValues(tmp);
    }

    public Object remove(Object obj) {
        Object[] values = this.fHolder.getValues();
        if (values == null) {
            return null;
        }
        int i = this.fSet.indexOf(obj);
        if (i >= 0) {
            Object tmp = values[i];
            this.fSet.remove(i);
            this.remove(i);
            return tmp;
        }
        return null;
    }

    public Object removeIdentity(Object obj) {
        Object[] values = this.fHolder.getValues();
        if (values == null) {
            return null;
        }
        int i = this.fSet.indexOfIdentity(obj);
        if (i >= 0) {
            Object tmp = values[i];
            this.fSet.remove(i);
            this.remove(i);
            return tmp;
        }
        return null;
    }

    public int size() {
        return this.fSet.size();
    }

    public int keyIndex(Object key) {
        return this.fSet.indexOf(key);
    }

    public void merge(SortedMap other) {
        Object[] values = this.fHolder.getValues();
        Object[] keys = this.fHolder.getKeys();
        Object[] othervalues = other.fHolder.getValues();
        Object[] otherkeys = other.fHolder.getKeys();
        if (otherkeys == null) {
            return;
        }
        if (keys == null) {
            this.fHolder.setKeys(otherkeys);
            this.fHolder.setValues(othervalues);
            return;
        }
        int ithis = 0;
        int iother = 0;
        int i = 0;
        int mthis = keys.length;
        int mother = otherkeys.length;
        Object[] ktmp = new Object[mthis + mother];
        Object[] vtmp = new Object[mthis + mother];
        while (ithis < mthis && iother < mother) {
            int comp = this.fSet.fComp.compare(keys[ithis], otherkeys[iother]);
            if (comp <= 0) {
                vtmp[i] = values[ithis];
                ktmp[i++] = keys[ithis++];
                continue;
            }
            vtmp[i] = othervalues[iother];
            ktmp[i++] = otherkeys[iother++];
        }
        while (ithis < mthis) {
            vtmp[i] = values[ithis];
            ktmp[i++] = keys[ithis++];
        }
        while (iother < mother) {
            vtmp[i] = othervalues[iother];
            ktmp[i++] = otherkeys[iother++];
        }
        this.fHolder.setKeys(ktmp);
        this.fHolder.setValues(vtmp);
    }

    @Override
    public FactoryObject next() {
        return this.fNext;
    }

    @Override
    public void next(FactoryObject next) {
        this.fNext = (SortedMap)next;
    }

    private class ArrayIterator
    implements Iterator<Object> {
        private int fIndex = -1;

        @Override
        public boolean hasNext() {
            Object[] array = SortedMap.this.fHolder.getKeys();
            if (array == null) {
                return false;
            }
            return this.fIndex + 1 < array.length;
        }

        @Override
        public Object next() {
            Object[] array = SortedMap.this.fHolder.getKeys();
            if (array == null) {
                throw new IllegalStateException(AntDTDUtilMessages.SortedMap_next___called_for_empty_array_1);
            }
            return array[++this.fIndex];
        }

        @Override
        public void remove() {
            SortedMap.this.remove(this.fIndex);
            --this.fIndex;
        }
    }
}

