/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.commons.workbench.browser.UrlHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractTaskHyperlinkDetector;

public class TaskUrlHyperlinkDetector
extends AbstractTaskHyperlinkDetector {
    private static final Pattern URL_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z+.-]{0,10}://[a-zA-Z0-9%._~!$&?#'()*+,;:@/=-]*[a-zA-Z0-9%_~!$&?#'(*+;:@/=-])");
    private static final String CLOSED_PARENTHESIS_PATTERN = "[^)]";
    private static final String OPEN_PARENTHESIS_PATTERN = "[^(]";
    private static final String EMPTY_STRING = "";

    @Override
    protected List<IHyperlink> detectHyperlinks(ITextViewer textViewer, String content, int indexInContent, int contentOffset) {
        ArrayList<IHyperlink> links = null;
        Matcher m = URL_PATTERN.matcher(content);
        while (m.find()) {
            if (!TaskUrlHyperlinkDetector.isInRegion(indexInContent, m)) continue;
            String urlString = this.getUrlString(content, m);
            IHyperlink link = null;
            if (this.getAdapter(TaskRepository.class) != null) {
                try {
                    new URL(urlString);
                    link = TaskUrlHyperlinkDetector.createTaskUrlHyperlink(contentOffset, m, urlString);
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (TasksUiInternal.isTaskUrl(urlString)) {
                link = TaskUrlHyperlinkDetector.createTaskUrlHyperlink(contentOffset, m, urlString);
            }
            if (link == null) continue;
            if (links == null) {
                links = new ArrayList<IHyperlink>();
            }
            links.add(link);
        }
        return links;
    }

    private String getUrlString(String content, Matcher m) {
        String urlString = m.group(1);
        int parenthesisDiff = urlString.replaceAll(OPEN_PARENTHESIS_PATTERN, EMPTY_STRING).length() - urlString.replaceAll(CLOSED_PARENTHESIS_PATTERN, EMPTY_STRING).length();
        if (parenthesisDiff > 0) {
            int i = m.end();
            while (i - m.end() < parenthesisDiff) {
                if (i >= content.length() || content.charAt(i) != ')') break;
                urlString = String.valueOf(urlString) + ')';
                ++i;
            }
        }
        return urlString;
    }

    private static boolean isInRegion(int offsetInText, Matcher m) {
        return offsetInText == -1 || offsetInText >= m.start() && offsetInText <= m.end();
    }

    private static IHyperlink createTaskUrlHyperlink(int textOffset, Matcher m, String urlString) {
        return new UrlHyperlink((IRegion)new Region(textOffset + m.start(), urlString.length()), urlString);
    }
}

