/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class NewTaskWizard
extends Wizard
implements INewWizard {
    private final TaskRepository taskRepository;
    private ITaskMapping taskSelection;

    public NewTaskWizard(TaskRepository taskRepository, ITaskMapping taskSelection) {
        Assert.isNotNull((Object)taskRepository);
        this.taskRepository = taskRepository;
        this.taskSelection = taskSelection;
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
        this.setNeedsProgressMonitor(true);
    }

    @Deprecated
    public NewTaskWizard(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
    }

    protected ITaskMapping getInitializationData() {
        return null;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public ITaskMapping getTaskSelection() {
        return this.taskSelection;
    }

    public boolean performFinish() {
        final TaskData[] taskData = new TaskData[1];
        final ITaskMapping initializationData = this.getInitializationData();
        final ITaskMapping selectionData = this.getTaskSelection();
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        taskData[0] = TasksUiInternal.createTaskData(NewTaskWizard.this.taskRepository, initializationData, selectionData, monitor);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException();
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            if (this.getContainer().getShell().isVisible()) {
                this.getContainer().run(true, true, runnable);
            } else {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                TasksUiInternal.displayStatus(Messages.NewTaskWizard_Error_creating_new_task, ((CoreException)e.getCause()).getStatus());
            } else {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", Messages.NewTaskWizard_Error_creating_new_task, (Throwable)e), 3);
            }
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        try {
            TasksUiInternal.createAndOpenNewTask(taskData[0]);
            return true;
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to open new task", (Throwable)e));
            TasksUiInternal.displayStatus(Messages.NewTaskWizard_Create_Task, (IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", String.valueOf(Messages.NewTaskWizard_Failed_to_create_new_task_) + e.getMessage()));
            return false;
        }
    }
}

