/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contextlaunching;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.ILaunchHistoryChangedListener;
import org.eclipse.debug.internal.ui.ILaunchLabelChangedListener;
import org.eclipse.debug.internal.ui.contextlaunching.ContextMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchWindow;

public class LaunchingResourceManager
implements IPropertyChangeListener,
IWindowListener,
ISelectionListener,
ILaunchHistoryChangedListener,
ILaunchesListener2 {
    private ListenerList<ILaunchLabelChangedListener> fLabelListeners = new ListenerList();
    private HashMap<IWorkbenchWindow, ToolBar> fToolbars = new HashMap();
    private HashMap<ILaunchGroup, String> fCurrentLabels = new HashMap();
    private boolean fUpdateLabel = true;
    private HashSet<IWorkbenchWindow> fWindows = new HashSet();
    private HashMap<IResource, ILaunchConfiguration[]> fConfigCache = new HashMap();
    private HashMap<IResource, List<LaunchShortcutExtension>> fExtCache = new HashMap();
    private static final String EMPTY_STRING = "";
    private MouseTrackAdapter fMouseListener = new MouseTrackAdapter(){

        public void mouseEnter(MouseEvent e) {
            if (LaunchingResourceManager.this.fUpdateLabel) {
                LaunchingResourceManager.this.fUpdateLabel = false;
                LaunchingResourceManager.this.fCurrentLabels.clear();
                Job job = new Job("Compute launch button tooltip"){

                    protected IStatus run(IProgressMonitor monitor) {
                        LaunchingResourceManager.this.computeLabels();
                        (this).LaunchingResourceManager.this.fConfigCache.clear();
                        (this).LaunchingResourceManager.this.fExtCache.clear();
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    };

    public static boolean isContextLaunchEnabled() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.UseContextualLaunch");
    }

    public static boolean isContextLaunchEnabled(String launchgroupid) {
        return LaunchingResourceManager.isContextLaunchEnabled() && !"org.eclipse.ui.externaltools.launchGroup".equals(launchgroupid);
    }

    public void addLaunchLabelUpdateListener(ILaunchLabelChangedListener listener) {
        this.fLabelListeners.add((Object)listener);
    }

    public void removeLaunchLabelChangedListener(ILaunchLabelChangedListener listener) {
        this.fLabelListeners.remove((Object)listener);
    }

    public String getLaunchLabel(ILaunchGroup group) {
        return this.fCurrentLabels.get(group);
    }

    protected boolean shouldCheckParent() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.LaunchParentProject");
    }

    protected boolean shouldLaunchLast() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.LaunchLastIfNotLaunchable");
    }

    protected void computeLabels() {
        ILaunchGroup group = null;
        ILaunchConfiguration config = null;
        String label = null;
        SelectedResourceManager srm = SelectedResourceManager.getDefault();
        IStructuredSelection selection = srm.getCurrentSelection();
        List<LaunchShortcutExtension> shortcuts = null;
        IResource resource = srm.getSelectedResource();
        for (ILaunchLabelChangedListener iLaunchLabelChangedListener : this.fLabelListeners) {
            group = iLaunchLabelChangedListener.getLaunchGroup();
            if (group == null) continue;
            if (LaunchingResourceManager.isContextLaunchEnabled(group.getIdentifier())) {
                shortcuts = this.getShortcutsForSelection(selection, group.getMode());
                if (resource == null) {
                    resource = this.getLaunchableResource(shortcuts, selection);
                }
                label = this.getLabel(selection, resource, shortcuts, group);
            } else {
                config = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getFilteredLastLaunch(group.getIdentifier());
                if (config != null) {
                    label = this.appendLaunched(config);
                }
            }
            this.fCurrentLabels.put(group, label);
            label = null;
        }
        this.notifyLabelChanged();
    }

    protected void notifyLabelChanged() {
        for (ILaunchLabelChangedListener iLaunchLabelChangedListener : this.fLabelListeners) {
            iLaunchLabelChangedListener.labelChanged();
        }
    }

    private String appendLaunched(ILaunchConfiguration config) {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        boolean launched = false;
        ILaunchConfiguration tmp = null;
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            tmp = launch.getLaunchConfiguration();
            if (tmp != null && !launch.isTerminated() && tmp.equals(config)) {
                launched = true;
                break;
            }
            ++n2;
        }
        if (launched) {
            return MessageFormat.format(ContextMessages.LaunchingResourceManager_0, config.getName());
        }
        return config.getName();
    }

    protected String getlastLaunchedLabel(ILaunchGroup group) {
        ILaunchConfiguration config = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getFilteredLastLaunch(group.getIdentifier());
        if (config != null) {
            return this.appendLaunched(config);
        }
        return EMPTY_STRING;
    }

    protected String getLabel(IStructuredSelection selection, IResource resource, List<LaunchShortcutExtension> shortcuts, ILaunchGroup group) {
        int esize;
        List<LaunchShortcutExtension> sc = this.pruneShortcuts(shortcuts, resource, group.getMode());
        LaunchConfigurationManager lcm = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        ILaunchConfiguration config = lcm.isSharedConfig(resource);
        if (config != null) {
            return this.appendLaunched(config);
        }
        List<ILaunchConfiguration> configs = this.getParticipatingLaunchConfigurations(selection, resource, sc, group.getMode());
        int csize = configs.size();
        if (csize == 1) {
            return this.appendLaunched(configs.get(0));
        }
        if (csize > 1) {
            config = lcm.getMRUConfiguration(configs, group, resource);
            if (config != null) {
                return this.appendLaunched(config);
            }
            return ContextMessages.ContextRunner_14;
        }
        List<LaunchShortcutExtension> exts = this.fExtCache.get(resource);
        if (exts == null && resource != null) {
            this.fExtCache.put(resource, sc);
        }
        if ((esize = sc.size()) == 0) {
            if (resource != null && this.shouldCheckParent()) {
                IProject project = resource.getProject();
                if (project != null && !project.equals((Object)resource)) {
                    return this.getLabel(selection, (IResource)project, sc, group);
                }
            } else {
                if (this.shouldLaunchLast() || resource == null) {
                    return this.getlastLaunchedLabel(group);
                }
                return ContextMessages.ContextRunner_15;
            }
        }
        if (esize == 1) {
            if (resource != null) {
                return resource.getName();
            }
            return MessageFormat.format(ContextMessages.LaunchingResourceManager_1, sc.get(0).getLabel());
        }
        return ContextMessages.ContextRunner_14;
    }

    protected List<LaunchShortcutExtension> pruneShortcuts(List<LaunchShortcutExtension> shortcuts, IResource resource, String mode) {
        List<LaunchShortcutExtension> list = new ArrayList<LaunchShortcutExtension>(shortcuts);
        if (resource == null) {
            LaunchShortcutExtension ext = null;
            ListIterator iter = list.listIterator();
            while (iter.hasNext()) {
                ext = (LaunchShortcutExtension)iter.next();
                if (ext.isParticipant()) continue;
                iter.remove();
            }
        } else {
            list = this.getShortcutsForSelection((IStructuredSelection)new StructuredSelection((Object)resource), mode);
        }
        return list;
    }

    public IResource getLaunchableResource(List<LaunchShortcutExtension> shortcuts, IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            ArrayList<IResource> resources = new ArrayList<IResource>();
            IResource resource = null;
            Object o = selection.getFirstElement();
            for (LaunchShortcutExtension ext : shortcuts) {
                resource = o instanceof IEditorPart ? ext.getLaunchableResource((IEditorPart)o) : ext.getLaunchableResource((ISelection)selection);
                if (resource == null || resources.contains(resource)) continue;
                resources.add(resource);
                resource = null;
            }
            if (resources.size() > 0) {
                return (IResource)resources.get(0);
            }
        }
        return null;
    }

    public List<LaunchShortcutExtension> getShortcutsForSelection(IStructuredSelection selection, String mode) {
        ArrayList<LaunchShortcutExtension> list = new ArrayList<LaunchShortcutExtension>();
        List<LaunchShortcutExtension> sc = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchShortcuts();
        ArrayList<IEditorInput> ctxt = new ArrayList<IEditorInput>();
        ctxt.addAll(selection.toList());
        Object o = selection.getFirstElement();
        if (o instanceof IEditorPart) {
            ctxt.set(0, ((IEditorPart)o).getEditorInput());
        }
        IEvaluationContext context = DebugUIPlugin.createEvaluationContext(ctxt);
        context.addVariable("selection", ctxt);
        for (LaunchShortcutExtension ext : sc) {
            try {
                if (!ext.evalEnablementExpression(context, ext.getContextualLaunchEnablementExpression()) || !ext.getModes().contains(mode) || WorkbenchActivityHelper.filterItem((Object)ext) || list.contains(ext)) continue;
                list.add(ext);
            }
            catch (CoreException coreException) {}
        }
        return list;
    }

    public List<ILaunchConfiguration> getParticipatingLaunchConfigurations(IStructuredSelection selection, IResource resource, List<LaunchShortcutExtension> shortcuts, String mode) {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        int voteDefault = 0;
        if (selection != null) {
            Object o = selection.getFirstElement();
            LaunchShortcutExtension ext = null;
            ILaunchConfiguration[] cfgs = null;
            Iterator<LaunchShortcutExtension> iterator = shortcuts.iterator();
            while (iterator.hasNext()) {
                LaunchShortcutExtension shortcut;
                ext = shortcut = iterator.next();
                cfgs = o instanceof IEditorPart ? ext.getLaunchConfigurations((IEditorPart)o) : ext.getLaunchConfigurations((ISelection)selection);
                if (cfgs == null) {
                    Set<String> types = ext.getAssociatedConfigurationTypes();
                    this.addAllToList(configs, DebugUIPlugin.getDefault().getLaunchConfigurationManager().getApplicableLaunchConfigurations(types.toArray(new String[types.size()]), resource));
                    ++voteDefault;
                    continue;
                }
                if (cfgs.length <= 0) continue;
                Collections.addAll(configs, cfgs);
            }
        }
        if (voteDefault == shortcuts.size()) {
            this.addAllToList(configs, DebugUIPlugin.getDefault().getLaunchConfigurationManager().getApplicableLaunchConfigurations(null, resource));
        }
        Iterator iterator = configs.iterator();
        while (iterator.hasNext()) {
            ILaunchConfiguration config = (ILaunchConfiguration)iterator.next();
            try {
                Set modes = config.getModes();
                modes.add(mode);
                if (config.getType().supportsModeCombination(modes)) continue;
                iterator.remove();
            }
            catch (CoreException coreException) {}
        }
        return configs;
    }

    private void addAllToList(List<ILaunchConfiguration> list, ILaunchConfiguration[] configs) {
        if (list == null || configs == null) {
            return;
        }
        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (!list.contains(config)) {
                list.add(config);
            }
            ++n2;
        }
    }

    public void startup() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            IWorkbenchWindow[] workbenchWindows;
            workbench.addWindowListener((IWindowListener)this);
            IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = workbench.getWorkbenchWindows();
            int n = workbenchWindows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
                if (workbenchWindow.getSelectionService() != null) {
                    this.windowOpened(workbenchWindow);
                }
                ++n2;
            }
        }
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DebugUIPlugin.getDefault().getLaunchConfigurationManager().addLaunchHistoryListener(this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public void shutdown() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            workbench.removeWindowListener((IWindowListener)this);
        }
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        DebugUIPlugin.getDefault().getLaunchConfigurationManager().removeLaunchHistoryListener(this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        for (IWorkbenchWindow iWorkbenchWindow : this.fWindows) {
            iWorkbenchWindow.getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
        this.fUpdateLabel = false;
        for (Map.Entry entry : this.fToolbars.entrySet()) {
            ToolBar bar = (ToolBar)entry.getValue();
            if (bar == null || bar.isDisposed()) continue;
            MouseTrackAdapter listener = this.fMouseListener;
            DebugUIPlugin.getStandardDisplay().asyncExec(() -> bar.removeMouseTrackListener((MouseTrackListener)listener));
        }
        this.fWindows.clear();
        this.fToolbars.clear();
        this.fLabelListeners.clear();
        this.fCurrentLabels.clear();
    }

    public void windowActivated(IWorkbenchWindow window) {
        if (!this.fToolbars.containsKey(window)) {
            this.addMouseListener(window);
        }
    }

    public void windowClosed(IWorkbenchWindow window) {
        ToolBar bar = this.fToolbars.remove(window);
        if (bar != null && !bar.isDisposed()) {
            bar.removeMouseTrackListener((MouseTrackListener)this.fMouseListener);
        }
        if (this.fWindows.remove(window)) {
            window.getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        if (this.fWindows.add(window)) {
            window.getSelectionService().addSelectionListener((ISelectionListener)this);
        }
    }

    private void addMouseListener(IWorkbenchWindow window) {
        ToolBarManager tmgr;
        ToolBar bar;
        IContributionItem item;
        ICoolBarManager cmgr = ((WorkbenchWindow)window).getCoolBarManager2();
        if (cmgr != null && (item = cmgr.find("org.eclipse.debug.ui.launchActionSet")) instanceof ToolBarContributionItem && (bar = (tmgr = (ToolBarManager)((ToolBarContributionItem)item).getToolBarManager()).getControl()) != null && !bar.isDisposed()) {
            bar.addMouseTrackListener((MouseTrackListener)this.fMouseListener);
            this.fToolbars.put(window, bar);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.debug.ui.UseContextualLaunch") || event.getProperty().equals("org.eclipse.debug.ui.LaunchLastIfNotLaunchable")) {
            if (LaunchingResourceManager.isContextLaunchEnabled()) {
                this.windowActivated(DebugUIPlugin.getActiveWorkbenchWindow());
            }
            this.fUpdateLabel = true;
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (LaunchingResourceManager.isContextLaunchEnabled()) {
            this.fUpdateLabel = true;
        }
    }

    @Override
    public void launchHistoryChanged() {
        this.fUpdateLabel = true;
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.fUpdateLabel = true;
    }

    public void launchesAdded(ILaunch[] launches) {
        this.fUpdateLabel = true;
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (!launch.isTerminated()) {
                this.fUpdateLabel = true;
                return;
            }
            ++n2;
        }
    }
}

