/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.dialogs.BranchRenameDialog;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;

public class RenameBranchCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List nodes = this.getSelectedNodes(event);
        RepositoryTreeNode node = (RepositoryTreeNode)nodes.get(0);
        Repository repository = node.getRepository();
        Ref branch = null;
        if (node instanceof RefNode) {
            branch = (Ref)node.getObject();
        } else if (node instanceof RepositoryNode) {
            try {
                branch = repository.exactRef("refs/heads/" + repository.getBranch());
            }
            catch (IOException e) {
                Activator.logError("Cannot rename branch", e);
            }
        }
        if (branch != null) {
            Shell shell = this.getShell(event);
            new BranchRenameDialog(shell, repository, branch).open();
        }
        return null;
    }
}

