/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContextManager;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.context.ui.ContextUi;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;

public class ContextEditorManager {
    private final AbstractContextListener contextListener = new AbstractContextListener(){

        public void contextChanged(ContextChangeEvent event) {
            switch (event.getEventKind()) {
                case INTEREST_CHANGED: {
                    for (IInteractionElement element : event.getElements()) {
                        ContextEditorManager.this.closeEditor(element, false);
                    }
                    break;
                }
                case ELEMENTS_DELETED: {
                    for (IInteractionElement element : event.getElements()) {
                        ContextEditorManager.this.closeEditor(element, true);
                    }
                    break;
                }
            }
        }
    };

    public void start(IInteractionContextManager contextManager) {
        contextManager.addListener(this.contextListener);
    }

    public void stop(IInteractionContextManager contextManager) {
        contextManager.removeListener(this.contextListener);
    }

    private void closeEditor(IInteractionElement element, boolean force) {
        AbstractContextStructureBridge bridge;
        if (!this.isEnabled()) {
            return;
        }
        if ((force || !element.getInterest().isInteresting()) && (bridge = ContextCore.getStructureBridge((String)element.getContentType())).isDocument(element.getHandleIdentifier())) {
            AbstractContextUiBridge uiBridge = ContextUi.getUiBridge(element.getContentType());
            uiBridge.close(element);
        }
    }

    private boolean isEnabled() {
        return ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editors.auto.manage");
    }
}

