/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Vector;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.ischema.IMetaElement;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaObjectReference;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.schema.IncludedSchemaDescriptor;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;

public class SchemaElementReference
extends PlatformObject
implements ISchemaElement,
IMetaElement,
ISchemaObjectReference,
ISourceObject,
Serializable {
    private static final long serialVersionUID = 1L;
    private ISchemaElement element;
    private ISchemaCompositor compositor;
    private String referenceName;
    public static final String P_MAX_OCCURS = "max_occurs";
    public static final String P_MIN_OCCURS = "min_occurs";
    public static final String P_REFERENCE_NAME = "reference_name";
    private int minOccurs = 1;
    private int maxOccurs = 1;
    private Vector<String> comments;
    private int[] range;

    public SchemaElementReference(ISchemaCompositor compositor, String ref) {
        this.referenceName = ref;
        this.compositor = compositor;
    }

    @Override
    public ISchemaAttribute getAttribute(String name) {
        if (this.element == null) {
            return null;
        }
        return this.element.getAttribute(name);
    }

    @Override
    public int getAttributeCount() {
        if (this.element == null) {
            return 0;
        }
        return this.element.getAttributeCount();
    }

    @Override
    public ISchemaAttribute[] getAttributes() {
        if (this.element == null) {
            return new ISchemaAttribute[0];
        }
        return this.element.getAttributes();
    }

    @Override
    public String[] getAttributeNames() {
        if (this.element == null) {
            return new String[0];
        }
        return this.element.getAttributeNames();
    }

    public ISchemaCompositor getCompositor() {
        return this.compositor;
    }

    @Override
    public String getDescription() {
        if (this.element == null) {
            return "";
        }
        return this.element.getDescription();
    }

    @Override
    public String getDTDRepresentation(boolean addLinks) {
        if (this.element == null) {
            return PDECoreMessages.SchemaElementReference_refElementMissing;
        }
        return this.element.getDTDRepresentation(addLinks);
    }

    @Override
    public String getIconProperty() {
        if (this.element == null) {
            return "";
        }
        return this.element.getIconProperty();
    }

    @Override
    public String getLabelProperty() {
        if (this.element == null) {
            return "";
        }
        return this.element.getLabelProperty();
    }

    @Override
    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public String getName() {
        return this.referenceName;
    }

    @Override
    public ISchemaObject getParent() {
        return this.compositor;
    }

    @Override
    public void setParent(ISchemaObject parent) {
    }

    public ISchemaElement getReferencedElement() {
        return this.element;
    }

    @Override
    public ISchemaObject getReferencedObject() {
        return this.element;
    }

    public Class<ISchemaElement> getReferencedObjectClass() {
        return ISchemaElement.class;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    @Override
    public ISchema getSchema() {
        ISchemaDescriptor desc;
        ISchema schema;
        if (this.element != null && (schema = this.element.getSchema()) != null && !((desc = schema.getSchemaDescriptor()) instanceof IncludedSchemaDescriptor)) {
            return schema;
        }
        return this.getCompositorsSchema();
    }

    public ISchema getCompositorsSchema() {
        if (this.compositor != null) {
            return this.compositor.getSchema();
        }
        return null;
    }

    @Override
    public ISchemaType getType() {
        if (this.element == null) {
            return null;
        }
        return this.element.getType();
    }

    public boolean isLinked() {
        return this.getReferencedObject() != null;
    }

    public void setCompositor(ISchemaCompositor newCompositor) {
        this.compositor = newCompositor;
    }

    public void setMaxOccurs(int newMaxOccurs) {
        Integer oldValue = this.maxOccurs;
        this.maxOccurs = newMaxOccurs;
        ISchema schema = this.getCompositorsSchema();
        if (schema != null) {
            schema.fireModelObjectChanged(this, P_MAX_OCCURS, oldValue, this.maxOccurs);
        }
    }

    public void setMinOccurs(int newMinOccurs) {
        Integer oldValue = this.minOccurs;
        this.minOccurs = newMinOccurs;
        ISchema schema = this.getCompositorsSchema();
        if (schema != null) {
            schema.fireModelObjectChanged(this, P_MIN_OCCURS, oldValue, this.minOccurs);
        }
    }

    @Override
    public void setReferencedObject(ISchemaObject referencedObject) {
        this.element = referencedObject instanceof ISchemaElement ? (ISchemaElement)referencedObject : null;
    }

    public void setReferenceName(String name) {
        String oldValue = this.referenceName;
        this.referenceName = name;
        ISchema schema = this.getCompositorsSchema();
        if (schema != null) {
            schema.fireModelObjectChanged(this, P_REFERENCE_NAME, oldValue, name);
        }
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        this.writeComments(writer);
        writer.print(String.valueOf(indent) + "<element");
        writer.print(" ref=\"" + this.getReferenceName() + "\"");
        if (this.getMinOccurs() != 1 || this.getMaxOccurs() != 1) {
            String min = "" + this.getMinOccurs();
            String max = this.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : "" + this.getMaxOccurs();
            writer.print(" minOccurs=\"" + min + "\" maxOccurs=\"" + max + "\"");
        }
        writer.println("/>");
    }

    public void addComments(Node node) {
        this.comments = this.addComments(node, this.comments);
    }

    public Vector<String> addComments(Node node, Vector<String> result) {
        Node prev = node.getPreviousSibling();
        while (prev != null) {
            if (prev.getNodeType() != 3) {
                if (!(prev instanceof Comment)) break;
                String comment = prev.getNodeValue();
                if (result == null) {
                    result = new Vector();
                }
                result.add(comment);
            }
            prev = prev.getPreviousSibling();
        }
        return result;
    }

    void writeComments(PrintWriter writer) {
        this.writeComments(writer, this.comments);
    }

    void writeComments(PrintWriter writer, Vector<String> source) {
        if (source == null) {
            return;
        }
        int i = 0;
        while (i < source.size()) {
            String comment = source.elementAt(i);
            writer.println("<!--" + comment + "-->");
            ++i;
        }
    }

    @Override
    public int getStartLine() {
        return this.range == null ? -1 : this.range[0];
    }

    @Override
    public int getStopLine() {
        return this.range == null ? -1 : this.range[1];
    }

    @Override
    public boolean hasTranslatableContent() {
        if (this.element == null) {
            return false;
        }
        return this.element.hasTranslatableContent();
    }

    @Override
    public boolean isDeprecated() {
        if (this.element == null) {
            return false;
        }
        return this.element.isDeprecated();
    }

    @Override
    public boolean hasDeprecatedAttributes() {
        if (this.element == null) {
            return false;
        }
        return this.element.hasDeprecatedAttributes();
    }

    @Override
    public int compareTo(Object arg0) {
        if (this.element == null) {
            return -1;
        }
        if (arg0 == null) {
            return -1;
        }
        return this.element.compareTo(arg0);
    }
}

