/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.dnd.internal.core;

import java.util.Hashtable;
import org.eclipse.gmf.runtime.common.ui.services.dnd.core.AbstractTransferAdapterProvider;
import org.eclipse.gmf.runtime.common.ui.services.dnd.core.SelectionTransfer;
import org.eclipse.gmf.runtime.common.ui.services.dnd.core.TransferAgent;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drag.ITransferDragSourceListener;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drag.SelectionDragAdapter;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drag.TransferDragSourceAdapter;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.ITransferDropTargetListener;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.SelectionDropAdapter;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.TransferDropTargetAdapter;
import org.eclipse.gmf.runtime.common.ui.util.CustomDataTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.part.PluginTransfer;

public final class TransferAdapterProvider
extends AbstractTransferAdapterProvider {
    private Hashtable transferDragSourceTable = new Hashtable();
    private Hashtable transferDropTargetTable = new Hashtable();

    public TransferAdapterProvider() {
        this.getTransferDragSourceTable().put("customDataTransfer".hashCode(), new TransferDragSourceAdapter(new TransferAgent("customDataTransfer", (Transfer)CustomDataTransfer.getInstance(), false)));
        this.getTransferDragSourceTable().put("fileTransfer".hashCode(), new TransferDragSourceAdapter(new TransferAgent("fileTransfer", (Transfer)FileTransfer.getInstance(), false)));
        this.getTransferDragSourceTable().put("pluginTransfer".hashCode(), new TransferDragSourceAdapter(new TransferAgent("pluginTransfer", (Transfer)PluginTransfer.getInstance(), false)));
        this.getTransferDragSourceTable().put("selectionTransfer".hashCode(), new SelectionDragAdapter(new TransferAgent("selectionTransfer", (Transfer)SelectionTransfer.getInstance(), true){

            @Override
            public ISelection getSelection(TransferData transferData) {
                return SelectionTransfer.getInstance().getSelection();
            }

            @Override
            public void setSelection(ISelection selection) {
                SelectionTransfer.getInstance().setSelection(selection);
            }
        }));
        this.getTransferDragSourceTable().put("textTransfer".hashCode(), new TransferDragSourceAdapter(new TransferAgent("textTransfer", (Transfer)TextTransfer.getInstance(), false)));
        this.getTransferDragSourceTable().put("richTextTransfer".hashCode(), new TransferDragSourceAdapter(new TransferAgent("richTextTransfer", (Transfer)RTFTransfer.getInstance(), false)));
        this.getTransferDropTargetTable().put("customDataTransfer".hashCode(), new TransferDropTargetAdapter(new TransferAgent("customDataTransfer", (Transfer)CustomDataTransfer.getInstance(), false)));
        this.getTransferDropTargetTable().put("fileTransfer".hashCode(), new TransferDropTargetAdapter(new TransferAgent("fileTransfer", (Transfer)FileTransfer.getInstance(), false)));
        this.getTransferDropTargetTable().put("pluginTransfer".hashCode(), new TransferDropTargetAdapter(new TransferAgent("pluginTransfer", (Transfer)PluginTransfer.getInstance(), false)));
        this.getTransferDropTargetTable().put("selectionTransfer".hashCode(), new SelectionDropAdapter(new TransferAgent("selectionTransfer", (Transfer)SelectionTransfer.getInstance(), true){

            @Override
            public ISelection getSelection(TransferData transferData) {
                return SelectionTransfer.getInstance().getSelection();
            }
        }));
        this.getTransferDropTargetTable().put("textTransfer".hashCode(), new TransferDropTargetAdapter(new TransferAgent("textTransfer", (Transfer)TextTransfer.getInstance(), false)));
        this.getTransferDropTargetTable().put("richTextTransfer".hashCode(), new TransferDropTargetAdapter(new TransferAgent("richTextTransfer", (Transfer)RTFTransfer.getInstance(), false)));
    }

    @Override
    public ITransferDragSourceListener getTransferDragSourceAdapter(String transferId) {
        assert (transferId != null) : "transferId cannot be null";
        ITransferDragSourceListener listener = null;
        listener = (ITransferDragSourceListener)this.getTransferDragSourceTable().get(transferId.hashCode());
        return listener;
    }

    @Override
    public ITransferDropTargetListener getTransferDropTargetAdapter(String transferId) {
        assert (transferId != null) : "transferId cannot be null";
        ITransferDropTargetListener listener = null;
        listener = (ITransferDropTargetListener)this.getTransferDropTargetTable().get(transferId.hashCode());
        return listener;
    }

    private Hashtable getTransferDragSourceTable() {
        return this.transferDragSourceTable;
    }

    private Hashtable getTransferDropTargetTable() {
        return this.transferDropTargetTable;
    }
}

