/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.OclVoidTypeId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.BagValue;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.ComparableValue;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.IterableValue;
import org.eclipse.ocl.pivot.values.MapValue;
import org.eclipse.ocl.pivot.values.NullValue;
import org.eclipse.ocl.pivot.values.NumberValue;
import org.eclipse.ocl.pivot.values.ObjectValue;
import org.eclipse.ocl.pivot.values.OrderedCollectionValue;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.RealValue;
import org.eclipse.ocl.pivot.values.SequenceValue;
import org.eclipse.ocl.pivot.values.SetValue;
import org.eclipse.ocl.pivot.values.TupleValue;
import org.eclipse.ocl.pivot.values.UniqueCollectionValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.ocl.pivot.values.UnlimitedValue;
import org.eclipse.ocl.pivot.values.Value;

public abstract class UndefinedValueImpl
extends EvaluationException
implements NullValue {
    private static final long serialVersionUID = 1L;

    public UndefinedValueImpl(String message) {
        super(message);
    }

    public UndefinedValueImpl(String messageTemplate, Object ... bindings) {
        super(messageTemplate, bindings);
    }

    public UndefinedValueImpl(@NonNull Throwable e, String message) {
        super(e, message);
    }

    public UndefinedValueImpl(@NonNull Throwable e, String messageTemplate, Object ... bindings) {
        super(e, messageTemplate, bindings);
    }

    @Override
    public @NonNull NullValue abs() {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue addInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue addReal(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull OrderedCollectionValue append(@Nullable Object object) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull OrderedCollectionValue appendAll(@NonNull OrderedCollectionValue objects) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull BagValue asBagValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Bag", this.getTypeName());
    }

    public @NonNull Collection<Object> asCollection() {
        throw new InvalidValueException("Collection value required", new Object[0]);
    }

    @Override
    public @NonNull CollectionValue asCollectionValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Collection", this.getTypeName());
    }

    @Override
    public @NonNull Double asDouble() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Double", this.getTypeName());
    }

    @Override
    public <T> @NonNull List<T> asEcoreObjects(@NonNull IdResolver idResolver, @Nullable Class<T> elementClass) {
        throw new InvalidValueException(this, "asEcoreObjects");
    }

    @Override
    public @NonNull Integer asInteger() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Integer", this.getTypeName());
    }

    @Override
    public @NonNull IntegerValue asIntegerValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Integer", this.getTypeName());
    }

    @Override
    public @NonNull IterableValue asIterableValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Iterable", this.getTypeName());
    }

    public @NonNull List<Object> asList() {
        throw new InvalidValueException("List value required", new Object[0]);
    }

    @Override
    public @NonNull MapValue asMapValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Map", this.getTypeName());
    }

    @Override
    public @NonNull EObject asNavigableObject() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Object", this.getTypeName());
    }

    @Override
    public @NonNull Number asNumber() {
        throw new InvalidValueException("undefined value has no Number value", new Object[0]);
    }

    @Override
    public @NonNull Object asObject() {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull ObjectValue asObjectValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Object", this.getTypeName());
    }

    @Override
    public @NonNull OrderedCollectionValue asOrderedCollectionValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "OrderedCollection", this.getTypeName());
    }

    @Override
    public @NonNull OrderedSetValue asOrderedSetValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "OrderedSet", this.getTypeName());
    }

    @Override
    public @NonNull RealValue asRealValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Real", this.getTypeName());
    }

    @Override
    public @NonNull SequenceValue asSequenceValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Sequence", this.getTypeName());
    }

    @Override
    public @NonNull SetValue asSetValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Set", this.getTypeName());
    }

    @Override
    public @NonNull TupleValue asTupleValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Tuple", this.getTypeName());
    }

    @Override
    public @NonNull UniqueCollectionValue asUniqueCollectionValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Unique Collection", this.getTypeName());
    }

    @Override
    public @NonNull UnlimitedNaturalValue asUnlimitedNaturalValue() {
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "UnlimitedNatural", this.getTypeName());
    }

    @Override
    public @Nullable Value at(int index) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull BigDecimal bigDecimalValue() {
        throw new InvalidValueException("undefined value has no BigDecimal value", new Object[0]);
    }

    @Override
    public @NonNull BigInteger bigIntegerValue() {
        throw new InvalidValueException("undefined value has no BigInteger value", new Object[0]);
    }

    @Override
    public @NonNull RealValue commutatedAdd(@NonNull RealValue left) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull IntegerValue commutatedDiv(@NonNull IntegerValue left) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull RealValue commutatedDivide(@NonNull RealValue left) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull IntegerValue commutatedMod(@NonNull IntegerValue left) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull RealValue commutatedMultiply(@NonNull RealValue left) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull RealValue commutatedSubtract(@NonNull RealValue left) {
        return this.toInvalidValue();
    }

    @Override
    public int commutatedCompareTo(@NonNull ComparableValue<?> left) {
        return ValueUtil.throwUnsupportedCompareTo(left, this);
    }

    @Override
    public int commutatedCompareToInteger(@NonNull IntegerValue left) {
        return ValueUtil.throwUnsupportedCompareTo(left, this);
    }

    @Override
    public int commutatedCompareToReal(@NonNull RealValue left) {
        return ValueUtil.throwUnsupportedCompareTo(left, this);
    }

    @Override
    public int compareTo(@Nullable NumberValue right) {
        return ValueUtil.throwUnsupportedCompareTo(this, right);
    }

    @Override
    public @NonNull IntegerValue count(@Nullable Object value) {
        return this.toInvalidValue();
    }

    public @NonNull CollectionValue createNew() {
        return this.toInvalidValue();
    }

    public @NonNull NullValue div(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue divInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue divUnlimited(@NonNull UnlimitedValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull RealValue divideInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue divideReal(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    public double doubleValue() {
        throw new UnsupportedOperationException("InvalidValue.compareTo");
    }

    @Override
    public @NonNull Boolean excludes(@Nullable Object value) {
        throw new InvalidValueException(PivotMessages.ConvertibleValueRequired, "Invalid");
    }

    @Override
    public @NonNull Boolean excludesAll(@NonNull CollectionValue c) {
        throw new InvalidValueException(PivotMessages.ConvertibleValueRequired, "Invalid");
    }

    @Override
    public @NonNull CollectionValue excluding(@Nullable Object value) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull CollectionValue excludingAll(@NonNull CollectionValue c) {
        return this.toInvalidValue();
    }

    @Override
    public @Nullable Value first() {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull CollectionValue flatten() {
        return this.toInvalidValue();
    }

    @Override
    public boolean flatten(@NonNull Collection<Object> flattenedElements) {
        return false;
    }

    @Override
    public @NonNull NullValue floor() {
        return this.toInvalidValue();
    }

    public Type getElement() {
        return null;
    }

    public @NonNull List<? extends Object> getElements() {
        throw new InvalidValueException("bad getElements()", new Object[0]);
    }

    public @NonNull Type getInstanceType() {
        throw new InvalidValueException("undefined value has no instance type", new Object[0]);
    }

    @Override
    public String getKind() {
        return "Collection";
    }

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public abstract @NonNull OclVoidTypeId getTypeId();

    public @NonNull String getTypeName() {
        return this.getTypeId().getDisplayName();
    }

    @Override
    public @NonNull Value getValue(@NonNull TuplePartId partId) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull Object getValue(int index) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull Boolean includes(@Nullable Object value) {
        throw new InvalidValueException(PivotMessages.ConvertibleValueRequired, "Invalid");
    }

    @Override
    public @NonNull Boolean includesAll(@NonNull CollectionValue c) {
        throw new InvalidValueException(PivotMessages.ConvertibleValueRequired, "Invalid");
    }

    @Override
    public @NonNull CollectionValue including(@Nullable Object value) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull CollectionValue includingAll(@NonNull CollectionValue c) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull IntegerValue indexOf(@Nullable Object object) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull SequenceValue insertAt(int index, @Nullable Object object) {
        return this.toInvalidValue();
    }

    @Override
    public int intSize() {
        return 0;
    }

    @Override
    public @NonNull CollectionValue intersection(@NonNull CollectionValue c) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull Boolean isEmpty() {
        throw new InvalidValueException(PivotMessages.ConvertibleValueRequired, "Invalid");
    }

    public boolean isFalse() {
        return false;
    }

    @Override
    public @Nullable IntegerValue isIntegerValue() {
        return null;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    @Override
    public boolean isUndefined() {
        return true;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean isUnlimited() {
        return false;
    }

    @Override
    public boolean isUnlimitedNatural() {
        return false;
    }

    @Override
    public @Nullable UnlimitedNaturalValue isUnlimitedNaturalValue() {
        return null;
    }

    @Override
    public @NonNull Iterable<? extends Object> iterable() {
        return Collections.emptyList();
    }

    public @NonNull Iterator iterator() {
        return new Iterator();
    }

    @Override
    public @Nullable Value last() {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue max(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue max(@NonNull UnlimitedNaturalValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue maxInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue maxReal(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue maxUnlimited(@NonNull UnlimitedNaturalValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue min(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue min(@NonNull UnlimitedNaturalValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue minInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue minReal(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue minUnlimited(@NonNull UnlimitedNaturalValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue minus(@NonNull UniqueCollectionValue set) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue modInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue modUnlimited(@NonNull UnlimitedValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue multiplyInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue multiplyReal(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue negate() {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull Boolean notEmpty() {
        throw new InvalidValueException(PivotMessages.ConvertibleValueRequired, "Invalid");
    }

    @Override
    public @NonNull OrderedCollectionValue prepend(@Nullable Object object) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull OrderedCollectionValue prependAll(@NonNull OrderedCollectionValue objects) {
        return this.toInvalidValue();
    }

    @Override
    public @Nullable Set<TupleValue> product(@NonNull CollectionValue c, @NonNull TupleTypeId tupleTypeId) {
        return null;
    }

    @Override
    public @NonNull OrderedCollectionValue reverse() {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue round() {
        return this.toInvalidValue();
    }

    @Override
    public int signum() {
        throw new UnsupportedOperationException("InvalidValue.compareTo");
    }

    @Override
    public @NonNull IntegerValue size() {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull SequenceValue sort(@NonNull Comparator<Object> comparator) {
        return this.toInvalidValue();
    }

    public @NonNull String stringValue() {
        throw new InvalidValueException("undefined value has no String value", new Object[0]);
    }

    @Override
    public @NonNull NullValue subOrderedSet(int lower, int upper) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue subSequence(int lower, int upper) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue subtractInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue subtractReal(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    public @NonNull NullValue symmetricDifference(@NonNull UniqueCollectionValue set) {
        return this.toInvalidValue();
    }

    protected @NonNull NullValue toInvalidValue() {
        throw new InvalidValueException(PivotMessages.ConvertibleValueRequired, "Invalid");
    }

    @Override
    public @NonNull SequenceValue toSequenceValue() {
        return this;
    }

    @Override
    public void toString(@NonNull StringBuilder s, int sizeLimit) {
        s.append(this.toString());
    }

    @Override
    public @NonNull CollectionValue union(@NonNull CollectionValue c) {
        return this;
    }

    private static class Iterator
    implements java.util.Iterator<Object> {
        private Iterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

