/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl.delta;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.delta.IDBDelta;
import org.eclipse.net4j.db.ddl.delta.IDBDeltaVisitor;
import org.eclipse.net4j.db.ddl.delta.IDBPropertyDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBDelta;

public final class DBPropertyDelta<T>
extends DBDelta
implements IDBPropertyDelta<T> {
    private static final long serialVersionUID = 1L;
    private IDBPropertyDelta.Type type;
    private T value;
    private T oldValue;

    public DBPropertyDelta(DBDelta parent, String name, IDBPropertyDelta.Type type, T value, T oldValue) {
        super(parent, name, DBDelta.getChangeKind(value, oldValue));
        this.type = type;
        this.value = value;
        this.oldValue = oldValue;
    }

    protected DBPropertyDelta() {
    }

    @Override
    public IDBDelta.DeltaType getDeltaType() {
        return IDBDelta.DeltaType.PROPERTY;
    }

    @Override
    public IDBSchemaElement getSchemaElement(IDBSchema schema) {
        return null;
    }

    @Override
    public IDBPropertyDelta.Type getType() {
        return this.type;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public T getOldValue() {
        return this.oldValue;
    }

    @Override
    public String toString() {
        return MessageFormat.format("DBPropertyDelta[name={0}, kind={1}, type={2}, value={3}, oldValue={4}]", new Object[]{this.getName(), this.getChangeKind(), this.getType(), this.getValue(), this.getOldValue()});
    }

    @Override
    protected void doAccept(IDBDeltaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void collectElements(List<IDBDelta> elements) {
    }

    @Override
    protected void dumpAdditionalProperties(Writer writer) throws IOException {
        writer.append(", type=");
        writer.append(this.getType().toString());
        writer.append(", value=");
        writer.append(DBPropertyDelta.toString(this.getValue()));
        writer.append(", oldValue=");
        writer.append(DBPropertyDelta.toString(this.getOldValue()));
    }

    private static CharSequence toString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString();
    }
}

