/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.E4PartWrapper;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.internal.handlers.AbstractSaveHandler;
import org.osgi.service.event.Event;

public class SelectionService
implements ISelectionChangedListener,
ISelectionService {
    @Inject
    private IEclipseContext context;
    @Inject
    private MApplication application;
    private ESelectionService selectionService;
    @Inject
    @Optional
    @Named(value="org.eclipse.ui.IWorkbenchPage")
    private WorkbenchPage page;
    private IWorkbenchPart activePart;
    private ListenerList<ISelectionListener> listeners = new ListenerList();
    private ListenerList<ISelectionListener> postSelectionListeners = new ListenerList();
    private Map<String, Set<ISelectionListener>> targetedListeners = new HashMap<String, Set<ISelectionListener>>();
    private Map<String, Set<ISelectionListener>> targetedPostSelectionListeners = new HashMap<String, Set<ISelectionListener>>();
    private org.eclipse.e4.ui.workbench.modeling.ISelectionListener listener = (part, selection) -> this.handleSelectionChanged(part, selection, false);
    private org.eclipse.e4.ui.workbench.modeling.ISelectionListener targetedListener = (part, selection) -> this.handleSelectionChanged(part, selection, true);
    private org.eclipse.e4.ui.workbench.modeling.ISelectionListener postListener = (part, selection) -> this.handlePostSelectionChanged(part, selection, false);
    private org.eclipse.e4.ui.workbench.modeling.ISelectionListener targetedPostListener = (part, selection) -> this.handlePostSelectionChanged(part, selection, true);

    private void handleSelectionChanged(MPart part, Object selection, boolean targeted) {
        Object client;
        selection = SelectionService.createCompatibilitySelection(selection);
        this.context.set("selection", selection);
        IEclipseContext applicationContext = this.application.getContext();
        if (applicationContext.getActiveChild() == this.context) {
            this.application.getContext().set("selection", selection);
        }
        if ((client = part.getObject()) instanceof CompatibilityPart) {
            IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
            if (targeted) {
                this.notifyListeners(workbenchPart, (ISelection)selection, part.getElementId(), this.targetedListeners);
            } else {
                this.notifyListeners(workbenchPart, (ISelection)selection, this.listeners);
            }
        } else if (client != null && part.getTransientData().get("e4Wrapper") instanceof E4PartWrapper) {
            IWorkbenchPart workbenchPart = (IWorkbenchPart)part.getTransientData().get("e4Wrapper");
            if (targeted) {
                this.notifyListeners(workbenchPart, (ISelection)selection, part.getElementId(), this.targetedListeners);
            } else {
                this.notifyListeners(workbenchPart, (ISelection)selection, this.listeners);
            }
        }
    }

    private void handlePostSelectionChanged(MPart part, Object selection, boolean targeted) {
        selection = SelectionService.createCompatibilitySelection(selection);
        Object client = part.getObject();
        if (client instanceof CompatibilityPart) {
            IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
            if (targeted) {
                this.notifyListeners(workbenchPart, (ISelection)selection, part.getElementId(), this.targetedPostSelectionListeners);
            } else {
                this.notifyListeners(workbenchPart, (ISelection)selection, this.postSelectionListeners);
            }
        } else if (client != null && part.getTransientData().get("e4Wrapper") instanceof E4PartWrapper) {
            IWorkbenchPart workbenchPart = (IWorkbenchPart)part.getTransientData().get("e4Wrapper");
            if (targeted) {
                this.notifyListeners(workbenchPart, (ISelection)selection, part.getElementId(), this.targetedPostSelectionListeners);
            } else {
                this.notifyListeners(workbenchPart, (ISelection)selection, this.postSelectionListeners);
            }
        }
    }

    private static ISelection createCompatibilitySelection(Object selection) {
        if (selection instanceof ISelection) {
            return (ISelection)selection;
        }
        return selection == null ? StructuredSelection.EMPTY : new StructuredSelection(selection);
    }

    public void updateSelection(IWorkbenchPart activePart) {
        ISelectionProvider selectionProvider;
        if (activePart != null && (selectionProvider = activePart.getSite().getSelectionProvider()) != null) {
            ISelection selection = selectionProvider.getSelection();
            this.context.set("selection", (Object)selection);
            IEclipseContext applicationContext = this.application.getContext();
            if (applicationContext.getActiveChild() == this.context) {
                this.application.getContext().set("selection", (Object)selection);
            }
        }
    }

    public void notifyListeners(IWorkbenchPart activePart) {
        ISelectionProvider selectionProvider;
        if (activePart != null && (selectionProvider = activePart.getSite().getSelectionProvider()) != null) {
            ISelection selection = selectionProvider.getSelection();
            this.notifyListeners(activePart, selection, this.listeners);
            this.notifyListeners(activePart, selection, activePart.getSite().getId(), this.targetedListeners);
            this.notifyListeners(activePart, selection, this.postSelectionListeners);
            this.notifyListeners(activePart, selection, activePart.getSite().getId(), this.targetedPostSelectionListeners);
        }
    }

    @Inject
    void setPart(@Optional @Named(value="e4ActivePart") @Named(value="e4ActivePart") MPart part) {
        this.activePart = null;
        if (part != null) {
            Object client = part.getObject();
            if (client instanceof CompatibilityPart) {
                IWorkbenchPart workbenchPart;
                this.activePart = workbenchPart = ((CompatibilityPart)client).getPart();
            } else if (client != null && part.getTransientData().get("e4Wrapper") instanceof E4PartWrapper) {
                this.activePart = (IWorkbenchPart)part.getTransientData().get("e4Wrapper");
            }
        }
    }

    @Inject
    @Optional
    void subscribeTopicDirtyChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*") Event event) {
        Object objElement = event.getProperty("ChangedElement");
        if (!(objElement instanceof MPart)) {
            return;
        }
        MPart part = (MPart)objElement;
        Object wrapperPart = part.getTransientData().get("e4Wrapper");
        if (wrapperPart instanceof E4PartWrapper) {
            E4PartWrapper wrapper = (E4PartWrapper)wrapperPart;
            try {
                wrapper.addPropertyListener(AbstractSaveHandler.getDirtyStateTracker());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            wrapper.notifyPartDirtyStatus();
        }
    }

    @Inject
    void setSelectionService(@Optional ESelectionService selectionService) {
        if (this.selectionService != null) {
            this.selectionService.removeSelectionListener(this.listener);
            for (String partId : this.targetedListeners.keySet()) {
                this.selectionService.removeSelectionListener(partId, this.targetedListener);
            }
            this.selectionService.removePostSelectionListener(this.postListener);
            for (String partId : this.targetedPostSelectionListeners.keySet()) {
                this.selectionService.removePostSelectionListener(partId, this.targetedPostListener);
            }
        }
        if (selectionService != null) {
            selectionService.addSelectionListener(this.listener);
            for (String partId : this.targetedListeners.keySet()) {
                selectionService.addSelectionListener(partId, this.targetedListener);
            }
            selectionService.addPostSelectionListener(this.postListener);
            for (String partId : this.targetedPostSelectionListeners.keySet()) {
                selectionService.addPostSelectionListener(partId, this.targetedPostListener);
            }
            this.selectionService = selectionService;
        }
    }

    @PreDestroy
    public void dispose() {
        this.setSelectionService(null);
        this.selectionService = null;
        this.listeners.clear();
        this.postSelectionListeners.clear();
        this.targetedListeners.clear();
        this.targetedPostSelectionListeners.clear();
    }

    private void notifyListeners(IWorkbenchPart workbenchPart, ISelection selection, ListenerList<ISelectionListener> listenerList) {
        for (ISelectionListener listener : listenerList) {
            if (selection == null && !(listener instanceof INullSelectionListener)) continue;
            listener.selectionChanged(workbenchPart, selection);
        }
    }

    private void notifyListeners(IWorkbenchPart workbenchPart, ISelection selection, String id, Map<String, Set<ISelectionListener>> listenerMap) {
        Set<ISelectionListener> listeners;
        if (id != null && (listeners = listenerMap.get(id)) != null) {
            for (ISelectionListener listener : listeners) {
                if (selection == null && !(listener instanceof INullSelectionListener)) continue;
                listener.selectionChanged(workbenchPart, selection);
            }
        }
    }

    @Override
    public void addSelectionListener(ISelectionListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void addSelectionListener(String partId, ISelectionListener listener) {
        Set<ISelectionListener> listeners = this.targetedListeners.get(partId);
        if (listeners == null) {
            listeners = new HashSet<ISelectionListener>();
            this.targetedListeners.put(partId, listeners);
        }
        if (listeners.isEmpty() && this.selectionService != null) {
            this.selectionService.addSelectionListener(partId, this.targetedListener);
        }
        listeners.add(listener);
    }

    @Override
    public void addPostSelectionListener(ISelectionListener listener) {
        this.postSelectionListeners.add((Object)listener);
    }

    @Override
    public void addPostSelectionListener(String partId, ISelectionListener listener) {
        Set<ISelectionListener> listeners = this.targetedPostSelectionListeners.get(partId);
        if (listeners == null) {
            listeners = new HashSet<ISelectionListener>();
            this.targetedPostSelectionListeners.put(partId, listeners);
        }
        if (listeners.isEmpty() && this.selectionService != null) {
            this.selectionService.addPostSelectionListener(partId, this.targetedPostListener);
        }
        listeners.add(listener);
    }

    @Override
    public ISelection getSelection() {
        if (this.activePart != null) {
            ISelectionProvider selectionProvider = this.activePart.getSite().getSelectionProvider();
            return selectionProvider == null ? null : selectionProvider.getSelection();
        }
        Object selection = this.selectionService.getSelection();
        if (selection == null || selection instanceof ISelection) {
            return (ISelection)selection;
        }
        return new StructuredSelection(selection);
    }

    @Override
    public ISelection getSelection(String partId) {
        Object selection = this.selectionService.getSelection(partId);
        if (selection == null || selection instanceof ISelection) {
            return (ISelection)selection;
        }
        return new StructuredSelection(selection);
    }

    @Override
    public void removeSelectionListener(ISelectionListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void removeSelectionListener(String partId, ISelectionListener listener) {
        Set<ISelectionListener> listeners = this.targetedListeners.get(partId);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty() && this.selectionService != null) {
                this.selectionService.removeSelectionListener(partId, this.targetedListener);
            }
        }
    }

    @Override
    public void removePostSelectionListener(ISelectionListener listener) {
        this.postSelectionListeners.remove((Object)listener);
    }

    @Override
    public void removePostSelectionListener(String partId, ISelectionListener listener) {
        Set<ISelectionListener> listeners = this.targetedPostSelectionListeners.get(partId);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty() && this.selectionService != null) {
                this.selectionService.removePostSelectionListener(partId, this.targetedPostListener);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent e) {
        MPart part = this.page.findPart(this.activePart);
        ESelectionService selectionService = (ESelectionService)part.getContext().get(ESelectionService.class);
        selectionService.setSelection((Object)e.getSelection());
    }
}

