/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.oclforuml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Overflow implements Enumerator
{
    INVALID(0, "invalid", "invalid"),
    SATURATE(1, "saturate", "saturate"),
    MODULO(2, "modulo", "modulo");

    public static final int INVALID_VALUE = 0;
    public static final int SATURATE_VALUE = 1;
    public static final int MODULO_VALUE = 2;
    private static final Overflow[] VALUES_ARRAY;
    public static final List<Overflow> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Overflow[]{INVALID, SATURATE, MODULO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Overflow get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Overflow result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Overflow getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Overflow result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Overflow get(int value) {
        switch (value) {
            case 0: {
                return INVALID;
            }
            case 1: {
                return SATURATE;
            }
            case 2: {
                return MODULO;
            }
        }
        return null;
    }

    private Overflow(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

