/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x;

import java.util.Collection;
import org.eclipse.e4.tools.emf.editor3x.Messages;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.jface.action.Action;

public class UndoAction
extends Action {
    private final IModelResource resource;
    private final IModelResource.ModelListener listener;

    public UndoAction(IModelResource resource) {
        this.resource = resource;
        this.listener = new IModelResource.ModelListener(){

            public void commandStackChanged() {
                UndoAction.this.update();
            }

            public void dirtyChanged() {
            }
        };
        resource.addModelListener(this.listener);
        this.update();
    }

    public void run() {
        if (this.resource.getEditingDomain().getCommandStack().canUndo()) {
            this.resource.getEditingDomain().getCommandStack().undo();
        }
    }

    private void update() {
        if (this.resource.getEditingDomain().getCommandStack().canUndo()) {
            Command undoCommand = this.resource.getEditingDomain().getCommandStack().getUndoCommand();
            String label = UndoAction.getCommandLabel(undoCommand);
            this.setText(String.valueOf(Messages.UndoAction_Undo) + " " + label);
            this.setEnabled(true);
        } else {
            this.setText(Messages.UndoAction_Undo);
            this.setEnabled(false);
        }
    }

    public static String getCommandLabel(Command cmd) {
        if (cmd instanceof SetCommand) {
            SetCommand sc = (SetCommand)cmd;
            return String.valueOf(sc.getLabel()) + " " + sc.getFeature().getName() + " on " + sc.getOwner().eClass().getName();
        }
        if (cmd instanceof AddCommand) {
            AddCommand ac = (AddCommand)cmd;
            return String.valueOf(ac.getLabel()) + " " + UndoAction.getFirstClassName(ac.getCollection());
        }
        if (cmd instanceof DeleteCommand) {
            DeleteCommand dc = (DeleteCommand)cmd;
            Collection deleted = dc.getCollection();
            if (deleted.size() == 1) {
                return String.valueOf(dc.getLabel()) + " " + UndoAction.getFirstClassName(deleted);
            }
            return String.valueOf(dc.getLabel()) + " " + dc.getCollection().size() + " Objects";
        }
        return cmd.getLabel();
    }

    private static String getFirstClassName(Collection<?> c) {
        Object o = c.iterator().next();
        String clname = o instanceof EObject ? ((EObject)o).eClass().getName() : "";
        String dname = o instanceof MUILabel ? ((MUILabel)o).getLabel() : "";
        return String.valueOf(clname) + " " + (dname == null ? "" : dname);
    }

    public void dispose() {
        this.resource.removeModelListener(this.listener);
    }
}

