/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DifferenceKind implements Enumerator
{
    ADD(0, "ADD", "ADD"),
    DELETE(1, "DELETE", "DELETE"),
    CHANGE(2, "CHANGE", "CHANGE"),
    MOVE(3, "MOVE", "MOVE");

    public static final String copyright = "Copyright (c) 2012 Obeo.\r\nAll rights reserved. This program and the accompanying materials\r\nare made available under the terms of the Eclipse Public License v1.0\r\nwhich accompanies this distribution, and is available at\r\nhttp://www.eclipse.org/legal/epl-v10.html\r\n\r\nContributors:\r\n    Obeo - initial API and implementation";
    public static final int ADD_VALUE = 0;
    public static final int DELETE_VALUE = 1;
    public static final int CHANGE_VALUE = 2;
    public static final int MOVE_VALUE = 3;
    private static final DifferenceKind[] VALUES_ARRAY;
    public static final List<DifferenceKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DifferenceKind[]{ADD, DELETE, CHANGE, MOVE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DifferenceKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DifferenceKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DifferenceKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DifferenceKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DifferenceKind get(int value) {
        switch (value) {
            case 0: {
                return ADD;
            }
            case 1: {
                return DELETE;
            }
            case 2: {
                return CHANGE;
            }
            case 3: {
                return MOVE;
            }
        }
        return null;
    }

    private DifferenceKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

