/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.emf.validation.ui.internal.l10n.ValidationUIMessages;
import org.eclipse.emf.validation.ui.internal.preferences.AbstractCategoryTreeNode;
import org.eclipse.emf.validation.ui.internal.preferences.ConstraintNode;
import org.eclipse.emf.validation.ui.internal.preferences.ICategoryTreeNode;
import org.eclipse.emf.validation.ui.internal.preferences.IConstraintNode;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.osgi.util.NLS;

public class CategoryTreeNode
extends AbstractCategoryTreeNode {
    private boolean grayed;
    private boolean checked;
    private ICategoryTreeNode delegate;
    private List<IConstraintNode> constraints;

    private CategoryTreeNode(CheckboxTreeViewer tree, Category category, ICategoryTreeNode parent, IConstraintFilter filter) {
        super(tree, category, parent, filter);
    }

    public static ICategoryTreeNode createRoot(CheckboxTreeViewer tree, final IConstraintFilter filter) {
        IConstraintFilter registeredOnly = new IConstraintFilter(){

            public boolean accept(IConstraintDescriptor constraint, EObject target) {
                if (ConstraintRegistry.getInstance().getDescriptor(constraint.getId()) == constraint) {
                    return filter.accept(constraint, target);
                }
                return false;
            }
        };
        RootNode result = new RootNode(tree, registeredOnly);
        result.revertFromPreferences();
        return result;
    }

    @Override
    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public boolean isGrayed() {
        return this.grayed;
    }

    @Override
    protected List<ICategoryTreeNode> createChildren() {
        ArrayList<ICategoryTreeNode> result;
        Category category = this.getCategory();
        SortedSet categoryChildren = category.getChildren();
        if (!categoryChildren.isEmpty() && !CategoryTreeNode.getConstraints(category, this.getFilter()).isEmpty()) {
            result = new ArrayList(categoryChildren.size() + 1);
            this.delegate = new DelegateNode(this.getTree(), category, this, this.getFilter());
            result.add(this.delegate);
        } else {
            result = new ArrayList<ICategoryTreeNode>(categoryChildren.size());
        }
        for (Category next : categoryChildren) {
            if (this.isRecursivelyEmpty(next)) continue;
            result.add(new CategoryTreeNode(this.getTree(), next, this, this.getFilter()));
        }
        return result;
    }

    @Override
    public void checkStateChanged(CheckStateChangedEvent event) {
        boolean newState = event.getChecked();
        if (this.isGrayed()) {
            this.internalSetChecked(true);
        } else {
            this.internalSetChecked(newState);
        }
    }

    protected void internalSetChecked(boolean newState) {
        this.checked = !this.hasDelegate() && this.getCategory().isMandatory() ? true : newState;
        this.grayed = false;
        this.propagateToConstraints(newState);
        this.propagateDown(newState);
        this.updateTree();
    }

    private void propagateToConstraints(boolean newChecked) {
        if (!this.hasDelegate()) {
            for (IConstraintNode next : this.getConstraints()) {
                next.setChecked(newChecked);
            }
        }
    }

    private void updateTree() {
        CheckboxTreeViewer tree = this.getTree();
        if (tree.getChecked((Object)this) != this.isChecked()) {
            tree.setChecked((Object)this, this.isChecked());
        }
        if (tree.getGrayed((Object)this) != this.isGrayed()) {
            tree.setGrayed((Object)this, this.isGrayed());
        }
        this.updateParent();
    }

    private void updateParent() {
        if (this.getParent() != null) {
            this.getParent().updateCheckState(this);
        }
    }

    @Override
    public void updateCheckState(ICategoryTreeNode child) {
        if (child.isGrayed()) {
            this.grayed = true;
            this.checked = true;
            this.updateTree();
        } else {
            boolean newValue = child.isChecked();
            ICategoryTreeNode[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i].isGrayed() || children[i].isChecked() != newValue) {
                    this.grayed = true;
                    this.checked = true;
                    this.updateTree();
                    return;
                }
                ++i;
            }
            this.grayed = false;
            this.checked = newValue;
            this.updateTree();
        }
    }

    @Override
    public void updateCheckState(IConstraintNode constraint) {
        boolean newValue;
        boolean newChecked = newValue = constraint.isChecked();
        boolean newGrayed = false;
        for (IConstraintNode next : this.getConstraints()) {
            if (next == constraint || next.isChecked() == newValue) continue;
            newGrayed = true;
            newChecked = true;
            break;
        }
        this.checked = newChecked;
        this.grayed = newGrayed;
        this.updateTree();
    }

    private void propagateDown(boolean checkedState) {
        ICategoryTreeNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            ((CategoryTreeNode)children[i]).internalSetChecked(checkedState);
            ++i;
        }
    }

    @Override
    public void applyToPreferences() {
        if (!this.hasDelegate()) {
            for (IConstraintNode next : this.getConstraints()) {
                next.applyToPreferences();
            }
        }
        super.applyToPreferences();
    }

    @Override
    public void revertFromPreferences() {
        if (!this.hasDelegate()) {
            IConstraintNode node2 = null;
            for (IConstraintNode node2 : this.getConstraints()) {
                node2.revertFromPreferences();
            }
            if (node2 != null) {
                this.updateCheckState(node2);
            }
        }
        super.revertFromPreferences();
    }

    @Override
    public void restoreDefaults() {
        if (!this.hasDelegate()) {
            IConstraintNode node2 = null;
            for (IConstraintNode node2 : this.getConstraints()) {
                node2.restoreDefaults();
            }
            if (node2 != null) {
                this.updateCheckState(node2);
            }
        }
        super.restoreDefaults();
    }

    @Override
    public Category getCategory() {
        if (this.hasDelegate()) {
            return null;
        }
        return super.getCategory();
    }

    @Override
    public List<IConstraintNode> getConstraints() {
        if (this.hasDelegate()) {
            this.constraints = Collections.emptyList();
        } else if (this.constraints == null) {
            Set<IConstraintDescriptor> descriptors = CategoryTreeNode.getConstraints(this.getCategory(), this.getFilter());
            this.constraints = new ArrayList<IConstraintNode>(descriptors.size());
            for (IConstraintDescriptor next : descriptors) {
                IConstraintNode node = ConstraintNode.getInstance(next);
                node.addCategory(this);
                this.constraints.add(node);
            }
        }
        return this.constraints;
    }

    @Override
    public IConstraintNode[] getSelectedConstraints() {
        ArrayList<IConstraintNode> result = new ArrayList<IConstraintNode>(this.getConstraints().size());
        for (IConstraintNode next : this.getConstraints()) {
            if (!next.isChecked()) continue;
            result.add(next);
        }
        return result.toArray(new IConstraintNode[result.size()]);
    }

    private boolean hasDelegate() {
        return this.delegate != null;
    }

    @Override
    public String toString() {
        if (this.getCategory() == null && this.hasDelegate()) {
            return this.delegate.getCategory().getName();
        }
        return super.toString();
    }

    private static class DelegateNode
    extends CategoryTreeNode {
        DelegateNode(CheckboxTreeViewer tree, Category category, ICategoryTreeNode parent, IConstraintFilter filter) {
            super(tree, category, parent, filter);
        }

        @Override
        protected List<ICategoryTreeNode> createChildren() {
            return Collections.emptyList();
        }

        @Override
        public String toString() {
            String result = super.toString();
            StringBuffer buf = new StringBuffer(result.length() + 2);
            buf.append(NLS.bind((String)ValidationUIMessages.prefs_delegate_name, (Object[])new Object[]{result}));
            result = buf.toString();
            return result;
        }
    }

    private static class RootNode
    extends AbstractCategoryTreeNode {
        RootNode(CheckboxTreeViewer tree, IConstraintFilter filter) {
            super(tree, null, null, filter);
        }

        @Override
        protected List<ICategoryTreeNode> createChildren() {
            SortedSet topLevel = CategoryManager.getInstance().getTopLevelCategories();
            ArrayList<ICategoryTreeNode> result = new ArrayList<ICategoryTreeNode>(topLevel.size());
            for (Category next : topLevel) {
                if (this.isRecursivelyEmpty(next)) continue;
                result.add(new CategoryTreeNode(this.getTree(), next, this, this.getFilter()));
            }
            return result;
        }

        @Override
        public boolean isChecked() {
            return false;
        }

        @Override
        public boolean isGrayed() {
            return false;
        }

        @Override
        public void checkStateChanged(CheckStateChangedEvent event) {
        }

        @Override
        public void updateCheckState(ICategoryTreeNode child) {
        }

        @Override
        public void updateCheckState(IConstraintNode constraint) {
        }

        @Override
        public String getDescription() {
            return "";
        }

        @Override
        public List<IConstraintNode> getConstraints() {
            return Collections.emptyList();
        }
    }
}

