/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.text.MessageFormat;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class BranchNameNormalizer {
    private static final String UNDERSCORE = "_";
    private static final String REGEX_BLANK = "\\h|\\v";
    private static final char[] BRANCH_NAME_NORMALIZER_ACTIVATION_CHARS = "\\~^:?[*@<>|\"".toCharArray();
    private final ControlDecoration decorator;
    private boolean visible;

    public BranchNameNormalizer(Text text) {
        this(text, UIText.BranchNameNormalizer_Tooltip);
    }

    public BranchNameNormalizer(Text text, String tooltipText) {
        KeyStroke stroke = UIUtils.getKeystrokeOfBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (stroke == null) {
            stroke = KeyStroke.getInstance((int)SWT.MOD1, (int)32);
        }
        this.decorator = tooltipText == null || tooltipText.isEmpty() ? UIUtils.addBulbDecorator((Control)text, null) : UIUtils.addBulbDecorator((Control)text, MessageFormat.format(tooltipText, stroke.format()));
        this.decorator.hide();
        ContentProposalAdapter proposer = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (c, p) -> {
            if (c.isEmpty() || Repository.isValidRefName((String)("refs/heads/" + c))) {
                return null;
            }
            String normalized = Repository.normalizeBranchName((String)c);
            if (normalized == null || normalized.isEmpty()) {
                return new ContentProposal[0];
            }
            return new ContentProposal[]{new ContentProposal(normalized)};
        }, stroke, BRANCH_NAME_NORMALIZER_ACTIVATION_CHARS);
        proposer.setProposalAcceptanceStyle(2);
        text.addVerifyListener(e -> {
            String string = e.text = e.text.replaceAll(REGEX_BLANK, UNDERSCORE);
        });
        text.addModifyListener(e -> {
            String input = text.getText();
            boolean doProposeCorrection = !input.isEmpty() && !Repository.isValidRefName((String)("refs/heads/" + input));
            this.setVisible(doProposeCorrection);
        });
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (visible) {
            this.decorator.show();
        } else {
            this.decorator.hide();
        }
    }
}

