/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal.oauth.ui;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;

public class OAuthApplicationData {
    private String authURI;
    private String clientId;
    private String applicationName;
    private String imageURI;

    public static Collection<OAuthApplicationData> load(IExtensionRegistry registry) {
        String OAUTH_APPLICATION_DESCRIPTIONS_XP = "org.eclipse.userstorage.oauth.clients";
        ArrayList<OAuthApplicationData> data = new ArrayList<OAuthApplicationData>();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor("org.eclipse.userstorage.oauth.clients");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("client".equals(element.getName()) && element.getAttribute("id") != null) {
                OAuthApplicationData d = new OAuthApplicationData();
                d.clientId = element.getAttribute("id");
                d.authURI = element.getAttribute("authURI");
                d.applicationName = element.getAttribute("name");
                if (element.getAttribute("icon") != null) {
                    d.imageURI = "platform:/plugin/" + element.getNamespaceIdentifier() + "/" + element.getAttribute("icon");
                }
                data.add(d);
            }
            ++n2;
        }
        return data;
    }

    public String getAuthURI() {
        return this.authURI;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getImageURI() {
        return this.imageURI;
    }
}

