/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.EdgeWithNoSemanticElementRepresentationImpl;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.StereotypePropertyReferenceEdgeRepresentation;

public class Domain2Notation
extends HashMap<EObject, Set<View>> {
    public void mapModel(View view) {
        if ((view instanceof Connector || view instanceof Shape) && !(view instanceof BasicCompartment)) {
            this.putView(view);
        }
        EList children = view.getChildren();
        for (View child : children) {
            this.mapModel(child);
        }
        EList sourceEdges = view.getSourceEdges();
        for (View edge : sourceEdges) {
            this.mapModel(edge);
        }
    }

    public void putView(View view) {
        Set set;
        Object element = view.getElement();
        if (element == null && view instanceof Connector) {
            EObject source = ((Connector)view).getSource().getElement();
            EObject target = ((Connector)view).getTarget().getElement();
            if (view.getType().equals("StereotypePropertyReferenceEdge")) {
                EAnnotation eAnnotation = view.getEAnnotation("StereotypePropertyReferenceEdge");
                if (eAnnotation != null) {
                    String stereotypeQualifyName = (String)eAnnotation.getDetails().get((Object)"stereotypeQualifiedName");
                    String featureToSet = (String)eAnnotation.getDetails().get((Object)"featureToSet");
                    String linkLabel = (String)eAnnotation.getDetails().get((Object)"edgeLabel");
                    element = new StereotypePropertyReferenceEdgeRepresentation(source, target, stereotypeQualifyName, featureToSet, linkLabel);
                }
            } else {
                element = new EdgeWithNoSemanticElementRepresentationImpl(source, target, view.getType());
            }
        } else if (element == null) {
            return;
        }
        if ((set = (Set)this.get(element)) != null) {
            set.add(view);
        } else {
            HashSet<View> hashSet = new HashSet<View>();
            hashSet.add(view);
            this.put(element, hashSet);
        }
    }

    public void putView(EObject element, View view) {
        Set set = (Set)this.get(element);
        if (set != null) {
            set.add(view);
        } else {
            HashSet<View> hashSet = new HashSet<View>();
            hashSet.add(view);
            this.put(element, hashSet);
        }
    }

    @Deprecated
    public View getFirstView(Object key) {
        Set set = (Set)this.get(key);
        if (set != null) {
            return (View)set.iterator().next();
        }
        return null;
    }
}

