/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.AbstractSingletonScope;
import org.eclipse.ocl.pivot.ids.IdHash;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.SingletonScope;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.internal.ids.AbstractTypeId;
import org.eclipse.ocl.pivot.internal.ids.WeakHashMapOfListOfWeakReference3;

public class GeneralizedTupleTypeIdImpl
extends AbstractTypeId
implements TupleTypeId,
WeakHashMapOfListOfWeakReference3.MatchableId<String, TuplePartId[]> {
    protected final @NonNull Integer hashCode;
    protected final @NonNull String name;
    protected final @NonNull TuplePartId @NonNull [] partIds;

    private static int computeHashCode(@NonNull String name, @NonNull TuplePartId @NonNull [] orderedPartIds) {
        return IdHash.createTupleHash(name, orderedPartIds);
    }

    @Deprecated
    public GeneralizedTupleTypeIdImpl(@NonNull IdManager idManager, @NonNull Integer hashCode, @NonNull String name, @NonNull TuplePartId @NonNull [] orderedPartIds) {
        this.hashCode = hashCode;
        this.name = name;
        this.partIds = orderedPartIds;
        assert (this.partsAreOrdered());
        this.hashCode.equals(GeneralizedTupleTypeIdImpl.computeHashCode(name, orderedPartIds));
    }

    private GeneralizedTupleTypeIdImpl(@NonNull IdManager idManager, @NonNull String name, @NonNull TuplePartId @NonNull [] orderedPartIds) {
        this.hashCode = GeneralizedTupleTypeIdImpl.computeHashCode(name, orderedPartIds);
        this.name = name;
        this.partIds = orderedPartIds;
        assert (this.partsAreOrdered());
    }

    @Override
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitTupleTypeId(this);
    }

    @Override
    public @NonNull String getDisplayName() {
        StringBuilder s = new StringBuilder();
        s.append(this.name);
        s.append("{");
        boolean isFirst = true;
        TuplePartId[] tuplePartIdArray = this.partIds;
        int n = this.partIds.length;
        int n2 = 0;
        while (n2 < n) {
            TuplePartId partId = tuplePartIdArray[n2];
            if (!isFirst) {
                s.append(", ");
            }
            s.append(partId.getDisplayName());
            isFirst = false;
            ++n2;
        }
        s.append("}");
        return s.toString();
    }

    public @NonNull TupleTypeId getGeneralizedId() {
        return this;
    }

    @Override
    public @NonNull String getMetaTypeName() {
        return "TupleType";
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @Nullable TuplePartId getPartId(@NonNull String name) {
        TuplePartId[] tuplePartIdArray = this.partIds;
        int n = this.partIds.length;
        int n2 = 0;
        while (n2 < n) {
            TuplePartId partId = tuplePartIdArray[n2];
            if (name.equals(partId.getName())) {
                return partId;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public @NonNull TuplePartId @NonNull [] getPartIds() {
        return this.partIds;
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isTemplated() {
        TuplePartId[] tuplePartIdArray = this.partIds;
        int n = this.partIds.length;
        int n2 = 0;
        while (n2 < n) {
            TuplePartId partId = tuplePartIdArray[n2];
            if (partId.getTypeId().isTemplated()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean matches(@NonNull String thatName, @NonNull TuplePartId @NonNull [] thoseOrderedParts) {
        int i = 0;
        while (i < this.partIds.length) {
            if (this.partIds[i] != thoseOrderedParts[i]) {
                return false;
            }
            ++i;
        }
        return this.name.equals(thatName);
    }

    private boolean partsAreOrdered() {
        int i = 0;
        while (i < this.partIds.length - 1) {
            TuplePartId earlierPartId = this.partIds[i];
            TuplePartId laterPartId = this.partIds[i + 1];
            if (earlierPartId.compareTo(laterPartId) >= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /* synthetic */ GeneralizedTupleTypeIdImpl(IdManager idManager, String string, TuplePartId[] tuplePartIdArray, GeneralizedTupleTypeIdImpl generalizedTupleTypeIdImpl) {
        this(idManager, string, tuplePartIdArray);
    }

    public static class TupleTypeIdSingletonScope
    extends AbstractSingletonScope<TupleTypeId, TupleTypeIdValue> {
        public @NonNull TupleTypeId getSingleton(@NonNull IdManager idManager, @NonNull String name, @NonNull TuplePartId @NonNull [] orderedPartIds) {
            return this.getSingletonFor(new TupleTypeIdValue(idManager, name, orderedPartIds));
        }
    }

    private static class TupleTypeIdValue
    extends SingletonScope.AbstractKeyAndValue<TupleTypeId> {
        private final @NonNull IdManager idManager;
        private @NonNull String name;
        private @NonNull TuplePartId @NonNull [] orderedPartIds;

        private TupleTypeIdValue(@NonNull IdManager idManager, @NonNull String name, @NonNull TuplePartId @NonNull [] orderedPartIds) {
            super(GeneralizedTupleTypeIdImpl.computeHashCode(name, orderedPartIds));
            this.idManager = idManager;
            this.name = name;
            this.orderedPartIds = orderedPartIds;
        }

        @Override
        public @NonNull TupleTypeId createSingleton() {
            return new GeneralizedTupleTypeIdImpl(this.idManager, this.name, this.orderedPartIds, null);
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that instanceof GeneralizedTupleTypeIdImpl) {
                GeneralizedTupleTypeIdImpl singleton = (GeneralizedTupleTypeIdImpl)that;
                return singleton.matches(this.name, this.orderedPartIds);
            }
            return false;
        }
    }
}

