/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.papyrus.infra.gmfdiag.menu.handlers.ToggleCanonicalHandler;
import org.eclipse.papyrus.uml.diagram.common.providers.AbstractActionStateSourceProvider;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.ArrangeHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.CopyAppearancePropertiesHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.FillColorHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.FontHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.LineColorHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.LineStyleHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.SelectHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.ShowHideCompartmentHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.ShowHideContentsHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.ShowHideLabelsHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.SortFilterCompartmentItemsHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.ZOrderHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.ZoomHandler;

public class HandlerStateSourceProvider
extends AbstractActionStateSourceProvider {
    public static final String SHOW_HIDE_CONTENTS = "showHideContents";
    public static final String SHOW_HIDE_COMPARTMENTS = "showHideCompartments";
    public static final String TOGGLE_CANONICAL = "toggleCanonical";
    public static final String COPY_APPEARANCE_PROPERTIES = "copyAppearanceProperties";
    public static final String SORT_FILTER_COMPARTMENT_ITEMS = "sortFilterCompartmentItems";
    public static final String ZOOM = "zoom";
    public static final String BRING_TO_FRONT = "bringToFront";
    public static final String SEND_TO_BACK = "sendToBack";
    public static final String BRING_FORWARD = "bringForward";
    public static final String SEND_BACKWARD = "sendBackward";
    public static final String ARRANGE_ALL = "arrangeAll";
    public static final String ARRANGE_SELECTION = "arrangeSelection";
    public static final String SELECT_ALL = "selectAll";
    public static final String SELECT_ALL_SHAPES = "selectAllShapes";
    public static final String SELECT_ALL_CONNECTORS = "selectAllConnectors";
    public static final String FONT = "font";
    public static final String FILL_COLOR = "fillColor";
    public static final String LINE_COLOR = "lineColor";
    public static final String LINE_STYLE = "lineStyle";
    public static final String LINE_STYLE_TREE = "lineStyleTree";
    public static final String SHOW_HIDE_CONNECTION_LABELS = "showHideLabels";
    private Map<String, AbstractHandler> cachedHandlers;

    public HandlerStateSourceProvider() {
        this.currentState.put(SHOW_HIDE_CONTENTS, "disabled");
        this.currentState.put(SHOW_HIDE_COMPARTMENTS, "disabled");
        this.currentState.put(TOGGLE_CANONICAL, "disabled");
        this.currentState.put(COPY_APPEARANCE_PROPERTIES, "disabled");
        this.currentState.put(SORT_FILTER_COMPARTMENT_ITEMS, "disabled");
        this.currentState.put(ZOOM, "disabled");
        this.currentState.put(BRING_TO_FRONT, "disabled");
        this.currentState.put(SEND_TO_BACK, "disabled");
        this.currentState.put(BRING_FORWARD, "disabled");
        this.currentState.put(SEND_BACKWARD, "disabled");
        this.currentState.put(ARRANGE_ALL, "disabled");
        this.currentState.put(ARRANGE_SELECTION, "disabled");
        this.currentState.put(SELECT_ALL, "disabled");
        this.currentState.put(SELECT_ALL_SHAPES, "disabled");
        this.currentState.put(SELECT_ALL_CONNECTORS, "disabled");
        this.currentState.put(FONT, "disabled");
        this.currentState.put(FILL_COLOR, "disabled");
        this.currentState.put(LINE_COLOR, "disabled");
        this.currentState.put(LINE_STYLE, "disabled");
        this.currentState.put(LINE_STYLE_TREE, "disabled");
        this.currentState.put(SHOW_HIDE_CONNECTION_LABELS, "disabled");
        this.cachedHandlers = this.createCachedHandlers();
    }

    public String[] getProvidedSourceNames() {
        return new String[]{SHOW_HIDE_CONTENTS, SHOW_HIDE_COMPARTMENTS, TOGGLE_CANONICAL, COPY_APPEARANCE_PROPERTIES, ZOOM, BRING_TO_FRONT, SEND_TO_BACK, BRING_FORWARD, SEND_BACKWARD, ARRANGE_ALL, ARRANGE_SELECTION, SELECT_ALL, SELECT_ALL_CONNECTORS, SELECT_ALL_SHAPES, FONT, FILL_COLOR, LINE_COLOR, LINE_STYLE, LINE_STYLE_TREE, SHOW_HIDE_CONNECTION_LABELS};
    }

    private Map<String, AbstractHandler> createCachedHandlers() {
        HashMap<String, AbstractHandler> map = new HashMap<String, AbstractHandler>();
        map.put(SHOW_HIDE_COMPARTMENTS, (AbstractHandler)new ShowHideCompartmentHandler());
        map.put(SHOW_HIDE_CONTENTS, (AbstractHandler)new ShowHideContentsHandler());
        map.put(TOGGLE_CANONICAL, (AbstractHandler)new ToggleCanonicalHandler());
        map.put(COPY_APPEARANCE_PROPERTIES, new CopyAppearancePropertiesHandler());
        map.put(SORT_FILTER_COMPARTMENT_ITEMS, new SortFilterCompartmentItemsHandler());
        map.put(ZOOM, new ZoomHandler());
        map.put(BRING_TO_FRONT, new ZOrderHandler(BRING_TO_FRONT));
        map.put(SEND_TO_BACK, new ZOrderHandler(SEND_TO_BACK));
        map.put(BRING_FORWARD, new ZOrderHandler(BRING_FORWARD));
        map.put(SEND_BACKWARD, new ZOrderHandler(SEND_BACKWARD));
        map.put(ARRANGE_ALL, new ArrangeHandler(ARRANGE_ALL));
        map.put(ARRANGE_SELECTION, new ArrangeHandler(ARRANGE_SELECTION));
        map.put(SELECT_ALL, new SelectHandler(SELECT_ALL));
        map.put(SELECT_ALL_CONNECTORS, new SelectHandler(SELECT_ALL_CONNECTORS));
        map.put(SELECT_ALL_SHAPES, new SelectHandler(SELECT_ALL_SHAPES));
        map.put(FONT, new FontHandler());
        map.put(FILL_COLOR, new FillColorHandler());
        map.put(LINE_COLOR, new LineColorHandler());
        map.put(LINE_STYLE, new LineStyleHandler("rectilinear"));
        map.put(LINE_STYLE_TREE, new LineStyleHandler("tree"));
        map.put(SHOW_HIDE_CONNECTION_LABELS, new ShowHideLabelsHandler("show"));
        return map;
    }

    protected void refreshActions() {
        for (String key : this.cachedHandlers.keySet()) {
            this.refresh(key, this.cachedHandlers.get(key));
        }
    }

    protected void refresh(String key, AbstractHandler handler) {
        String newState;
        String oldState = (String)this.currentState.get(key);
        String string = newState = this.test(handler) ? "enabled" : "disabled";
        if (oldState != newState) {
            this.currentState.put(key, newState);
            this.fireSourceChanged(0, key, newState);
        }
    }

    protected boolean test(AbstractHandler handler) {
        return this.isSelectionInDiagram() && handler.isEnabled();
    }
}

