/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.annotations;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IClasspathContributor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class OSGiAnnotationsClasspathContributor
implements IClasspathContributor {
    private static final Collection<String> OSGI_ANNOTATIONS = List.of("org.osgi.annotation.versioning", "org.osgi.annotation.bundle", "org.osgi.service.component.annotations", "org.osgi.service.metatype.annotations");

    @Override
    public List<IClasspathEntry> getInitialEntries(BundleDescription project) {
        IPluginModelBase model = PluginRegistry.findModel(project);
        if (model != null) {
            return OSGiAnnotationsClasspathContributor.entries().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    static Stream<IClasspathEntry> entries() {
        return OSGiAnnotationsClasspathContributor.annotations().map(ISharedPluginModel::getInstallLocation).filter(Objects::nonNull).map(Path::new).map(path -> JavaCore.newLibraryEntry((IPath)path, (IPath)path, (IPath)Path.ROOT, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false));
    }

    public static Stream<IPluginModelBase> annotations() {
        return OSGI_ANNOTATIONS.stream().map(PluginRegistry::findModel).filter(Objects::nonNull).filter(IPluginModelBase::isEnabled);
    }

    @Override
    public List<IClasspathEntry> getEntriesForDependency(BundleDescription project, BundleDescription addedDependency) {
        return Collections.emptyList();
    }
}

