/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;

public abstract class RefactoringWizardPage
extends WizardPage {
    public static final String REFACTORING_SETTINGS = "org.eclipse.ltk.ui.refactoring.settings";
    private final boolean fConventionalWizard;

    protected RefactoringWizardPage(String name, boolean wizard) {
        super(name);
        this.fConventionalWizard = wizard;
    }

    protected RefactoringWizardPage(String name) {
        super(name);
        this.fConventionalWizard = false;
    }

    public void setWizard(IWizard newWizard) {
        Assert.isTrue((this.fConventionalWizard || newWizard instanceof RefactoringWizard ? 1 : 0) != 0);
        super.setWizard(newWizard);
    }

    protected Refactoring getRefactoring() {
        RefactoringWizard wizard = this.getRefactoringWizard();
        if (wizard == null) {
            return null;
        }
        return wizard.getRefactoring();
    }

    protected RefactoringWizard getRefactoringWizard() {
        IWizard wizard = this.getWizard();
        if (wizard instanceof RefactoringWizard) {
            return (RefactoringWizard)wizard;
        }
        return null;
    }

    protected boolean performFinish() {
        return true;
    }

    protected IDialogSettings getRefactoringSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings == null) {
            return null;
        }
        IDialogSettings result = settings.getSection(REFACTORING_SETTINGS);
        if (result == null) {
            result = new DialogSettings(REFACTORING_SETTINGS);
            settings.addSection(result);
        }
        return result;
    }
}

