/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.common.collect.Sets;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ExternalPackageFragmentRoot;
import org.eclipse.xtext.ui.resource.PackageFragmentRootWalker;

public abstract class SourceAttachmentPackageFragmentRootWalker<T>
extends PackageFragmentRootWalker<T> {
    private static final Logger LOG = Logger.getLogger(SourceAttachmentPackageFragmentRootWalker.class);
    private static final Pattern COMMA = Pattern.compile(",");
    private Set<Pattern> binIncludePatterns;
    private boolean visitAll;
    private String bundleSymbolicName;
    private static final int YES = 1;
    private static final int MAYBE = 0;
    private static final int NO = -1;

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public T traverse(IPackageFragmentRoot root, boolean stopOnFirstResult) throws JavaModelException {
        try {
            block27: {
                this.bundleSymbolicName = null;
                v0 = path = root.isExternal() != false ? root.getPath() : root.getUnderlyingResource().getLocation();
                if (path != null && "jar".equals(path.getFileExtension())) {
                    try {
                        file = path.toFile();
                        if (file == null || !file.exists()) break block27;
                        jarFile = new JarFile(file);
                        try {
                            manifest = jarFile.getManifest();
                            if (manifest != null) {
                                this.bundleSymbolicName = this.getBundleSymbolicName(manifest);
                            }
                        }
                        finally {
                            jarFile.close();
                        }
                    }
                    catch (IOException e) {
                        SourceAttachmentPackageFragmentRootWalker.LOG.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            if ((sourceAttachmentPath = root.getSourceAttachmentPath()) == null || !sourceAttachmentPath.isPrefixOf(path) || !((packageFragmentRoot = root.getJavaProject().getPackageFragmentRoot(sourceAttachmentPath.toOSString())) instanceof ExternalPackageFragmentRoot) || !((resource = ((ExternalPackageFragmentRoot)packageFragmentRoot).resource()) instanceof IFolder) || !(buildPropertiesFile = (folder = (IFolder)resource).getFile("build.properties")).exists()) ** GOTO lbl72
            buildProperties = new Properties();
            try {
                this.loadBuildProperties(buildPropertiesFile, buildProperties);
                binIncludes = buildProperties.getProperty("bin.includes");
                if (binIncludes == null) ** GOTO lbl72
                this.binIncludePatterns = Sets.newHashSet();
                var14_14 = SourceAttachmentPackageFragmentRootWalker.COMMA.split(binIncludes);
                var13_16 = var14_14.length;
                var12_19 = 0;
                while (var12_19 < var13_16) {
                    binInclude = var14_14[var12_19];
                    if (buildProperties.get("source." + binInclude) == null) {
                        if (binInclude.endsWith("/")) {
                            binInclude = String.valueOf(binInclude) + "**";
                        }
                        if (binInclude.startsWith("/")) {
                            binInclude = "**" + binInclude;
                            this.visitAll = true;
                        } else if (binInclude.startsWith("**")) {
                            this.visitAll = true;
                        }
                        binIncludePattern = Pattern.quote(binInclude);
                        if (binIncludePattern.contains("**")) {
                            binIncludePattern = binIncludePattern.replace("**", "\u0000").replace("*", "\\E[^/]*\\Q").replace("\u0000", "\\E.*\\Q");
                        } else if (binIncludePattern.contains("*")) {
                            binIncludePattern = binIncludePattern.replace("*", "\\E[^/]*\\Q");
                        }
                        this.binIncludePatterns.add(Pattern.compile(binIncludePattern));
                    }
                    ++var12_19;
                }
                manifestFile = sourceAttachmentPath.append("META-INF/MANIFEST.MF").toFile();
                if (manifestFile.exists()) {
                    inputStream = null;
                    try {
                        inputStream = new FileInputStream(manifestFile);
                        manifest = new Manifest(inputStream);
                        this.bundleSymbolicName = this.getBundleSymbolicName(manifest);
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                state = new PackageFragmentRootWalker.TraversalState(folder);
                result = this.traverse(folder, stopOnFirstResult, state);
                if (!stopOnFirstResult || result == null) ** GOTO lbl72
                var17_24 = result;
            }
            catch (Exception e) {
                SourceAttachmentPackageFragmentRootWalker.LOG.error((Object)e.getMessage(), (Throwable)e);
lbl72:
                // 4 sources

                var17_25 = super.traverse(root, stopOnFirstResult);
            }
            return var17_24;
            return var17_25;
            {
                catch (Throwable var16_26) {
                    throw var16_26;
                }
            }
        }
        finally {
            this.visitAll = false;
            this.binIncludePatterns = null;
        }
    }

    protected void loadBuildProperties(IFile buildPropertiesFile, Properties result) throws CoreException, IOException {
        InputStream buildPropertiesContents = buildPropertiesFile.getContents(true);
        result.load(buildPropertiesContents);
        buildPropertiesContents.close();
    }

    protected int isBinInclude(String path) {
        for (Pattern pattern : this.binIncludePatterns) {
            if (!pattern.matcher(path.toString()).matches()) continue;
            return 1;
        }
        return this.visitAll ? 0 : -1;
    }

    public T traverse(IFolder folder, boolean stopOnFirstResult, PackageFragmentRootWalker.TraversalState state) {
        T result = null;
        try {
            Path path = new Path("");
            List<?> parents = state.getParents();
            int i = 1;
            int count = parents.size();
            while (i < count) {
                path = path.append(((IFolder)parents.get(i)).getName());
                ++i;
            }
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                switch (resource.getType()) {
                    case 2: {
                        if (this.isBinInclude(String.valueOf(path.append(resource.getName()).toString()) + "/") == -1) break;
                        state.push(resource);
                        result = this.traverse((IFolder)resource, stopOnFirstResult, state);
                        state.pop();
                        break;
                    }
                    case 1: {
                        if (this.isBinInclude(path.append(resource.getName()).toString()) != 1) break;
                        result = this.handle((IFile)resource, state);
                    }
                }
                if (!stopOnFirstResult || result == null) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (CoreException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected boolean isValid(URI uri, IStorage storage) {
        return uri != null;
    }

    protected T handle(IFile file, PackageFragmentRootWalker.TraversalState state) {
        URI uri = this.getURI(file, state);
        if (this.isValid(uri, (IStorage)file)) {
            return this.handle(this.getLogicalURI(uri, (IStorage)file, state), (IStorage)file, state);
        }
        return null;
    }

    protected URI getLogicalURI(URI uri, IStorage storage, PackageFragmentRootWalker.TraversalState state) {
        if (this.bundleSymbolicName != null) {
            URI logicalURI = URI.createPlatformResourceURI((String)this.bundleSymbolicName, (boolean)false);
            List<?> parents = state.getParents();
            int i = 1;
            while (i < parents.size()) {
                Object obj = parents.get(i);
                if (obj instanceof IPackageFragment) {
                    logicalURI = logicalURI.appendSegments(((IPackageFragment)obj).getElementName().split("\\."));
                } else if (obj instanceof IJarEntryResource) {
                    logicalURI = logicalURI.appendSegment(((IJarEntryResource)obj).getName());
                } else if (obj instanceof IFolder) {
                    logicalURI = logicalURI.appendSegment(((IFolder)obj).getName());
                }
                ++i;
            }
            return logicalURI.appendSegment(uri.lastSegment());
        }
        return uri;
    }

    @Override
    protected T handle(IJarEntryResource jarEntry, PackageFragmentRootWalker.TraversalState state) {
        URI uri = this.getURI(jarEntry, state);
        if (this.isValid(uri, (IStorage)jarEntry)) {
            return this.handle(this.getLogicalURI(uri, (IStorage)jarEntry, state), (IStorage)jarEntry, state);
        }
        return null;
    }

    private String getBundleSymbolicName(Manifest manifest) {
        String name = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        if (name != null && !name.isBlank()) {
            int indexOf = name.indexOf(59);
            if (indexOf > 0) {
                name = name.substring(0, indexOf);
            }
            return name;
        }
        return null;
    }

    protected URI getURI(IFile file, PackageFragmentRootWalker.TraversalState state) {
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
    }

    protected abstract URI getURI(IJarEntryResource var1, PackageFragmentRootWalker.TraversalState var2);

    protected abstract T handle(URI var1, IStorage var2, PackageFragmentRootWalker.TraversalState var3);
}

