/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.debug.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ant.internal.launching.debug.model.AntDebugElement;
import org.eclipse.ant.internal.launching.debug.model.AntDebugTarget;
import org.eclipse.ant.internal.launching.debug.model.AntProperties;
import org.eclipse.ant.internal.launching.debug.model.AntPropertiesValue;
import org.eclipse.ant.internal.launching.debug.model.AntProperty;
import org.eclipse.ant.internal.launching.debug.model.AntStackFrame;
import org.eclipse.ant.internal.launching.debug.model.DebugModelMessages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class AntThread
extends AntDebugElement
implements IThread {
    static final IBreakpoint[] NO_BREAKPOINTS = new IBreakpoint[0];
    private IBreakpoint[] fBreakpoints;
    private final List<AntStackFrame> fFrames = new ArrayList<AntStackFrame>(1);
    private List<AntStackFrame> fOldFrames;
    private boolean fStepping = false;
    private boolean fRefreshProperties = true;
    private AntProperties fUserProperties;
    private AntProperties fSystemProperties;
    private AntProperties fRuntimeProperties;
    private final Object fPropertiesLock = new Object();

    public AntThread(AntDebugTarget target) {
        super(target);
    }

    public synchronized IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended() && this.fFrames.isEmpty()) {
            this.getStackFrames0();
        }
        return this.fFrames.toArray(new IStackFrame[this.fFrames.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getStackFrames0() throws DebugException {
        List<AntStackFrame> list = this.fFrames;
        synchronized (list) {
            this.getAntDebugTarget().getStackFrames();
            if (this.fFrames.size() > 0) {
                return;
            }
            int attempts = 0;
            try {
                while (this.fFrames.isEmpty() && !this.isTerminated()) {
                    this.fFrames.wait(50L);
                    if (attempts == 20 && this.fFrames.isEmpty() && !this.isTerminated()) {
                        this.throwDebugException(DebugModelMessages.AntThread_3);
                    }
                    ++attempts;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public synchronized IStackFrame getTopStackFrame() throws DebugException {
        if (this.isSuspended()) {
            if (this.fFrames.isEmpty()) {
                this.getStackFrames0();
            }
            if (this.fFrames.size() > 0) {
                return this.fFrames.get(0);
            }
        }
        return null;
    }

    public String getName() {
        return "Thread [Ant Build]";
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.fBreakpoints == null) {
            return NO_BREAKPOINTS;
        }
        return this.fBreakpoints;
    }

    protected void setBreakpoints(IBreakpoint[] breakpoints) {
        this.fBreakpoints = breakpoints;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public synchronized void resume() throws DebugException {
        this.aboutToResume(32, false);
        this.getDebugTarget().resume();
    }

    void resumedByTarget() {
        this.aboutToResume(32, false);
    }

    public synchronized void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public synchronized void stepInto() throws DebugException {
        this.aboutToResume(1, true);
        ((AntDebugTarget)this.getDebugTarget()).stepInto();
    }

    private void aboutToResume(int detail, boolean stepping) {
        this.fRefreshProperties = true;
        this.fOldFrames = new ArrayList<AntStackFrame>(this.fFrames);
        this.fFrames.clear();
        this.setPropertiesValid(false);
        this.setStepping(stepping);
        this.setBreakpoints(null);
        this.fireResumeEvent(detail);
    }

    private void setPropertiesValid(boolean valid) {
        if (this.fUserProperties != null) {
            this.fUserProperties.setValid(valid);
            this.fSystemProperties.setValid(valid);
            this.fRuntimeProperties.setValid(valid);
        }
    }

    public synchronized void stepOver() throws DebugException {
        this.aboutToResume(2, true);
        ((AntDebugTarget)this.getDebugTarget()).stepOver();
    }

    public synchronized void stepReturn() throws DebugException {
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.fFrames.clear();
        this.getDebugTarget().terminate();
    }

    protected void setStepping(boolean stepping) {
        this.fStepping = stepping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildStack(String data) {
        List<AntStackFrame> list = this.fFrames;
        synchronized (list) {
            String[] strings = data.split(",");
            if (this.fOldFrames != null && (strings.length - 1) / 4 != this.fOldFrames.size()) {
                this.fOldFrames = null;
            }
            int stackFrameId = 0;
            int i = 1;
            while (i < strings.length) {
                StringBuilder name;
                if (strings[i].length() > 0) {
                    String taskName;
                    name = new StringBuilder(strings[i]);
                    if ((taskName = strings[++i]).length() > 0) {
                        name.append(": ");
                        name.append(taskName);
                    }
                } else {
                    name = new StringBuilder(strings[++i]);
                }
                String filePath = strings[++i];
                int lineNumber = Integer.parseInt(strings[++i]);
                this.addFrame(stackFrameId++, name.toString(), filePath, lineNumber);
                ++i;
            }
            this.fFrames.notifyAll();
        }
    }

    private void addFrame(int stackFrameId, String name, String filePath, int lineNumber) {
        AntStackFrame frame = this.getOldFrame();
        if (frame == null || !frame.getFilePath().equals(filePath)) {
            frame = new AntStackFrame(this, stackFrameId, name, filePath, lineNumber);
        } else {
            frame.setFilePath(filePath);
            frame.setId(stackFrameId);
            frame.setLineNumber(lineNumber);
            frame.setName(name);
        }
        this.fFrames.add(frame);
    }

    private AntStackFrame getOldFrame() {
        if (this.fOldFrames == null) {
            return null;
        }
        AntStackFrame frame = this.fOldFrames.remove(0);
        if (this.fOldFrames.isEmpty()) {
            this.fOldFrames = null;
        }
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newProperties(String data) {
        Object object = this.fPropertiesLock;
        synchronized (object) {
            try {
                String[] datum = data.split(",");
                if (this.fUserProperties == null) {
                    this.initializePropertyGroups();
                }
                List<AntProperty> userProperties = ((AntPropertiesValue)this.fUserProperties.getLastValue()).getProperties();
                List<AntProperty> systemProperties = ((AntPropertiesValue)this.fSystemProperties.getLastValue()).getProperties();
                List<AntProperty> runtimeProperties = ((AntPropertiesValue)this.fRuntimeProperties.getLastValue()).getProperties();
                if (datum.length > 1) {
                    int i = 1;
                    while (i < datum.length) {
                        int propertyValueLength;
                        int propertyNameLength = Integer.parseInt(datum[i]);
                        StringBuffer propertyName = new StringBuffer(datum[++i]);
                        while (propertyName.length() != propertyNameLength) {
                            propertyName.append(",");
                            propertyName.append(datum[++i]);
                        }
                        propertyName = this.getAntDebugTarget().getAntDebugController().unescapeString(propertyName);
                        StringBuffer propertyValue = (propertyValueLength = Integer.parseInt(datum[++i])) == 0 && i + 1 == datum.length ? new StringBuffer("") : new StringBuffer(datum[++i]);
                        while (propertyValue.length() != propertyValueLength) {
                            propertyValue.append(",");
                            propertyValue.append(datum[++i]);
                        }
                        propertyValue = this.getAntDebugTarget().getAntDebugController().unescapeString(propertyValue);
                        int propertyType = Integer.parseInt(datum[++i]);
                        this.addProperty(userProperties, systemProperties, runtimeProperties, propertyName.toString(), propertyValue.toString(), propertyType);
                        ++i;
                    }
                }
            }
            finally {
                this.fRefreshProperties = false;
                this.setPropertiesValid(true);
                this.fPropertiesLock.notifyAll();
            }
        }
    }

    private void addProperty(List<AntProperty> userProperties, List<AntProperty> systemProperties, List<AntProperty> runtimeProperties, String propertyName, String propertyValue, int propertyType) {
        AntProperty property = new AntProperty((AntDebugTarget)this.getDebugTarget(), propertyName, propertyValue);
        switch (propertyType) {
            case 1: {
                systemProperties.add(property);
                break;
            }
            case 0: {
                userProperties.add(property);
                break;
            }
            case 2: {
                runtimeProperties.add(property);
                break;
            }
        }
    }

    private void initializePropertyGroups() {
        AntDebugTarget target = this.getAntDebugTarget();
        this.fUserProperties = new AntProperties(target, DebugModelMessages.AntThread_0);
        this.fUserProperties.setValue(new AntPropertiesValue(target));
        this.fSystemProperties = new AntProperties(target, DebugModelMessages.AntThread_1);
        this.fSystemProperties.setValue(new AntPropertiesValue(target));
        this.fRuntimeProperties = new AntProperties(target, DebugModelMessages.AntThread_2);
        this.fRuntimeProperties.setValue(new AntPropertiesValue(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IVariable[] getVariables() throws DebugException {
        Object object = this.fPropertiesLock;
        synchronized (object) {
            if (this.fRefreshProperties) {
                this.getAntDebugTarget().getProperties();
                if (this.fRefreshProperties) {
                    try {
                        int attempts = 0;
                        while (this.fRefreshProperties && !this.isTerminated()) {
                            this.fPropertiesLock.wait(50L);
                            if (attempts == 20 && this.fRefreshProperties && !this.isTerminated()) {
                                this.throwDebugException(DebugModelMessages.AntThread_4);
                            }
                            ++attempts;
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.fSystemProperties == null) {
                return new IVariable[0];
            }
            return new IVariable[]{this.fSystemProperties, this.fUserProperties, this.fRuntimeProperties};
        }
    }
}

