/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.surround;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryCatchAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.SelectionAwareSourceRangeComputer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistProcessorUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class SurroundWithTryCatchRefactoring
extends Refactoring {
    public static final String GROUP_EXC_TYPE = "exc_type";
    public static final String GROUP_EXC_NAME = "exc_name";
    private Selection fSelection;
    private SurroundWithTryCatchAnalyzer fAnalyzer;
    private boolean fLeaveDirty;
    private ICompilationUnit fCUnit;
    private CompilationUnit fRootNode;
    private ASTRewrite fRewriter;
    private ImportRewrite fImportRewrite;
    private CodeScopeBuilder.Scope fScope;
    private ASTNode[] fSelectedNodes;
    private LinkedProposalModelCore fLinkedProposalModel;
    private final boolean fIsMultiCatch;

    private SurroundWithTryCatchRefactoring(ICompilationUnit cu, Selection selection, boolean isMultiCatch) {
        this.fCUnit = cu;
        this.fSelection = selection;
        this.fIsMultiCatch = isMultiCatch;
        this.fLeaveDirty = false;
    }

    public static SurroundWithTryCatchRefactoring create(ICompilationUnit cu, int offset, int length) {
        return SurroundWithTryCatchRefactoring.create(cu, offset, length, false);
    }

    public static SurroundWithTryCatchRefactoring create(ICompilationUnit cu, int offset, int length, boolean isMultiCatch) {
        return new SurroundWithTryCatchRefactoring(cu, Selection.createFromStartLength(offset, length), isMultiCatch);
    }

    public LinkedProposalModelCore getLinkedProposalModel() {
        return this.fLinkedProposalModel;
    }

    public void setLeaveDirty(boolean leaveDirty) {
        this.fLeaveDirty = leaveDirty;
    }

    public boolean stopExecution() {
        if (this.fAnalyzer == null) {
            return true;
        }
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions();
        return exceptions == null || exceptions.length == 0;
    }

    public String getName() {
        return RefactoringCoreMessages.SurroundWithTryCatchRefactoring_name;
    }

    public RefactoringStatus checkActivationBasics(CompilationUnit rootNode) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.fRootNode = rootNode;
        this.fAnalyzer = new SurroundWithTryCatchAnalyzer(this.fCUnit, this.fSelection);
        this.fRootNode.accept((ASTVisitor)this.fAnalyzer);
        result.merge(this.fAnalyzer.getStatus());
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions();
        if (this.fIsMultiCatch && (exceptions == null || exceptions.length <= 1)) {
            result.merge(RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.SurroundWithTryCatchRefactoring_notMultipleexceptions));
        }
        return result;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        CompilationUnit rootNode = new RefactoringASTParser(IASTSharedValues.SHARED_AST_LEVEL).parse((ITypeRoot)this.fCUnit, true, pm);
        return this.checkActivationBasics(rootNode);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        return Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCUnit}), this.getValidationContext(), pm);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 2);
        try {
            CompilationUnitChange result = new CompilationUnitChange(this.getName(), this.fCUnit);
            if (this.fLeaveDirty) {
                result.setSaveMode(4);
            }
            MultiTextEdit root = new MultiTextEdit();
            result.setEdit((TextEdit)root);
            this.fRewriter = ASTRewrite.create((AST)this.fAnalyzer.getEnclosingBodyDeclaration().getAST());
            this.fRewriter.setTargetSourceRangeComputer((TargetSourceRangeComputer)new SelectionAwareSourceRangeComputer(this.fAnalyzer.getSelectedNodes(), this.fCUnit.getBuffer(), this.fSelection.getOffset(), this.fSelection.getLength()));
            this.fImportRewrite = StubUtility.createImportRewrite(this.fRootNode, true);
            this.fLinkedProposalModel = this.createLinkedProposalModel();
            BodyDeclaration enclosingBodyDeclaration = this.fAnalyzer.getEnclosingBodyDeclaration();
            Selection ignoreSelection = Selection.createFromStartEnd(this.fSelection.getOffset(), enclosingBodyDeclaration.getStartPosition() + enclosingBodyDeclaration.getLength());
            this.fScope = CodeScopeBuilder.perform(enclosingBodyDeclaration, ignoreSelection).findScope(this.fSelection.getOffset(), this.fSelection.getLength());
            this.fScope.setCursor(this.fSelection.getOffset());
            this.fSelectedNodes = this.fAnalyzer.getSelectedNodes();
            this.createTryCatchStatement(this.fCUnit.getBuffer(), this.fCUnit.findRecommendedLineSeparator());
            if (this.fImportRewrite.hasRecordedChanges()) {
                TextEdit edit = this.fImportRewrite.rewriteImports(null);
                root.addChild(edit);
                result.addTextEditGroup(new TextEditGroup("", new TextEdit[]{edit}));
            }
            TextEdit change = this.fRewriter.rewriteAST();
            root.addChild(change);
            result.addTextEditGroup(new TextEditGroup("", new TextEdit[]{change}));
            CompilationUnitChange compilationUnitChange = result;
            return compilationUnitChange;
        }
        finally {
            pm.done();
        }
    }

    protected LinkedProposalModelCore createLinkedProposalModel() {
        return new LinkedProposalModelCore();
    }

    private AST getAST() {
        return this.fRootNode.getAST();
    }

    private void createTryCatchStatement(IBuffer buffer, String lineDelimiter) throws CoreException {
        ArrayList<Object> result = new ArrayList<Object>(1);
        TryStatement tryStatement = this.getAST().newTryStatement();
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions();
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration(), this.fImportRewrite);
        if (!this.fIsMultiCatch) {
            int i = 0;
            while (i < exceptions.length) {
                ITypeBinding exception = exceptions[i];
                CatchClause catchClause = this.getAST().newCatchClause();
                tryStatement.catchClauses().add(catchClause);
                SingleVariableDeclaration decl = this.getAST().newSingleVariableDeclaration();
                String varName = StubUtility.getExceptionVariableName(this.fCUnit.getJavaProject());
                String name = this.fScope.createName(varName, false);
                decl.setName(this.getAST().newSimpleName(name));
                Type type = this.fImportRewrite.addImport(exception, this.getAST(), (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.EXCEPTION);
                decl.setType(type);
                catchClause.setException(decl);
                Statement st = this.getCatchBody(ASTNodes.getQualifiedTypeName(type), name, lineDelimiter);
                if (st != null) {
                    catchClause.getBody().statements().add(st);
                }
                this.fLinkedProposalModel.getPositionGroup(GROUP_EXC_TYPE + i, true).addPosition(this.fRewriter.track((ASTNode)decl.getType()), i == 0);
                this.fLinkedProposalModel.getPositionGroup(GROUP_EXC_NAME + i, true).addPosition(this.fRewriter.track((ASTNode)decl.getName()), false);
                ++i;
            }
        } else {
            List<ITypeBinding> filteredExceptions = SurroundWithTryCatchRefactoring.filterSubtypeExceptions(exceptions);
            CatchClause catchClause = this.getAST().newCatchClause();
            SingleVariableDeclaration decl = this.getAST().newSingleVariableDeclaration();
            String varName = StubUtility.getExceptionVariableName(this.fCUnit.getJavaProject());
            String name = this.fScope.createName(varName, false);
            decl.setName(this.getAST().newSimpleName(name));
            UnionType unionType = this.getAST().newUnionType();
            List types = unionType.types();
            int i = 0;
            for (ITypeBinding exception : filteredExceptions) {
                Type type = this.fImportRewrite.addImport(exception, this.getAST(), (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.EXCEPTION);
                types.add(type);
                this.fLinkedProposalModel.getPositionGroup(GROUP_EXC_TYPE + i, true).addPosition(this.fRewriter.track((ASTNode)type), i == 0);
                ++i;
            }
            decl.setType((Type)unionType);
            catchClause.setException(decl);
            this.fLinkedProposalModel.getPositionGroup("exc_name0", true).addPosition(this.fRewriter.track((ASTNode)decl.getName()), false);
            Statement st = this.getCatchBody("Exception", name, lineDelimiter);
            if (st != null) {
                catchClause.getBody().statements().add(st);
            }
            tryStatement.catchClauses().add(catchClause);
        }
        List<ASTNode> variableDeclarations = this.getSpecialVariableDeclarationStatements();
        ListRewrite statements = this.fRewriter.getListRewrite((ASTNode)tryStatement.getBody(), Block.STATEMENTS_PROPERTY);
        boolean selectedNodeRemoved = false;
        ASTNode expressionStatement = null;
        ASTNode[] i = this.fSelectedNodes;
        int types = this.fSelectedNodes.length;
        int unionType = 0;
        while (unionType < types) {
            ASTNode node = i[unionType];
            if (node instanceof VariableDeclarationStatement && variableDeclarations.contains(node)) {
                CompilationUnit compilationUnit;
                int extendedStart;
                ITypeBinding iTypeBinding;
                AST ast = this.getAST();
                VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
                VariableDeclarationStatement copy = (VariableDeclarationStatement)ASTNode.copySubtree((AST)ast, (ASTNode)statement);
                List modifiers = copy.modifiers();
                Iterator iter = modifiers.iterator();
                while (iter.hasNext()) {
                    IExtendedModifier iExtendedModifier = (IExtendedModifier)iter.next();
                    if (!iExtendedModifier.isModifier() || !Modifier.isFinal((int)((Modifier)iExtendedModifier).getKeyword().toFlagValue())) continue;
                    iter.remove();
                }
                List fragments = copy.fragments();
                for (VariableDeclarationFragment variableDeclarationFragment : fragments) {
                    variableDeclarationFragment.setInitializer(null);
                }
                if (ASTNodes.isVarType((ASTNode)statement, this.fRootNode) && (iTypeBinding = statement.getType().resolveBinding()) != null) {
                    Type varType = this.fImportRewrite.addImport(iTypeBinding, this.getAST(), (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.LOCAL_VARIABLE);
                    copy.setType(varType);
                }
                if ((extendedStart = (compilationUnit = (CompilationUnit)statement.getRoot()).getExtendedStartPosition((ASTNode)statement)) != statement.getStartPosition() && extendedStart >= this.fSelection.getOffset()) {
                    String commentToken = buffer.getText(extendedStart, statement.getStartPosition() - extendedStart);
                    commentToken = Strings.trimTrailingTabsAndSpaces(commentToken);
                    Type type = statement.getType();
                    String typeName = buffer.getText(type.getStartPosition(), type.getLength());
                    copy.setType((Type)this.fRewriter.createStringPlaceholder(commentToken + typeName, type.getNodeType()));
                }
                result.add(copy);
                fragments = statement.fragments();
                if (!fragments.isEmpty()) {
                    ArrayList<ExpressionStatement> newExpressionStatements = new ArrayList<ExpressionStatement>();
                    for (VariableDeclarationFragment fragment : fragments) {
                        Expression initializer = fragment.getInitializer();
                        if (initializer == null) continue;
                        Assignment assignment = ast.newAssignment();
                        assignment.setLeftHandSide((Expression)this.fRewriter.createCopyTarget((ASTNode)fragment.getName()));
                        assignment.setRightHandSide((Expression)this.fRewriter.createCopyTarget((ASTNode)initializer));
                        newExpressionStatements.add(ast.newExpressionStatement((Expression)assignment));
                    }
                    if (!newExpressionStatements.isEmpty()) {
                        if (this.fSelectedNodes.length == 1) {
                            expressionStatement = this.fRewriter.createGroupNode(newExpressionStatements.toArray(new ASTNode[newExpressionStatements.size()]));
                        } else {
                            this.fRewriter.replace((ASTNode)statement, this.fRewriter.createGroupNode(newExpressionStatements.toArray(new ASTNode[newExpressionStatements.size()])), null);
                        }
                    } else {
                        this.fRewriter.remove((ASTNode)statement, null);
                        selectedNodeRemoved = true;
                    }
                } else {
                    this.fRewriter.remove((ASTNode)statement, null);
                    selectedNodeRemoved = true;
                }
            }
            ++unionType;
        }
        result.add(tryStatement);
        ASTNode replacementNode = result.size() == 1 ? (ASTNode)result.get(0) : this.fRewriter.createGroupNode(result.toArray(new ASTNode[result.size()]));
        ASTNode node = this.fSelectedNodes[0];
        List<Object> nodesInRange = new ArrayList();
        if (JavaModelUtil.is16OrHigher(this.fCUnit.getJavaProject()) && (node instanceof Block || node.getLocationInParent() == Block.STATEMENTS_PROPERTY)) {
            ASTNode parentBodyDeclaration = node instanceof Block ? node : ASTNodes.getFirstAncestorOrNull(node, Block.class);
            int start = this.fSelectedNodes[0].getStartPosition();
            ASTNode lastSelectedNode = this.fSelectedNodes[this.fSelectedNodes.length - 1];
            int end = lastSelectedNode.getStartPosition() + lastSelectedNode.getLength();
            ASTNode[] aSTNodeArray = this.fSelectedNodes;
            int n = this.fSelectedNodes.length;
            int fragments = 0;
            while (fragments < n) {
                ASTNode astNode = aSTNodeArray[fragments];
                if (!variableDeclarations.contains(astNode)) {
                    int endPosition = this.findEndPosition(astNode);
                    end = Math.max(end, endPosition);
                }
                ++fragments;
            }
            nodesInRange = SurroundWithTryCatchRefactoring.findNodesInRange(parentBodyDeclaration, start, end);
            int oldEnd = end;
            int newEnd = end;
            while (true) {
                newEnd = oldEnd;
                for (ASTNode aSTNode : nodesInRange) {
                    if (variableDeclarations.contains(aSTNode)) continue;
                    int endPosition = this.findEndPosition(aSTNode);
                    newEnd = Math.max(newEnd, endPosition);
                }
                if (newEnd <= oldEnd) break;
                oldEnd = newEnd;
                nodesInRange = SurroundWithTryCatchRefactoring.findNodesInRange(parentBodyDeclaration, start, newEnd);
            }
            nodesInRange.removeAll(Arrays.asList(this.fSelectedNodes));
        }
        if (this.fSelectedNodes.length == 1 && nodesInRange.isEmpty()) {
            ASTNode selectedNode = this.fSelectedNodes[0];
            if (selectedNode instanceof MethodReference) {
                MethodReference methodReference = (MethodReference)selectedNode;
                IMethodBinding functionalMethod = QuickAssistProcessorUtil.getFunctionalMethodForMethodReference(methodReference);
                Assert.isTrue((functionalMethod != null && !functionalMethod.isGenericMethod() ? 1 : 0) != 0);
                LambdaExpression lambda = QuickAssistProcessorUtil.convertMethodRefernceToLambda(methodReference, functionalMethod, this.fRootNode, this.fRewriter, null, true);
                ASTNode statementInBlock = (ASTNode)((Block)lambda.getBody()).statements().get(0);
                this.fRewriter.replace(statementInBlock, replacementNode, null);
                statements.insertLast(statementInBlock, null);
                return;
            }
            LambdaExpression enclosingLambda = ASTResolving.findEnclosingLambdaExpression(selectedNode);
            if (enclosingLambda != null && selectedNode.getLocationInParent() == LambdaExpression.BODY_PROPERTY && enclosingLambda.resolveMethodBinding() != null) {
                QuickAssistProcessorUtil.changeLambdaBodyToBlock(enclosingLambda, this.getAST(), this.fRewriter);
                Block blockBody = (Block)this.fRewriter.get((ASTNode)enclosingLambda, (StructuralPropertyDescriptor)LambdaExpression.BODY_PROPERTY);
                ASTNode statementInBlock = (ASTNode)blockBody.statements().get(0);
                this.fRewriter.replace(statementInBlock, replacementNode, null);
                statements.insertLast(statementInBlock, null);
                return;
            }
            if (expressionStatement != null) {
                statements.insertLast(expressionStatement, null);
            } else if (!selectedNodeRemoved) {
                statements.insertLast(this.fRewriter.createMoveTarget(selectedNode), null);
            }
            this.fRewriter.replace(selectedNode, replacementNode, null);
        } else {
            ListRewrite source = this.fRewriter.getListRewrite(this.fSelectedNodes[0].getParent(), (ChildListPropertyDescriptor)this.fSelectedNodes[0].getLocationInParent());
            ASTNode toMove = source.createMoveTarget(this.fSelectedNodes[0], nodesInRange.isEmpty() ? this.fSelectedNodes[this.fSelectedNodes.length - 1] : (ASTNode)nodesInRange.get(nodesInRange.size() - 1), replacementNode, null);
            statements.insertLast(toMove, null);
        }
    }

    private int findEndPosition(ASTNode node) {
        int end = node.getStartPosition() + node.getLength();
        Map<SimpleName, IVariableBinding> nodeSimpleNameBindings = this.fAnalyzer.getVariableStatementBinding(node);
        ArrayList<SimpleName> nodeNames = new ArrayList<SimpleName>(nodeSimpleNameBindings.keySet());
        if (nodeNames.isEmpty()) {
            return -1;
        }
        SimpleName nodeSimpleName = (SimpleName)nodeNames.get(0);
        SimpleName[] coveredNodeBindings = LinkedNodeFinder.findByNode(node.getRoot(), nodeSimpleName);
        if (coveredNodeBindings.length == 0) {
            return -1;
        }
        SimpleName[] simpleNameArray = coveredNodeBindings;
        int n = coveredNodeBindings.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleName astNode = simpleNameArray[n2];
            end = Math.max(end, astNode.getStartPosition() + astNode.getLength());
            ++n2;
        }
        return end;
    }

    public static List<ASTNode> findNodesInRange(final ASTNode astNode, final int start, final int end) {
        final ArrayList<ASTNode> nodesInRange = new ArrayList<ASTNode>();
        astNode.accept(new ASTVisitor(){
            int pre;
            {
                this.pre = n;
            }

            public void preVisit(ASTNode preNode) {
                this.pre = preNode.getStartPosition();
                super.preVisit(preNode);
            }

            public void postVisit(ASTNode postNode) {
                int post = postNode.getStartPosition() + postNode.getLength();
                if (this.pre >= start && post <= end) {
                    Statement statement = ASTResolving.findParentStatement(postNode);
                    while (statement != null && statement.getParent() != astNode) {
                        ASTNode parent = statement.getParent();
                        if (parent == null) {
                            return;
                        }
                        statement = ASTResolving.findParentStatement(parent);
                    }
                    if (statement != null && !nodesInRange.contains(statement)) {
                        nodesInRange.add(statement);
                    }
                }
                super.postVisit(postNode);
            }
        });
        return nodesInRange;
    }

    public static List<ITypeBinding> filterSubtypeExceptions(ITypeBinding[] exceptions) {
        ArrayList<ITypeBinding> filteredExceptions = new ArrayList<ITypeBinding>(Arrays.asList(exceptions));
        Iterator subtypeIterator = filteredExceptions.iterator();
        block0: while (subtypeIterator.hasNext()) {
            ITypeBinding iTypeBinding = (ITypeBinding)subtypeIterator.next();
            for (ITypeBinding superTypeBinding : filteredExceptions) {
                if (iTypeBinding.equals((Object)superTypeBinding) || !iTypeBinding.isSubTypeCompatible(superTypeBinding)) continue;
                subtypeIterator.remove();
                continue block0;
            }
        }
        return filteredExceptions;
    }

    private List<ASTNode> getSpecialVariableDeclarationStatements() {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(3);
        VariableDeclaration[] variableDeclarationArray = this.fAnalyzer.getAffectedLocals();
        int n = variableDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableDeclaration local = variableDeclarationArray[n2];
            ASTNode parent = local.getParent();
            if (parent instanceof VariableDeclarationStatement && !result.contains(parent)) {
                result.add(parent);
            }
            ++n2;
        }
        return result;
    }

    private Statement getCatchBody(String type, String name, String lineSeparator) throws CoreException {
        String s = StubUtility.getCatchBodyContent(this.fCUnit, type, name, this.fSelectedNodes[0], lineSeparator);
        if (s == null) {
            return null;
        }
        return (Statement)this.fRewriter.createStringPlaceholder(s, 41);
    }
}

