/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.spy.css;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.spy.css.CSSPropertiesContentProvider;
import org.eclipse.pde.spy.css.CSSPropertyProvider;
import org.eclipse.pde.spy.css.Messages;
import org.eclipse.pde.spy.css.TextPopupDialog;
import org.eclipse.pde.spy.css.Util;
import org.eclipse.pde.spy.css.WidgetTreeProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CssSpyPart {
    @Inject
    @Named(value="activeShell")
    private Shell activeShell;
    @Inject
    private Display display;
    private Widget specimen;
    @Inject
    IEclipseContext mpartContext;
    private Widget shown;
    private TreeViewer widgetTreeViewer;
    private WidgetTreeProvider widgetTreeProvider;
    private Button followSelection;
    private Button showAllShells;
    private TableViewer cssPropertiesViewer;
    private Text cssRules;
    private final List<Shell> highlights = new LinkedList<Shell>();
    private final List<Region> highlightRegions = new LinkedList<Region>();
    private Text cssSearchBox;
    private Button showUnsetProperties;
    private Button showCssFragment;
    protected ViewerFilter unsetPropertyFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof CSSPropertyProvider) {
                try {
                    return ((CSSPropertyProvider)element).getValue() != null;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return false;
        }
    };
    private Composite outer;

    public static CSSStylableElement getCSSElement(Object o) {
        if (o instanceof CSSStylableElement) {
            return (CSSStylableElement)o;
        }
        CSSEngine engine = CssSpyPart.getCSSEngine(o);
        if (engine != null) {
            return (CSSStylableElement)engine.getElement(o);
        }
        return null;
    }

    public static CSSEngine getCSSEngine(Object o) {
        CSSEngine engine = null;
        if (o instanceof CSSStylableElement) {
            CSSStylableElement element = (CSSStylableElement)o;
            engine = WidgetElement.getEngine((Widget)((Widget)element.getNativeWidget()));
        }
        if (engine == null && o instanceof Widget) {
            if (((Widget)o).isDisposed()) {
                return null;
            }
            engine = WidgetElement.getEngine((Widget)((Widget)o));
        }
        if (engine == null && Display.getCurrent() != null) {
            engine = new CSSSWTEngineImpl(Display.getCurrent());
        }
        return engine;
    }

    public Widget getSpecimen() {
        return this.specimen;
    }

    private boolean isLive() {
        return this.specimen == null;
    }

    public void setSpecimen(Widget specimen) {
        this.specimen = specimen;
        this.update();
    }

    private Widget getActiveSpecimen() {
        if (this.specimen != null) {
            return this.specimen;
        }
        return this.display.getCursorControl();
    }

    protected void update() {
        if (this.activeShell == null) {
            return;
        }
        Widget current = this.getActiveSpecimen();
        if (this.shown == current) {
            return;
        }
        this.shown = current;
        CSSEngine engine = CssSpyPart.getCSSEngine(this.shown);
        CSSStylableElement element = (CSSStylableElement)engine.getElement((Object)this.shown);
        if (element == null) {
            return;
        }
        this.updateWidgetTreeInput();
        this.revealAndSelect(Collections.singletonList(this.shown));
    }

    private <T> void revealAndSelect(List<T> elements) {
        this.widgetTreeViewer.setSelection((ISelection)new StructuredSelection(elements), true);
    }

    private void updateForWidgetSelection(ISelection sel) {
        this.disposeHighlights();
        if (sel.isEmpty()) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)sel;
        for (Object s : selection.toList()) {
            if (!(s instanceof Widget)) continue;
            this.highlightWidget((Widget)s);
        }
        this.populate(selection.size() == 1 && selection.getFirstElement() instanceof Widget ? (Widget)selection.getFirstElement() : null);
    }

    private void updateWidgetTreeInput() {
        if (this.showAllShells.getSelection()) {
            this.widgetTreeViewer.setInput((Object)this.display);
        } else {
            this.widgetTreeViewer.setInput((Object)new Object[]{this.shown instanceof Control ? ((Control)this.shown).getShell() : this.shown});
        }
        this.performCSSSearch((IProgressMonitor)new NullProgressMonitor());
    }

    protected void populate(Widget selected) {
        Rectangle bounds;
        Composite nw;
        if (selected == null) {
            this.cssPropertiesViewer.setInput(null);
            this.cssRules.setText("");
            return;
        }
        if (selected.isDisposed()) {
            this.cssPropertiesViewer.setInput(null);
            this.cssRules.setText(Messages.CssSpyPart_DISPOSED);
            return;
        }
        CSSStylableElement element = CssSpyPart.getCSSElement(selected);
        if (element == null) {
            this.cssPropertiesViewer.setInput(null);
            this.cssRules.setText(Messages.CssSpyPart_Not_a_stylable_element);
            return;
        }
        this.cssPropertiesViewer.setInput((Object)selected);
        StringBuilder sb = new StringBuilder();
        CSSEngine engine = CssSpyPart.getCSSEngine(element);
        CSSStyleDeclaration decl = engine.getViewCSS().getComputedStyle((Element)element, null);
        if (element.getCSSStyle() != null) {
            sb.append(MessageFormat.format("\n{0}\n  ", Messages.CssSpyPart_CSS_Inline_Styles));
            Util.join(sb, element.getCSSStyle().split(";"), ";\n  ");
        }
        if (decl != null) {
            sb.append(MessageFormat.format("\n\n{0}\n", Messages.CssSpyPart_CSS_Properties_));
            try {
                if (decl != null) {
                    sb.append(decl.getCssText());
                }
            }
            catch (Exception e) {
                sb.append(e);
            }
        }
        if (element.getStaticPseudoInstances().length > 0) {
            sb.append(MessageFormat.format("\n\n{0}\n  ", Messages.CssSpyPart_Static_Pseudoinstances));
            Util.join(sb, element.getStaticPseudoInstances(), "\n  ");
        }
        if (element.getCSSClass() != null) {
            sb.append(MessageFormat.format("\n\n{0}\n  ", Messages.CssSpyPart_CSS_Classes));
            Util.join(sb, element.getCSSClass().split(" +"), "\n  ");
        }
        if (element.getCSSId() != null) {
            sb.append(MessageFormat.format("\n\n{0}\n  ", Messages.CssSpyPart_CSS_ID_));
            Util.join(sb, element.getCSSId().split(" +"), "\n  ");
        }
        if (element.getAttribute("style") != null) {
            sb.append(MessageFormat.format("\n\n{0}\n  ", Messages.CssSpyPart_SWT_Style_Bits));
            Util.join(sb, element.getAttribute("style").split(" +"), "\n  ");
        }
        sb.append(MessageFormat.format("\n\n{0}\n  ", Messages.CssSpyPart_CSS_Class_Element)).append(element.getClass().getName());
        if (element.getNativeWidget() instanceof Shell && ((Shell)element.getNativeWidget()).getParent() != null) {
            nw = (Shell)element.getNativeWidget();
            sb.append(MessageFormat.format("\n\n{0} ", Messages.CssSpyPart_Shell_parent)).append(nw.getParent());
        }
        if (element.getNativeWidget() instanceof Composite) {
            nw = (Composite)element.getNativeWidget();
            sb.append(MessageFormat.format("\n\n{0} ", Messages.CssSpyPart_SWT_Layout)).append(nw.getLayout());
        }
        if ((bounds = this.getBounds(selected)) != null) {
            sb.append(MessageFormat.format("\n{0} ", Messages.CssSpyPart_Bounds)).append("x=").append(bounds.x).append(" y=").append(bounds.y);
            sb.append(" h=").append(bounds.height).append(" w=").append(bounds.width);
        }
        if (element.getNativeWidget() instanceof Widget) {
            Widget w = (Widget)element.getNativeWidget();
            if (w.getData() != null) {
                sb.append(MessageFormat.format("\n{0} ", Messages.CssSpyPart_Widget_data)).append(w.getData());
            }
            if (w.getData("org.eclipse.swt.skin.id") != null) {
                sb.append(MessageFormat.format("\n{0} ", MessageFormat.format(Messages.CssSpyPart_Widget_Skin_ID, "org.eclipse.swt.skin.id"))).append(w.getData("org.eclipse.swt.skin.id"));
            }
            if (w.getData("org.eclipse.swt.skin.class") != null) {
                sb.append(MessageFormat.format("\n{0} ", MessageFormat.format(Messages.CssSpyPart_Widget_Skin_Class, "org.eclipse.swt.skin.class"))).append(w.getData("org.eclipse.swt.skin.class"));
            }
        }
        this.cssRules.setText(sb.toString().trim());
        this.disposeHighlights();
        this.highlightWidget(selected);
    }

    private Shell getShell(Widget widget) {
        if (widget instanceof Control) {
            return ((Control)widget).getShell();
        }
        return null;
    }

    private void highlightWidget(Widget selected) {
        if (selected == null || selected.isDisposed()) {
            return;
        }
        Rectangle bounds = this.getBounds(selected);
        if (bounds == null) {
            return;
        }
        Shell selectedShell = this.getShell(selected);
        Shell highlight = new Shell(selectedShell, 540680);
        highlight.setBackground(this.display.getSystemColor(3));
        highlight.setData("org.eclipse.e4.ui.css.id", (Object)"css-spy");
        Region highlightRegion = new Region();
        highlightRegion.add(0, 0, 1, bounds.height + 2);
        highlightRegion.add(0, 0, bounds.width + 2, 1);
        highlightRegion.add(bounds.width + 1, 0, 1, bounds.height + 2);
        highlightRegion.add(0, bounds.height + 1, bounds.width + 2, 1);
        highlight.setRegion(highlightRegion);
        highlight.setBounds(bounds.x - 1, bounds.y - 1, bounds.width + 2, bounds.height + 2);
        highlight.setEnabled(false);
        highlight.setVisible(true);
        this.highlights.add(highlight);
        this.highlightRegions.add(highlightRegion);
    }

    private void disposeHighlights() {
        for (Shell highlight : this.highlights) {
            highlight.dispose();
        }
        this.highlights.clear();
        for (Region region : this.highlightRegions) {
            region.dispose();
        }
        this.highlightRegions.clear();
    }

    private Rectangle getBounds(Widget widget) {
        if (widget instanceof Shell) {
            return ((Shell)widget).getBounds();
        }
        if (widget instanceof Control) {
            Control control = (Control)widget;
            Rectangle bounds = control.getBounds();
            return control.getDisplay().map((Control)control.getParent(), null, bounds);
        }
        if (widget instanceof ToolItem) {
            ToolItem item = (ToolItem)widget;
            Rectangle bounds = item.getBounds();
            return item.getDisplay().map((Control)item.getParent(), null, bounds);
        }
        if (widget instanceof CTabItem) {
            CTabItem item = (CTabItem)widget;
            Rectangle bounds = item.getBounds();
            return item.getDisplay().map((Control)item.getParent(), null, bounds);
        }
        return null;
    }

    @PostConstruct
    protected Control createDialogArea(Composite parent, IEclipseContext ctx) {
        this.outer = parent;
        this.outer.setLayout((Layout)new GridLayout());
        this.outer.setLayoutData((Object)new GridData(1808));
        Composite top = new Composite(this.outer, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(top);
        this.cssSearchBox = new Text(top, 896);
        this.cssSearchBox.setMessage(Messages.CssSpyPart_CSS_Selector);
        this.cssSearchBox.setToolTipText(Messages.CssSpyPart_Highlight_matching_widgets);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.cssSearchBox);
        this.followSelection = new Button(top, 32);
        this.followSelection.setSelection(true);
        this.followSelection.setText(Messages.CssSpyPart_Follow_UI_Selection);
        GridDataFactory.swtDefaults().applyTo((Control)this.followSelection);
        this.showAllShells = new Button(top, 32);
        this.showAllShells.setText(Messages.CssSpyPart_All_shells);
        GridDataFactory.swtDefaults().applyTo((Control)this.showAllShells);
        GridDataFactory.fillDefaults().applyTo((Control)top);
        SashForm sashForm = new SashForm(this.outer, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite widgetsComposite = new Composite((Composite)sashForm, 0);
        this.widgetTreeViewer = new TreeViewer(widgetsComposite, 2050);
        this.widgetTreeProvider = new WidgetTreeProvider();
        this.widgetTreeViewer.setContentProvider((IContentProvider)this.widgetTreeProvider);
        this.widgetTreeViewer.setAutoExpandLevel(0);
        this.widgetTreeViewer.getTree().setLinesVisible(true);
        this.widgetTreeViewer.getTree().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.widgetTreeViewer);
        TreeViewerColumn widgetTypeColumn = new TreeViewerColumn(this.widgetTreeViewer, 0);
        widgetTypeColumn.getColumn().setWidth(100);
        widgetTypeColumn.getColumn().setText(Messages.CssSpyPart_Widget);
        widgetTypeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object item) {
                CSSStylableElement element = CssSpyPart.getCSSElement(item);
                return element.getLocalName() + " " + MessageFormat.format(Messages.CssSpyPart_NamespaceURI, element.getNamespaceURI());
            }
        });
        TreeViewerColumn widgetClassColumn = new TreeViewerColumn(this.widgetTreeViewer, 0);
        widgetClassColumn.getColumn().setText(Messages.CssSpyPart_CSS_Class);
        widgetClassColumn.getColumn().setWidth(100);
        widgetClassColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object item) {
                CSSStylableElement element = CssSpyPart.getCSSElement(item);
                if (element.getCSSClass() == null) {
                    return null;
                }
                String[] classes = element.getCSSClass().split(" +");
                return classes.length <= 1 ? classes[0] : classes[0] + " " + MessageFormat.format(Messages.CssSpyPart_plus_others, classes.length - 1);
            }

            public String getToolTipText(Object item) {
                CSSStylableElement element = CssSpyPart.getCSSElement(item);
                if (element == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(element.getLocalName()).append(" ").append(MessageFormat.format(Messages.CssSpyPart_NamespaceURI, element.getNamespaceURI()));
                if (element.getCSSClass() != null) {
                    sb.append(MessageFormat.format("\n{0}\n  ", Messages.CssSpyPart_Classes));
                    Util.join(sb, element.getCSSClass().split(" +"), "\n  ");
                }
                return sb.toString();
            }
        });
        TreeViewerColumn widgetIdColumn = new TreeViewerColumn(this.widgetTreeViewer, 0);
        widgetIdColumn.getColumn().setWidth(100);
        widgetIdColumn.getColumn().setText(Messages.CssSpyPart_CSS_ID);
        widgetIdColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object item) {
                CSSStylableElement element = CssSpyPart.getCSSElement(item);
                return element.getCSSId();
            }
        });
        TreeColumnLayout widgetsTableLayout = new TreeColumnLayout();
        widgetsTableLayout.setColumnData((Widget)widgetTypeColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        widgetsTableLayout.setColumnData((Widget)widgetIdColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(40));
        widgetsTableLayout.setColumnData((Widget)widgetClassColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(40));
        widgetsComposite.setLayout((Layout)widgetsTableLayout);
        Composite container = new Composite((Composite)sashForm, 0);
        container.setLayout((Layout)new GridLayout(2, true));
        Label lblCssProperties = new Label(container, 0);
        lblCssProperties.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        lblCssProperties.setText(Messages.CssSpyPart_CSS_Properties);
        Label lblCssRules = new Label(container, 0);
        lblCssRules.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        lblCssRules.setText(Messages.CssSpyPart_CSS_Rules);
        Composite propsComposite = new Composite(container, 2048);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.minimumHeight = 50;
        propsComposite.setLayoutData((Object)gridData);
        this.cssPropertiesViewer = new TableViewer(propsComposite, 68352);
        this.cssPropertiesViewer.setContentProvider((IContentProvider)new CSSPropertiesContentProvider());
        this.cssPropertiesViewer.getTable().setLinesVisible(true);
        this.cssPropertiesViewer.getTable().setHeaderVisible(true);
        this.cssPropertiesViewer.setComparator(new ViewerComparator());
        final TextCellEditor textCellEditor = new TextCellEditor((Composite)this.cssPropertiesViewer.getTable());
        TableViewerEditor.create((TableViewer)this.cssPropertiesViewer, (SWTFocusCellManager)new TableViewerFocusCellManager(this.cssPropertiesViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.cssPropertiesViewer)), (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.cssPropertiesViewer), (int)58);
        TableViewerColumn propName = new TableViewerColumn(this.cssPropertiesViewer, 0);
        propName.getColumn().setWidth(100);
        propName.getColumn().setText(Messages.CssSpyPart_Property);
        propName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((CSSPropertyProvider)element).getPropertyName();
            }
        });
        TableViewerColumn propValue = new TableViewerColumn(this.cssPropertiesViewer, 0);
        propValue.getColumn().setWidth(100);
        propValue.getColumn().setText(Messages.CssSpyPart_Value);
        propValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                try {
                    return ((CSSPropertyProvider)element).getValue();
                }
                catch (Exception e) {
                    System.err.println(MessageFormat.format(Messages.CssSpyPart_Error_fetching_property, element, e));
                    return null;
                }
            }
        });
        propValue.setEditingSupport(new EditingSupport((ColumnViewer)this.cssPropertiesViewer){

            protected CellEditor getCellEditor(Object element) {
                return textCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                try {
                    String value = ((CSSPropertyProvider)element).getValue();
                    return value == null ? "" : value;
                }
                catch (Exception exception) {
                    return "";
                }
            }

            protected void setValue(Object element, Object value) {
                try {
                    if (value == null || ((String)value).trim().length() == 0) {
                        return;
                    }
                    CSSPropertyProvider provider = (CSSPropertyProvider)element;
                    provider.setValue((String)value);
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)CssSpyPart.this.activeShell, (String)Messages.CssSpyPart_Error, (String)(MessageFormat.format("{0}\n\n", Messages.CssSpyPart_Unable_to_set_property) + e.getMessage()));
                }
                CssSpyPart.this.cssPropertiesViewer.update(element, null);
            }
        });
        TableColumnLayout propsTableLayout = new TableColumnLayout();
        propsTableLayout.setColumnData((Widget)propName.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        propsTableLayout.setColumnData((Widget)propValue.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        propsComposite.setLayout((Layout)propsTableLayout);
        this.cssRules = new Text(container, 2818);
        this.cssRules.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.showUnsetProperties = new Button(container, 32);
        this.showUnsetProperties.setText(Messages.CssSpyPart_Show_unset_properties);
        this.showCssFragment = new Button(container, 8);
        this.showCssFragment.setText(Messages.CssSpyPart_Show_CSS_fragment);
        this.showCssFragment.setToolTipText(Messages.CssSpyPart_Generates_CSS_rule_block_for_the_selected_widget);
        new Label(container, 0);
        this.cssSearchBox.addModifyListener(new ModifyListener(){
            private Runnable updater;
            private IProgressMonitor monitor;

            public void modifyText(ModifyEvent e) {
                if (this.monitor != null) {
                    this.monitor.setCanceled(false);
                }
                this.updater = new Runnable(){

                    @Override
                    public void run() {
                        if (updater == this) {
                            monitor = new NullProgressMonitor();
                            CssSpyPart.this.performCSSSearch(monitor);
                        }
                    }
                };
                CssSpyPart.this.display.timerExec(200, this.updater);
            }
        });
        this.cssSearchBox.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.keyCode == 0x1000002 && (e.stateMask & SWT.MODIFIER_MASK) == 0) {
                this.widgetTreeViewer.getControl().setFocus();
            }
        }));
        this.widgetTreeViewer.addSelectionChangedListener(event -> {
            this.updateForWidgetSelection(event.getSelection());
            this.showCssFragment.setEnabled(!event.getSelection().isEmpty());
        });
        if (this.isLive()) {
            container.addMouseMoveListener(e -> {
                if (this.followSelection.getSelection()) {
                    this.update();
                }
            });
        }
        this.showAllShells.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateWidgetTreeInput()));
        this.outer.addDisposeListener(e -> this.dispose());
        this.showUnsetProperties.setSelection(true);
        this.showUnsetProperties.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.showUnsetProperties.getSelection()) {
                this.cssPropertiesViewer.removeFilter(this.unsetPropertyFilter);
            } else {
                this.cssPropertiesViewer.addFilter(this.unsetPropertyFilter);
            }
        }));
        this.showCssFragment.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CssSpyPart.this.showCssFragment();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        sashForm.setWeights(new int[]{50, 50});
        this.widgetTreeViewer.getControl().setFocus();
        return this.outer;
    }

    @Inject
    protected void reactOnActivate(@Named(value="e4ActivePart") MPart p, MPart cssPart, @Named(value="activeShell") Shell s) {
        if (this.followSelection == null || !this.followSelection.getSelection()) {
            return;
        }
        if (this.outer == null) {
            return;
        }
        this.activeShell = s;
        Control control = this.display.getCursorControl();
        Shell controlShell = control == null ? this.display.getActiveShell() : control.getShell();
        Shell spyPartShell = this.outer.getShell();
        if (p != cssPart) {
            this.disposeHighlights();
        } else if (spyPartShell != controlShell) {
            this.shown = null;
            this.setSpecimen((Widget)control);
        }
    }

    protected void showCssFragment() {
        if (!(this.widgetTreeViewer.getSelection() instanceof IStructuredSelection) || this.widgetTreeViewer.getSelection().isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = ((IStructuredSelection)this.widgetTreeViewer.getSelection()).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Widget) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                this.addCssFragment((Widget)o, sb);
            }
            ++n2;
        }
        TextPopupDialog tpd = new TextPopupDialog(this.widgetTreeViewer.getControl().getShell(), Messages.CssSpyPart_CSS, sb.toString(), true, Messages.CssSpyPart_Escape_to_dismiss);
        tpd.open();
    }

    private void addCssFragment(Widget w, StringBuilder sb) {
        CSSValue cssValue;
        String declValue;
        CSSStylableElement element = CssSpyPart.getCSSElement(w);
        if (element == null) {
            return;
        }
        sb.append(element.getLocalName());
        if (element.getCSSId() != null) {
            sb.append("#").append(element.getCSSId());
        }
        sb.append(" {");
        CSSEngine engine = CssSpyPart.getCSSEngine(element);
        CSSStyleDeclaration decl = engine.getViewCSS().getComputedStyle((Element)element, null);
        ArrayList propertyNames = new ArrayList(engine.getCSSProperties((Object)element));
        Collections.sort(propertyNames);
        int count = 0;
        Iterator iter = propertyNames.iterator();
        while (iter.hasNext()) {
            String propertyName = (String)iter.next();
            String genValue = this.trim(engine.retrieveCSSProperty((Object)element, propertyName, ""));
            declValue = null;
            if (genValue == null) continue;
            if (decl != null && (cssValue = decl.getPropertyCSSValue(propertyName)) != null) {
                declValue = this.trim(cssValue.getCssText());
            }
            if (count == 0) {
                sb.append(MessageFormat.format("\n  /* {0} */", Messages.CssSpyPart_actual_values));
            }
            sb.append("\n  ").append(propertyName).append(": ").append(genValue).append(";");
            if (declValue != null) {
                sb.append(MessageFormat.format("\t/* {0} */", MessageFormat.format(Messages.CssSpyPart_declared_in_CSS, declValue)));
            }
            ++count;
            iter.remove();
        }
        if (decl != null) {
            int declCount = 0;
            for (String propertyName : propertyNames) {
                declValue = null;
                cssValue = decl.getPropertyCSSValue(propertyName);
                if (cssValue != null) {
                    declValue = this.trim(cssValue.getCssText());
                }
                if (declValue == null) continue;
                if (declCount == 0) {
                    sb.append(MessageFormat.format("\n\n  /* {0} */", Messages.CssSpyPart_declared_in_CSS_rules));
                }
                sb.append("\n  ").append(propertyName).append(": ").append(declValue).append(";");
                ++count;
                ++declCount;
            }
        }
        sb.append(count > 0 ? "\n}" : "}");
    }

    private String trim(String s) {
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() > 0 ? s : null;
    }

    protected void performCSSSearch(IProgressMonitor progress) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        this.performCSSSearch(progress, this.cssSearchBox.getText(), widgets);
        if (!progress.isCanceled()) {
            this.revealAndSelect(widgets);
        }
    }

    private void performCSSSearch(IProgressMonitor monitor, String text, Collection<Widget> results) {
        if (text.trim().isEmpty()) {
            return;
        }
        this.widgetTreeViewer.collapseAll();
        Object[] roots = this.widgetTreeProvider.getElements(this.widgetTreeViewer.getInput());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format(Messages.CssSpyPart_Searching_for, text), (int)(roots.length * 10));
        Object[] objectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Object root = objectArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            CSSStylableElement element = CssSpyPart.getCSSElement(root);
            if (element != null) {
                CSSEngine engine = CssSpyPart.getCSSEngine(root);
                try {
                    SelectorList selectors = engine.parseSelectors(text);
                    subMonitor.split(2);
                    this.processCSSSearch((IProgressMonitor)subMonitor.split(8), engine, selectors, element, null, results);
                }
                catch (IOException | CSSParseException e) {
                    System.out.println(e.toString());
                }
            }
            ++n2;
        }
        monitor.done();
    }

    private void processCSSSearch(IProgressMonitor monitor, CSSEngine engine, SelectorList selectors, CSSStylableElement element, String pseudo, Collection<Widget> results) {
        if (monitor.isCanceled()) {
            return;
        }
        NodeList children = element.getChildNodes();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CssSpyPart_Searching, (int)(5 + 5 * children.getLength()));
        boolean matched = false;
        int i = 0;
        while (i < selectors.getLength()) {
            matched = engine.matches(selectors.item(i), (Object)element, pseudo);
            if (matched) break;
            ++i;
        }
        if (matched) {
            results.add((Widget)element.getNativeWidget());
        }
        subMonitor.split(5);
        i = 0;
        while (i < children.getLength()) {
            this.processCSSSearch((IProgressMonitor)subMonitor.split(5), engine, selectors, (CSSStylableElement)children.item(i), pseudo, results);
            ++i;
        }
    }

    protected void dispose() {
        this.disposeHighlights();
    }
}

