/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.ApiDescription;
import org.eclipse.pde.api.tools.internal.CRCVisitor;
import org.eclipse.pde.api.tools.internal.TypeAnnotations;
import org.eclipse.pde.api.tools.internal.builder.BuildStamps;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.scanner.TagScanner;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectApiDescription
extends ApiDescription {
    private final IJavaProject fProject;
    public long fPackageTimeStamp = 0L;
    private volatile boolean fRefreshingInProgress;
    public IFile fManifestFile;
    private volatile boolean fInSynch;

    public ProjectApiDescription(IJavaProject project) {
        super(project.getElementName());
        this.fProject = project;
    }

    @Override
    public synchronized void accept(ApiDescriptionVisitor visitor, IProgressMonitor monitor) {
        boolean completeVisit = true;
        if (this.fInSynch) {
            super.accept(visitor, monitor);
        } else {
            try {
                try {
                    IPackageFragment[] fragments = this.getLocalPackageFragments();
                    IJavaElement[] children = null;
                    IJavaElement child = null;
                    ICompilationUnit unit = null;
                    IPackageFragment[] iPackageFragmentArray = fragments;
                    int n = fragments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageDescriptor packageDescriptor;
                        ApiDescription.ManifestNode pkgNode;
                        IPackageFragment fragment = iPackageFragmentArray[n2];
                        if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                            System.out.println("\t" + fragment.getElementName());
                        }
                        if ((pkgNode = this.findNode(packageDescriptor = Factory.packageDescriptor(fragment.getElementName()), false)) != null) {
                            IApiAnnotations annotations = this.resolveAnnotations(pkgNode, packageDescriptor);
                            if (visitor.visitElement(packageDescriptor, annotations)) {
                                IJavaElement[] iJavaElementArray = children = fragment.getChildren();
                                int n3 = children.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IJavaElement element = iJavaElementArray[n4];
                                    if (monitor != null && monitor.isCanceled()) {
                                        throw new OperationCanceledException();
                                    }
                                    child = element;
                                    if (child instanceof ICompilationUnit) {
                                        unit = (ICompilationUnit)child;
                                        String cuName = unit.getElementName();
                                        String tName = cuName.substring(0, cuName.length() - ".java".length());
                                        this.visit(visitor, unit.getType(tName));
                                    } else if (child instanceof IOrdinaryClassFile) {
                                        this.visit(visitor, ((IOrdinaryClassFile)child).getType());
                                    }
                                    ++n4;
                                }
                            } else {
                                completeVisit = false;
                            }
                            visitor.endVisitElement(packageDescriptor, annotations);
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    completeVisit = false;
                    ApiPlugin.log(e.getStatus());
                    if (completeVisit) {
                        this.fInSynch = true;
                    }
                }
            }
            finally {
                if (completeVisit) {
                    this.fInSynch = true;
                }
            }
        }
    }

    private void visit(ApiDescriptionVisitor visitor, IType type) {
        IElementDescriptor element = this.getElementDescriptor((IJavaElement)type);
        ApiDescription.ManifestNode typeNode = this.findNode(element, false);
        if (typeNode != null) {
            this.visitType(typeNode, visitor);
        }
    }

    void visitType(ApiDescription.ManifestNode node, ApiDescriptionVisitor visitor) {
        IApiAnnotations annotations = this.resolveAnnotations(node, node.element);
        if (visitor.visitElement(node.element, annotations) && node.children != null) {
            this.visitChildren(visitor, node.children, null);
        }
        visitor.endVisitElement(node.element, annotations);
    }

    @Override
    protected boolean isInsertOnResolve(IElementDescriptor elementDescriptor) {
        return switch (elementDescriptor.getElementType()) {
            case 5, 6 -> false;
            case 2 -> {
                if (((IReferenceTypeDescriptor)elementDescriptor).getEnclosingType() == null) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected ApiDescription.ManifestNode createNode(ApiDescription.ManifestNode parentNode, IElementDescriptor element) {
        switch (element.getElementType()) {
            case 1: {
                try {
                    pkg = (IPackageDescriptor)element;
                    roots = this.getJavaProject().getPackageFragmentRoots();
                    fragments = new ArrayList<IPackageFragment>(1);
                    var9_9 = roots;
                    var8_11 = roots.length;
                    var7_13 = 0;
                    while (var7_13 < var8_11) {
                        root = var9_9[var7_13];
                        entry = root.getRawClasspathEntry();
                        switch (entry.getEntryKind()) {
                            case 1: 
                            case 3: {
                                fragment = root.getPackageFragment(pkg.getName());
                                if (!fragment.exists()) break;
                                fragments.add(fragment);
                                break;
                            }
                            default: {
                                if (root.isArchive() || root.getKind() != 2 || !(fragment = root.getPackageFragment(pkg.getName())).exists()) break;
                                fragments.add(fragment);
                            }
                        }
                        ++var7_13;
                    }
                    if (!fragments.isEmpty()) ** GOTO lbl31
                    return null;
                }
                catch (CoreException v0) {
                    return null;
                }
lbl31:
                // 2 sources

                return this.newPackageNode(fragments.toArray(new IPackageFragment[fragments.size()]), parentNode, element, 2, 0);
            }
            case 2: {
                descriptor = (IReferenceTypeDescriptor)element;
                try {
                    type = null;
                    name = descriptor.getName();
                    if (parentNode instanceof PackageNode) {
                        var10_18 = fragments = ((PackageNode)parentNode).fFragments;
                        var9_10 = fragments.length;
                        var8_12 = 0;
                        while (var8_12 < var9_10) {
                            fragment = var10_18[var8_12];
                            if (fragment.getKind() == 1) {
                                unit = fragment.getCompilationUnit(name + ".java");
                                try {
                                    resource = unit.getUnderlyingResource();
                                    if (resource == null) ** GOTO lbl56
                                    type = unit.getType(name);
                                }
                                catch (JavaModelException jme) {
                                    if (jme.getJavaModelStatus().isDoesNotExist()) ** GOTO lbl56
                                    throw jme;
                                }
                            } else {
                                file = fragment.getClassFile(name + ".class");
                                if (file.exists() && file instanceof IOrdinaryClassFile) {
                                    type = ((IOrdinaryClassFile)file).getType();
                                }
                            }
lbl56:
                            // 6 sources

                            ++var8_12;
                        }
                    } else if (parentNode instanceof TypeNode) {
                        type = ((TypeNode)parentNode).fType.getType(name);
                    }
                    if (type != null) {
                        return this.newTypeNode(type, parentNode, element, 0, 0);
                    }
                }
                catch (CoreException v1) {
                    return null;
                }
                return null;
            }
        }
        return super.createNode(parentNode, element);
    }

    public PackageNode newPackageNode(IPackageFragment[] fragments, ApiDescription.ManifestNode parent, IElementDescriptor descriptor, int vis, int res) {
        return new PackageNode(fragments, parent, descriptor, vis, res);
    }

    TypeNode newTypeNode(IType type, ApiDescription.ManifestNode parent, IElementDescriptor descriptor, int vis, int res) {
        return new TypeNode(type, parent, descriptor, vis, res);
    }

    ApiDescription.ManifestNode newNode(ApiDescription.ManifestNode parent, IElementDescriptor element, int vis, int res) {
        return new ApiDescription.ManifestNode(parent, element, vis, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshPackages() {
        if (this.fRefreshingInProgress) {
            this.logPackafesRefresh();
            return;
        }
        ProjectApiDescription projectApiDescription = this;
        synchronized (projectApiDescription) {
            if (this.fRefreshingInProgress) {
                this.logPackafesRefresh();
                return;
            }
            if (this.fManifestFile == null || this.fManifestFile.getModificationStamp() != this.fPackageTimeStamp) {
                try {
                    this.modified();
                    this.fRefreshingInProgress = true;
                    for (PackageNode node : this.fPackageMap.values()) {
                        node.visibility = 2;
                    }
                    this.fManifestFile = this.getJavaProject().getProject().getFile("META-INF/MANIFEST.MF");
                    if (this.fManifestFile.exists()) {
                        try {
                            IPackageFragment[] fragments = this.getLocalPackageFragments();
                            HashSet<String> names = new HashSet<String>();
                            IPackageFragment[] iPackageFragmentArray = fragments;
                            int n = fragments.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IPackageFragment fragment = iPackageFragmentArray[n2];
                                names.add(fragment.getElementName());
                                ++n2;
                            }
                            ProjectComponent component = this.getApiComponent();
                            BundleComponent.initializeApiDescription(this, component.getBundleDescription(), names);
                            this.fPackageTimeStamp = this.fManifestFile.getModificationStamp();
                        }
                        catch (CoreException e) {
                            ApiPlugin.log(e.getStatus());
                        }
                    }
                }
                finally {
                    this.fRefreshingInProgress = false;
                }
            }
        }
    }

    private void logPackafesRefresh() {
        if (ApiPlugin.DEBUG_API_DESCRIPTION) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Refreshing manifest node: ");
            buffer.append(this);
            buffer.append(" aborted because a refresh is already in progress");
            System.out.println(buffer.toString());
        }
    }

    private IElementDescriptor getElementDescriptor(IJavaElement element) {
        return switch (element.getElementType()) {
            case 4 -> Factory.packageDescriptor(element.getElementName());
            case 7 -> Factory.typeDescriptor(((IType)element).getFullyQualifiedName('$'));
            default -> null;
        };
    }

    private IJavaProject getJavaProject() {
        return this.fProject;
    }

    synchronized IApiTypeContainer getApiTypeContainer(IPackageFragmentRoot root) throws CoreException {
        IApiTypeContainer container = this.getApiComponent().getTypeContainer(root);
        if (container == null) {
            throw new CoreException(Status.error((String)"Unable to resolve type conatiner for package fragment root"));
        }
        return container;
    }

    private IPackageFragment[] getLocalPackageFragments() {
        ArrayList local = new ArrayList();
        try {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = this.getJavaProject().getPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                IResource resource = root.getCorrespondingResource();
                if (resource != null && resource.getProject().equals((Object)this.getJavaProject().getProject())) {
                    IJavaElement[] children = root.getChildren();
                    Collections.addAll(local, children);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return local.toArray(new IPackageFragment[local.size()]);
    }

    public synchronized String getXML() throws CoreException {
        Document document = Util.newDocument();
        Element component = document.createElement("component");
        component.setAttribute("id", this.getJavaProject().getElementName());
        component.setAttribute("modificationStamp", Long.toString(this.fPackageTimeStamp));
        component.setAttribute("version", "1.2");
        document.appendChild(component);
        this.persistChildren(document, component, this.fPackageMap);
        return Util.serializeDocument(document);
    }

    void persistChildren(Document document, Element xmlElement, Map<IElementDescriptor, ApiDescription.ManifestNode> elementMap) {
        for (ApiDescription.ManifestNode node : elementMap.values()) {
            node.persistXML(document, xmlElement);
        }
    }

    public synchronized void clean() {
        this.fPackageMap.clear();
        this.fPackageTimeStamp = -1L;
        this.fInSynch = false;
        this.modified();
    }

    public void projectChanged() {
        this.fInSynch = false;
    }

    public synchronized void projectClasspathChanged() {
        this.fInSynch = false;
        this.fPackageTimeStamp = -1L;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Project API description for: ").append(this.getJavaProject().getElementName());
        return buffer.toString();
    }

    private ProjectComponent getApiComponent() throws CoreException {
        IApiBaseline baseline = ApiBaselineManager.getManager().getWorkspaceBaseline();
        ProjectComponent component = (ProjectComponent)baseline.getApiComponent(this.getJavaProject().getProject());
        if (component == null) {
            throw new CoreException(Status.error((String)"Unable to resolve project API component for API description"));
        }
        return component;
    }

    @Override
    protected IApiAnnotations resolveAnnotations(ApiDescription.ManifestNode node, IElementDescriptor element) {
        IApiAnnotations ann = super.resolveAnnotations(node, element);
        if (node instanceof TypeNode) {
            return new TypeAnnotations(ann, ((TypeNode)node).fBuildStamp);
        }
        return ann;
    }

    class PackageNode
    extends ApiDescription.ManifestNode {
        IPackageFragment[] fFragments;

        public PackageNode(IPackageFragment[] fragments, ApiDescription.ManifestNode parent, IElementDescriptor element, int visibility, int restrictions) {
            super(parent, element, visibility, restrictions);
            this.fFragments = fragments;
        }

        @Override
        protected ApiDescription.ManifestNode refresh() {
            ProjectApiDescription.this.refreshPackages();
            IPackageFragment[] iPackageFragmentArray = this.fFragments;
            int n = this.fFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment fFragment = iPackageFragmentArray[n2];
                if (!fFragment.exists()) {
                    ProjectApiDescription.this.modified();
                    return null;
                }
                ++n2;
            }
            return this;
        }

        @Override
        void persistXML(Document document, Element parentElement) {
            if (this.hasApiVisibility(this)) {
                Element pkg = document.createElement("package");
                IPackageFragment[] iPackageFragmentArray = this.fFragments;
                int n = this.fFragments.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment fFragment = iPackageFragmentArray[n2];
                    Element fragment = document.createElement("fragment");
                    fragment.setAttribute("handle", fFragment.getHandleIdentifier());
                    pkg.appendChild(fragment);
                    ++n2;
                }
                pkg.setAttribute("visibility", Integer.toString(this.visibility));
                ProjectApiDescription.this.persistChildren(document, pkg, this.children);
                parentElement.appendChild(pkg);
            }
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            String name = ((IPackageDescriptor)this.element).getName();
            buffer.append("Package Node: ").append(name.equals("") ? "<default package>" : name);
            buffer.append("\nVisibility: ").append(VisibilityModifiers.getVisibilityName(this.visibility));
            buffer.append("\nRestrictions: ").append(RestrictionModifiers.getRestrictionText(this.restrictions));
            if (this.fFragments != null) {
                buffer.append("\nFragments:");
                IPackageFragment fragment = null;
                IPackageFragment[] iPackageFragmentArray = this.fFragments;
                int n = this.fFragments.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment fFragment;
                    fragment = fFragment = iPackageFragmentArray[n2];
                    buffer.append("\n\t").append(fragment.getElementName());
                    buffer.append(" [");
                    buffer.append(fragment.getParent().getElementName());
                    buffer.append("]");
                    ++n2;
                }
            }
            return buffer.toString();
        }
    }

    class TypeNode
    extends ApiDescription.ManifestNode {
        long fTimeStamp;
        long fBuildStamp;
        private volatile boolean fRefreshing;
        IType fType;

        public TypeNode(IType type, ApiDescription.ManifestNode parent, IElementDescriptor element, int visibility, int restrictions) {
            super(parent, element, visibility, restrictions);
            this.fTimeStamp = -1L;
            this.fBuildStamp = -1L;
            this.fType = type;
            if (parent instanceof TypeNode) {
                this.fTimeStamp = ((TypeNode)parent).fTimeStamp;
                this.fBuildStamp = ((TypeNode)parent).fBuildStamp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected ApiDescription.ManifestNode refresh() {
            if (this.fRefreshing) {
                this.logRefreshing();
                return this;
            }
            TypeNode typeNode = this;
            synchronized (typeNode) {
                block21: {
                    if (this.fRefreshing) {
                        this.logRefreshing();
                        return this;
                    }
                    try {
                        this.fRefreshing = true;
                        int parentVis = ProjectApiDescription.this.resolveVisibility(this.parent);
                        if (!VisibilityModifiers.isAPI(parentVis)) break block21;
                        ICompilationUnit unit = this.fType.getCompilationUnit();
                        if (unit != null) {
                            IResource resource;
                            block22: {
                                resource = null;
                                try {
                                    resource = unit.getUnderlyingResource();
                                }
                                catch (JavaModelException e) {
                                    if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                                        StringBuilder buffer = new StringBuilder();
                                        buffer.append("Failed to get underlying resource for compilation unit: ");
                                        buffer.append(unit);
                                        System.out.println(buffer.toString());
                                    }
                                    if (e.getJavaModelStatus().isDoesNotExist()) break block22;
                                    ApiPlugin.log(e.getStatus());
                                    TypeNode typeNode2 = this;
                                    this.fRefreshing = false;
                                    return typeNode2;
                                }
                            }
                            if (resource != null && resource.exists()) {
                                long stamp = resource.getModificationStamp();
                                if (stamp == this.fTimeStamp) break block21;
                                CRCVisitor visitor = new CRCVisitor();
                                ProjectApiDescription.this.visitType(this, visitor);
                                long crc = visitor.getValue();
                                if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                                    StringBuilder buffer = new StringBuilder();
                                    buffer.append("Resource has changed for type manifest node: ");
                                    buffer.append(this);
                                    buffer.append(" tag scanning the new type");
                                    buffer.append(" (CRC ");
                                    buffer.append(crc);
                                    buffer.append(')');
                                    System.out.println(buffer.toString());
                                }
                                ProjectApiDescription.this.modified();
                                this.children.clear();
                                this.restrictions = 0;
                                this.fTimeStamp = resource.getModificationStamp();
                                try {
                                    TagScanner.newScanner().scan(unit, ProjectApiDescription.this, ProjectApiDescription.this.getApiTypeContainer((IPackageFragmentRoot)this.fType.getPackageFragment().getParent()), null);
                                }
                                catch (CoreException e) {
                                    ApiPlugin.log(e.getStatus());
                                }
                                visitor = new CRCVisitor();
                                ProjectApiDescription.this.visitType(this, visitor);
                                long crc2 = visitor.getValue();
                                if (crc == crc2) break block21;
                                this.fBuildStamp = BuildStamps.getBuildStamp(resource.getProject());
                                if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                                    StringBuilder buffer = new StringBuilder();
                                    buffer.append("CRC changed for type manifest node: ");
                                    buffer.append(this);
                                    buffer.append(" (CRC ");
                                    buffer.append(crc2);
                                    buffer.append(')');
                                    System.out.println(buffer.toString());
                                }
                                break block21;
                            }
                            if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                                StringBuilder buffer = new StringBuilder();
                                buffer.append("Underlying resource for the type manifest node: ");
                                buffer.append(this);
                                buffer.append(" does not exist or is null");
                                System.out.println(buffer.toString());
                            }
                            ProjectApiDescription.this.modified();
                            this.parent.children.remove(this.element);
                            return null;
                        }
                        if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                            StringBuilder buffer = new StringBuilder();
                            buffer.append("Failed to look up compilation unit for ");
                            buffer.append(this.fType);
                            buffer.append(" refreshing type manifest node: ");
                            buffer.append(this);
                            System.out.println(buffer.toString());
                        }
                    }
                    finally {
                        this.fRefreshing = false;
                    }
                }
                return this;
            }
        }

        private void logRefreshing() {
            if (ApiPlugin.DEBUG_API_DESCRIPTION) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Refreshing manifest node: ");
                buffer.append(this);
                buffer.append(" aborted because a refresh is already in progress");
                System.out.println(buffer.toString());
            }
        }

        @Override
        void persistXML(Document document, Element parentElement) {
            if (this.hasApiVisibility(this)) {
                Element type = document.createElement("type");
                type.setAttribute("handle", this.fType.getHandleIdentifier());
                this.persistAnnotations(type);
                type.setAttribute("modificationStamp", Long.toString(this.fTimeStamp));
                ProjectApiDescription.this.persistChildren(document, type, this.children);
                parentElement.appendChild(type);
            }
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Type Node: ").append(this.fType.getFullyQualifiedName());
            buffer.append("\nVisibility: ").append(VisibilityModifiers.getVisibilityName(this.visibility));
            buffer.append("\nRestrictions: ").append(RestrictionModifiers.getRestrictionText(this.restrictions));
            if (this.parent != null) {
                String pname = this.parent.element.getElementType() == 1 ? ((IPackageDescriptor)this.parent.element).getName() : ((IReferenceTypeDescriptor)this.parent.element).getQualifiedName();
                buffer.append("\nParent: ").append(pname);
            }
            return buffer.toString();
        }
    }
}

