/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.xtext.base.serializer.CommentSegmentSupport;
import org.eclipse.ocl.xtext.base.serializer.SerializationBuilder;
import org.eclipse.ocl.xtext.base.serializer.SerializationSegment;
import org.eclipse.ocl.xtext.base.serializer.SerializationUtils;
import org.eclipse.ocl.xtext.base.serializer.UserElementFormatter;
import org.eclipse.ocl.xtext.base.serializer.UserModelAnalysis;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.formatting.impl.AbstractNodeModelFormatter;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Strings;

public class DeclarativeFormatter
extends AbstractNodeModelFormatter {
    public static final @NonNull TracingOption FORMATTER_FRAGMENTS = new TracingOption("org.eclipse.ocl.xtext.base", "formatter/fragments");
    @Inject
    private @NonNull UserModelAnalysis modelAnalysis;
    @Inject
    private @NonNull SerializationBuilder serializationBuilder;
    private int selectEnd;
    protected String rootText;
    private int extendedSelectStart;
    private int extendedSelectEnd;
    private Boundary start;
    private Boundary end;

    private static @NonNull Darkness getDarkness(@NonNull INode node) {
        if (!(node instanceof ILeafNode)) {
            return Darkness.DARK;
        }
        if (!((ILeafNode)node).isHidden()) {
            return Darkness.DARK;
        }
        String text = node.getText();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!Character.isWhitespace(c)) {
                return Darkness.COMMENT;
            }
            ++i;
        }
        return Darkness.WHITE;
    }

    /*
     * Unable to fully structure code
     */
    protected static @Nullable ILeafNode nextDarkNode(@NonNull INode node) {
        text = node.getText();
        ** GOTO lbl11
        {
            v0 = text = (node = node.getParent()) != null ? node.getText() : null;
            do {
                if (node != null && !node.hasNextSibling()) continue block0;
                if (node != null) {
                    text = (node = node.getNextSibling()) != null ? node.getText() : null;
                }
                while (node instanceof ICompositeNode && ((ICompositeNode)node).hasChildren()) {
                    v1 = text = (node = ((ICompositeNode)node).getFirstChild()) != null ? node.getText() : null;
                }
lbl11:
                // 2 sources

            } while (node != null && DeclarativeFormatter.getDarkness(node) != Darkness.DARK);
        }
        return (ILeafNode)node;
    }

    /*
     * Unable to fully structure code
     */
    protected static @Nullable ILeafNode previousDarkNode(@NonNull INode node) {
        ** GOTO lbl10
        {
            node = node.getParent();
            do {
                if (node != null && !node.hasPreviousSibling()) continue block0;
                if (node != null) {
                    node = node.getPreviousSibling();
                }
                while (node instanceof ICompositeNode && ((ICompositeNode)node).hasChildren()) {
                    node = ((ICompositeNode)node).getLastChild();
                }
lbl10:
                // 2 sources

            } while (node != null && (!(node instanceof ILeafNode) || ((ILeafNode)node).isHidden()));
        }
        return (ILeafNode)node;
    }

    private @NonNull Boundary createEndBoundary(@NonNull ICompositeNode rootNode, int selectIndex) {
        assert (selectIndex <= rootNode.getTotalEndOffset());
        if (selectIndex == rootNode.getTotalEndOffset()) {
            ILeafNode selectedNode = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)(selectIndex - 1));
            assert (selectedNode != null);
            return new EndBoundary(this, "end", selectedNode, selectIndex);
        }
        ILeafNode selectedNode = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)(selectIndex < rootNode.getTotalEndOffset() ? selectIndex : rootNode.getTotalEndOffset() - 1));
        assert (selectedNode != null);
        Darkness darkness = DeclarativeFormatter.getDarkness((INode)selectedNode);
        if (darkness == Darkness.DARK) {
            return new DarkBoundary(this, "dark-end", selectedNode, selectIndex);
        }
        if (darkness == Darkness.COMMENT) {
            return new CommentBoundary(this, "comment-end", selectedNode, selectIndex);
        }
        return new WhiteEndBoundary(this, "white-end", selectedNode, selectIndex);
    }

    private @NonNull Boundary createStartBoundary(@NonNull ICompositeNode rootNode, int selectIndex) {
        assert (selectIndex >= 0);
        ILeafNode selectedNode = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)selectIndex);
        assert (selectedNode != null);
        Darkness darkness = DeclarativeFormatter.getDarkness((INode)selectedNode);
        if (darkness == Darkness.DARK) {
            return new DarkBoundary(this, "dark-start", selectedNode, selectIndex);
        }
        if (darkness == Darkness.COMMENT) {
            return new CommentBoundary(this, "comment-start", selectedNode, selectIndex);
        }
        return new WhiteStartBoundary(this, "white-start", selectedNode, selectIndex);
    }

    protected String debugContext(@NonNull EObject semanticElement, AbstractElement compoundedGrammarElement) {
        StringBuilder s = new StringBuilder();
        s.append(semanticElement.eClass().getName());
        s.append(" ");
        AbstractRule rule = GrammarUtil.containingRule((EObject)compoundedGrammarElement);
        s.append(rule.getName());
        s.append("..");
        s.append(compoundedGrammarElement.eClass().getName());
        if (compoundedGrammarElement instanceof Keyword) {
            s.append(" '" + ((Keyword)compoundedGrammarElement).getValue() + "'");
        } else if (compoundedGrammarElement instanceof Action) {
            s.append(" {" + ((Action)compoundedGrammarElement).getType() + "}");
        } else if (compoundedGrammarElement instanceof Assignment) {
            s.append(" =" + ((Assignment)compoundedGrammarElement).getFeature() + "=");
        } else if (compoundedGrammarElement instanceof RuleCall) {
            s.append(" @" + ((RuleCall)compoundedGrammarElement).getRule().getName() + "@");
        } else {
            s.append(" ?" + compoundedGrammarElement.eClass().getName() + "?");
        }
        return s.toString();
    }

    public INodeModelFormatter.IFormattedRegion format(ICompositeNode rootNode, int selectStart, int selectLength) {
        assert (rootNode != null);
        this.serializationBuilder.resetBuilder();
        this.selectEnd = selectStart + selectLength;
        this.rootText = rootNode.getText();
        String selectedText = this.rootText.substring(selectStart, this.selectEnd);
        this.start = this.createStartBoundary(rootNode, selectStart);
        this.end = this.createEndBoundary(rootNode, this.selectEnd);
        this.extendedSelectStart = this.start.getExtendedStartIndex();
        this.extendedSelectEnd = this.end.getExtendedEndIndex();
        String extendedText = this.rootText.substring(this.extendedSelectStart, this.extendedSelectEnd);
        this.formatRootNode(rootNode);
        ILeafNode lastNode = this.getLastLeafNode(rootNode);
        if (lastNode != null && this.isFormatting((INode)lastNode) && this.rootText.endsWith("\n")) {
            this.serializationBuilder.append(SerializationBuilder.NEW_LINE);
        }
        String reformattedText = this.serializationBuilder.toString();
        this.start.setReformattedText(reformattedText);
        this.end.setReformattedText(reformattedText);
        int startIndex = this.start.getReformattedSelectIndex();
        int endIndex = this.end.getReformattedSelectIndex();
        String newNewText = reformattedText.substring(startIndex, endIndex);
        return new AbstractNodeModelFormatter.FormattedRegion(selectStart, this.selectEnd - selectStart, newNewText);
    }

    protected void formatCompositeNode(@NonNull ICompositeNode compositeNode, int indent) {
        INode nextSibling;
        int n;
        boolean isFormatting;
        INode firstChild;
        INode prevSibling;
        boolean isTracing = FORMATTER_FRAGMENTS.isActive();
        String text = compositeNode.getText();
        assert (text != null);
        EObject semanticElement = compositeNode.getSemanticElement();
        assert (semanticElement != null);
        if (semanticElement.eClass().getName().equals("TransformationCS")) {
            ((Object)((Object)this)).getClass();
        }
        AbstractElement compoundedGrammarElement = this.getCompoundedGrammarElement((INode)compositeNode);
        EList<?> assignedCollection = this.getAssignedCollection(compositeNode, compoundedGrammarElement);
        UserElementFormatter elementFormatter = this.modelAnalysis.createUserElementFormatter((INode)compositeNode, compoundedGrammarElement, semanticElement);
        if (isTracing) {
            FORMATTER_FRAGMENTS.println(String.valueOf(SerializationUtils.getIndent(this.modelAnalysis.getDepth())) + "composite: " + semanticElement.eClass().getName() + " \"" + LabelUtil.getLabel((Object)semanticElement) + "\" " + LabelUtil.getLabel((Object)compoundedGrammarElement) + " '" + StringUtil.convertToOCLString((String)text) + "'");
            this.modelAnalysis.pushDepth();
        }
        EList<?> prevAssignedCollection = null;
        if (assignedCollection != null && (prevSibling = compositeNode.getPreviousSibling()) instanceof ICompositeNode) {
            prevAssignedCollection = this.getAssignedCollection((ICompositeNode)prevSibling, this.getCompoundedGrammarElement(prevSibling));
        }
        if ((firstChild = compositeNode.getFirstChild()) != null) {
            if (DeclarativeFormatter.getDarkness(firstChild) != Darkness.DARK) {
                firstChild = DeclarativeFormatter.nextDarkNode(firstChild);
            }
            if (firstChild != null && (assignedCollection == null || assignedCollection != prevAssignedCollection)) {
                isFormatting = this.isFormatting(firstChild);
                @NonNull Object[] outerFormattingSegments = elementFormatter.getOuterFormattingSegments();
                if (isTracing) {
                    FORMATTER_FRAGMENTS.println(String.valueOf(SerializationUtils.getIndent(this.modelAnalysis.getDepth() - 1)) + " outers: " + this.debugContext(semanticElement, compoundedGrammarElement) + " " + Arrays.toString(outerFormattingSegments));
                }
                Object[] objectArray = outerFormattingSegments;
                n = outerFormattingSegments.length;
                int n2 = 0;
                while (n2 < n) {
                    SerializationSegment formattingSegment = objectArray[n2];
                    if (formattingSegment.isValue()) break;
                    if (isFormatting || formattingSegment.isControl()) {
                        if (isTracing) {
                            FORMATTER_FRAGMENTS.println(String.valueOf(SerializationUtils.getIndent(this.modelAnalysis.getDepth())) + "outer: " + formattingSegment);
                        }
                        formattingSegment.format(elementFormatter, this.serializationBuilder);
                    }
                    ++n2;
                }
            }
        }
        isFormatting = this.isFormatting((INode)compositeNode);
        boolean hasProlog = false;
        for (INode childNode : SerializationUtils.getChildren(compositeNode)) {
            if (!this.isProlog(childNode)) continue;
            hasProlog = true;
            break;
        }
        @NonNull Object[] innerFormattingSegments = elementFormatter.getInnerFormattingSegments();
        if (isTracing) {
            FORMATTER_FRAGMENTS.println(String.valueOf(SerializationUtils.getIndent(this.modelAnalysis.getDepth())) + "inners: " + this.debugContext(semanticElement, compoundedGrammarElement) + " " + Arrays.toString(innerFormattingSegments));
            this.modelAnalysis.pushDepth();
        }
        Object[] objectArray = innerFormattingSegments;
        int n3 = innerFormattingSegments.length;
        n = 0;
        while (n < n3) {
            SerializationSegment formattingSegment = objectArray[n];
            if (formattingSegment.isValue()) {
                for (INode childNode : SerializationUtils.getChildren(compositeNode)) {
                    if (!this.isEpilog(childNode)) {
                        if (isTracing) {
                            FORMATTER_FRAGMENTS.println(String.valueOf(SerializationUtils.getIndent(this.modelAnalysis.getDepth())) + "inner: " + formattingSegment);
                            this.modelAnalysis.pushDepth();
                        }
                        this.formatNode(childNode, indent + 1);
                        if (!isTracing) continue;
                        this.modelAnalysis.popDepth();
                        continue;
                    }
                    break;
                }
            } else if (!hasProlog && isFormatting || formattingSegment.isControl()) {
                if (isTracing) {
                    FORMATTER_FRAGMENTS.println(String.valueOf(SerializationUtils.getIndent(this.modelAnalysis.getDepth())) + "inner: " + formattingSegment);
                }
                formattingSegment.format(elementFormatter, this.serializationBuilder);
            }
            ++n;
        }
        if (isTracing) {
            this.modelAnalysis.popDepth();
        }
        EList<?> nextAssignedCollection = null;
        if (assignedCollection != null && (nextSibling = compositeNode.getNextSibling()) instanceof ICompositeNode) {
            nextAssignedCollection = this.getAssignedCollection((ICompositeNode)nextSibling, this.getCompoundedGrammarElement(nextSibling));
        }
        if (assignedCollection == null || assignedCollection != nextAssignedCollection) {
            SerializationSegment[] outerFormattingSegments;
            boolean isTail = false;
            SerializationSegment[] serializationSegmentArray = outerFormattingSegments = elementFormatter.getOuterFormattingSegments();
            int n4 = outerFormattingSegments.length;
            int n5 = 0;
            while (n5 < n4) {
                SerializationSegment formattingSegment = serializationSegmentArray[n5];
                if (!isTail) {
                    if (formattingSegment.isValue()) {
                        isTail = true;
                    }
                } else if (isFormatting || formattingSegment.isControl()) {
                    if (isTracing) {
                        FORMATTER_FRAGMENTS.println(String.valueOf(SerializationUtils.getIndent(this.modelAnalysis.getDepth())) + "outer: " + formattingSegment);
                    }
                    formattingSegment.format(elementFormatter, this.serializationBuilder);
                }
                ++n5;
            }
        }
        if (isTracing) {
            this.modelAnalysis.popDepth();
        }
    }

    protected void formatDocumentationNode(@NonNull ILeafNode leafNode, int indent) {
        CommentSegmentSupport commentSegmentSupport = this.modelAnalysis.getCommentSegmentSupport();
        if (commentSegmentSupport != null) {
            String body = ElementUtil.getCommentBody(leafNode);
            commentSegmentSupport.appendBody(this.serializationBuilder, body);
        }
    }

    protected void formatLeafNode(@NonNull ILeafNode leafNode, int indent) {
        boolean isTracing = FORMATTER_FRAGMENTS.isActive();
        String text = leafNode.getText();
        assert (text != null);
        if (",".equals(text)) {
            ((Object)((Object)this)).getClass();
        }
        if (isTracing) {
            FORMATTER_FRAGMENTS.println(String.valueOf(SerializationUtils.getIndent(this.modelAnalysis.getDepth())) + "leaf: '" + StringUtil.convertToOCLString((String)leafNode.getText()) + "'");
        }
        if (!leafNode.isHidden()) {
            int n;
            EObject semanticElement = leafNode.getSemanticElement();
            assert (semanticElement != null);
            AbstractElement compoundedGrammarElement = this.getCompoundedGrammarElement((INode)leafNode);
            UserElementFormatter elementFormatter = this.modelAnalysis.createUserElementFormatter((INode)leafNode, compoundedGrammarElement, semanticElement);
            INode prevSibling = leafNode.getPreviousSibling();
            block0: while (prevSibling == null || prevSibling instanceof ILeafNode) {
                if (prevSibling == null || !((ILeafNode)prevSibling).isHidden()) {
                    SerializationSegment[] outerFormattingSegments;
                    AbstractElement prevCompoundedGrammarElement;
                    AbstractElement abstractElement = prevCompoundedGrammarElement = prevSibling != null ? this.getCompoundedGrammarElement(prevSibling) : null;
                    if (compoundedGrammarElement == prevCompoundedGrammarElement) break;
                    SerializationSegment[] serializationSegmentArray = outerFormattingSegments = elementFormatter.getOuterFormattingSegments();
                    int n2 = outerFormattingSegments.length;
                    n = 0;
                    while (n < n2) {
                        SerializationSegment formattingSegment = serializationSegmentArray[n];
                        if (formattingSegment.isValue()) break block0;
                        formattingSegment.format(elementFormatter, this.serializationBuilder);
                        ++n;
                    }
                    break;
                }
                prevSibling = prevSibling.getPreviousSibling();
            }
            boolean isFormatting = this.isFormatting((INode)leafNode);
            @NonNull Object[] innerFormattingSegments = elementFormatter.getInnerFormattingSegments();
            if (isTracing) {
                FORMATTER_FRAGMENTS.println(String.valueOf(SerializationUtils.getIndent(this.modelAnalysis.getDepth())) + "inners: " + this.debugContext(semanticElement, compoundedGrammarElement) + " " + Arrays.toString(innerFormattingSegments));
                this.modelAnalysis.pushDepth();
            }
            Object[] objectArray = innerFormattingSegments;
            n = innerFormattingSegments.length;
            int formattingSegment = 0;
            while (formattingSegment < n) {
                SerializationSegment formattingSegment2 = objectArray[formattingSegment];
                if (isFormatting || formattingSegment2.isControl()) {
                    if (isTracing) {
                        FORMATTER_FRAGMENTS.println(String.valueOf(SerializationUtils.getIndent(this.modelAnalysis.getDepth())) + "inner: " + formattingSegment2);
                    }
                    formattingSegment2.format(elementFormatter, this.serializationBuilder);
                    if (formattingSegment2.isValue()) {
                        int index = this.serializationBuilder.length();
                        this.start.setLeafNodeAt(leafNode, index);
                        this.end.setLeafNodeAt(leafNode, index);
                    }
                }
                ++formattingSegment;
            }
            if (isTracing) {
                this.modelAnalysis.popDepth();
            }
            INode nextSibling = leafNode.getNextSibling();
            while (nextSibling == null || nextSibling instanceof ILeafNode) {
                if (nextSibling == null || !((ILeafNode)nextSibling).isHidden()) {
                    SerializationSegment[] outerFormattingSegments;
                    AbstractElement nextCompoundedGrammarElement;
                    AbstractElement abstractElement = nextCompoundedGrammarElement = nextSibling != null ? this.getCompoundedGrammarElement(nextSibling) : null;
                    if (compoundedGrammarElement == nextCompoundedGrammarElement) break;
                    boolean isTail = false;
                    SerializationSegment[] serializationSegmentArray = outerFormattingSegments = elementFormatter.getOuterFormattingSegments();
                    int n3 = outerFormattingSegments.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        SerializationSegment formattingSegment3 = serializationSegmentArray[n4];
                        if (!isTail) {
                            if (formattingSegment3.isValue()) {
                                isTail = true;
                            }
                        } else {
                            formattingSegment3.format(elementFormatter, this.serializationBuilder);
                        }
                        ++n4;
                    }
                    break;
                }
                nextSibling = nextSibling.getNextSibling();
            }
        }
    }

    protected void formatNode(@NonNull INode childNode, int indent) {
        EObject grammarElement = childNode.getGrammarElement();
        assert (grammarElement != null);
        assert (!(grammarElement instanceof CompoundElement));
        if (childNode instanceof ICompositeNode) {
            this.formatCompositeNode((ICompositeNode)childNode, indent);
        } else {
            ILeafNode leafNode = (ILeafNode)childNode;
            if (!leafNode.isHidden()) {
                this.formatLeafNode(leafNode, indent);
            } else if (this.isDocumentation(leafNode)) {
                this.formatDocumentationNode(leafNode, indent);
            }
        }
    }

    protected void formatRootNode(@NonNull ICompositeNode rootNode) {
        EObject eObject = rootNode.getSemanticElement();
        assert (eObject != null);
        this.modelAnalysis.analyze(eObject);
        this.formatCompositeNode(rootNode, 0);
    }

    protected @Nullable EList<?> getAssignedCollection(@NonNull ICompositeNode compositeNode, @NonNull AbstractElement compoundedGrammarElement) {
        if (!(compoundedGrammarElement instanceof Assignment)) {
            return null;
        }
        Assignment assignment = (Assignment)compoundedGrammarElement;
        EStructuralFeature eStructuralFeature = SerializationUtils.getEStructuralFeature(assignment);
        if (!eStructuralFeature.isMany()) {
            return null;
        }
        EObject firstSemanticElement = null;
        EObject secondSemanticElement = null;
        ICompositeNode iNode = compositeNode;
        while (iNode != null) {
            if (iNode instanceof CompositeNodeWithSemanticElement) {
                CompositeNodeWithSemanticElement compositeNodeWithSemanticElement = (CompositeNodeWithSemanticElement)iNode;
                if (firstSemanticElement == null) {
                    firstSemanticElement = compositeNodeWithSemanticElement.getSemanticElement();
                } else {
                    secondSemanticElement = compositeNodeWithSemanticElement.getSemanticElement();
                    break;
                }
            }
            iNode = iNode.getParent();
        }
        EObject theSemanticElement = compositeNode instanceof CompositeNodeWithSemanticElement ? secondSemanticElement : (compositeNode.getFirstChild() == null ? secondSemanticElement : firstSemanticElement);
        assert (theSemanticElement != null);
        return (EList)theSemanticElement.eGet(eStructuralFeature);
    }

    protected @NonNull AbstractElement getCompoundedGrammarElement(@NonNull INode node) {
        AbstractElement abstractElement;
        EObject grammarElement = node.getGrammarElement();
        EObject eContainer = grammarElement.eContainer();
        while (eContainer instanceof AbstractElement && !(eContainer instanceof CompoundElement)) {
            grammarElement = eContainer;
            eContainer = grammarElement.eContainer();
        }
        AbstractElement abstractElement2 = abstractElement = grammarElement instanceof AbstractElement ? (AbstractElement)grammarElement : SerializationUtils.getAlternatives((AbstractRule)grammarElement);
        if (abstractElement instanceof Group ? !$assertionsDisabled && !(abstractElement.eContainer() instanceof AbstractRule) : !(abstractElement instanceof Assignment) && !(abstractElement instanceof RuleCall) && !(abstractElement instanceof Keyword) && !(abstractElement instanceof Action) && !$assertionsDisabled) {
            throw new AssertionError();
        }
        return abstractElement;
    }

    private @Nullable ILeafNode getLastLeafNode(@NonNull ICompositeNode rootNode) {
        ICompositeNode lastNode = rootNode;
        while (lastNode instanceof ICompositeNode && lastNode.hasChildren()) {
            lastNode = lastNode.getLastChild();
        }
        return lastNode instanceof ILeafNode ? (ILeafNode)lastNode : null;
    }

    public @NonNull String getRootText() {
        assert (this.rootText != null);
        return this.rootText;
    }

    protected boolean isDocumentation(@NonNull ILeafNode leafNode) {
        TerminalRule terminalRule;
        String name;
        EObject grammarElement = leafNode.getGrammarElement();
        return grammarElement instanceof TerminalRule && "ML_COMMENT".equals(name = (terminalRule = (TerminalRule)grammarElement).getName());
    }

    private boolean isEpilog(@NonNull INode node) {
        int totalOffset = node.getOffset();
        return this.extendedSelectEnd < totalOffset;
    }

    private boolean isFormatting(@NonNull INode node) {
        return !this.isProlog(node) && !this.isEpilog(node);
    }

    private boolean isProlog(@NonNull INode node) {
        int totalEndOffset = node.getTotalEndOffset();
        return totalEndOffset <= this.extendedSelectStart;
    }

    protected static abstract class Boundary {
        protected final @NonNull DeclarativeFormatter formatter;
        protected final @NonNull String name;
        protected final int selectIndex;
        protected final @NonNull ILeafNode selectedNode;
        protected final int relativeSelectIndex;
        protected int selectedNodeReformattedEndIndex;

        protected Boundary(@NonNull DeclarativeFormatter formatter, @NonNull String name, @NonNull ILeafNode selectedNode, int selectIndex) {
            this.formatter = formatter;
            this.name = name;
            this.selectedNode = selectedNode;
            this.selectIndex = selectIndex;
            this.relativeSelectIndex = selectIndex - selectedNode.getOffset();
            assert (selectedNode.getOffset() == selectedNode.getTotalOffset());
            assert (selectedNode.getEndOffset() == selectedNode.getTotalEndOffset());
        }

        public abstract void debugPrintln(@NonNull String var1);

        protected void debugPrintlnIdent(@NonNull String indent) {
            System.out.println(String.valueOf(indent) + this.name + " @ " + this.selectIndex);
        }

        protected @NonNull String debugText(@Nullable INode node) {
            if (node != null) {
                return String.valueOf(node.getTotalOffset()) + "-" + node.getOffset() + " .. " + node.getEndOffset() + "-" + node.getTotalEndOffset() + " '" + Strings.convertToJavaString((String)node.getText()) + "'";
            }
            return "null";
        }

        public int getExtendedEndIndex() {
            return this.selectedNode.getTotalEndOffset();
        }

        public int getExtendedStartIndex() {
            return this.selectedNode.getTotalOffset();
        }

        public @NonNull String getName() {
            return this.name;
        }

        public abstract int getReformattedSelectIndex();

        public int getSelectIndex() {
            return this.selectIndex;
        }

        public @NonNull ILeafNode getSelectedNode() {
            return this.selectedNode;
        }

        public @NonNull String toString() {
            return String.valueOf(this.name) + ":" + this.selectIndex + this.debugText((INode)this.selectedNode);
        }

        public void setLeafNodeAt(@NonNull ILeafNode leafNode, int endIndex) {
            if (leafNode == this.selectedNode) {
                this.selectedNodeReformattedEndIndex = endIndex;
            }
        }

        public void setReformattedText(@NonNull String reformattedText) {
        }
    }

    protected static class CommentBoundary
    extends HiddenBoundary {
        private int reformattedSelectIndex = -1;

        public CommentBoundary(@NonNull DeclarativeFormatter formatter, @NonNull String name, @NonNull ILeafNode selectedNode, int selectIndex) {
            super(formatter, name, selectedNode, selectIndex);
            assert (selectedNode.isHidden());
            assert (selectedNode.getOffset() <= selectIndex && selectIndex < selectedNode.getEndOffset());
        }

        @Override
        public void debugPrintln(@NonNull String indent) {
            super.debugPrintln(indent);
            System.out.println(String.valueOf(indent) + "\tselection: " + (this.selectIndex - this.relativeSelectIndex) + " .. " + this.selectIndex + " .. " + (this.selectIndex - this.relativeSelectIndex + this.selectedNode.getLength()) + " => " + (this.reformattedSelectIndex - this.relativeSelectIndex) + " .. " + this.reformattedSelectIndex + " .. " + (this.reformattedSelectIndex - this.relativeSelectIndex + this.selectedNode.getLength()));
        }

        @Override
        public int getReformattedSelectIndex() {
            return this.reformattedSelectIndex;
        }

        @Override
        public void setReformattedText(@NonNull String newText) {
            int i = this.precedingNodeNewEndOffset;
            while (i < newText.length()) {
                char c = newText.charAt(i);
                if (!Character.isWhitespace(c)) {
                    this.reformattedSelectIndex = i + this.relativeSelectIndex;
                    return;
                }
                ++i;
            }
            assert (false);
        }
    }

    protected static class DarkBoundary
    extends Boundary {
        public DarkBoundary(@NonNull DeclarativeFormatter formatter, @NonNull String name, @NonNull ILeafNode selectedNode, int selectIndex) {
            super(formatter, name, selectedNode, selectIndex);
            assert (!selectedNode.isHidden());
            assert (selectedNode.getOffset() <= selectIndex && selectIndex < selectedNode.getEndOffset());
        }

        @Override
        public void debugPrintln(@NonNull String indent) {
            this.debugPrintlnIdent(indent);
            System.out.println(String.valueOf(indent) + "\tselectedNode: " + this.debugText((INode)this.selectedNode) + " => " + (this.selectedNodeReformattedEndIndex - this.selectedNode.getLength()) + " .. " + this.selectedNodeReformattedEndIndex);
        }

        @Override
        public int getReformattedSelectIndex() {
            return this.selectedNodeReformattedEndIndex + this.selectIndex - this.selectedNode.getEndOffset();
        }
    }

    static enum Darkness {
        DARK,
        COMMENT,
        WHITE;

    }

    protected static class EndBoundary
    extends Boundary {
        private @Nullable String reformattedText = null;

        public EndBoundary(@NonNull DeclarativeFormatter formatter, @NonNull String name, @NonNull ILeafNode selectedNode, int selectIndex) {
            super(formatter, name, selectedNode, selectIndex);
            assert (selectIndex == selectedNode.getTotalEndOffset());
        }

        @Override
        public void debugPrintln(@NonNull String indent) {
            this.debugPrintlnIdent(indent);
            if (this.reformattedText != null) {
                System.out.println(String.valueOf(indent) + "\tselectedNode: " + this.debugText((INode)this.selectedNode) + " => '" + Strings.convertToJavaString((String)this.reformattedText) + "'");
            } else {
                System.out.println(String.valueOf(indent) + "\tselectedNode: " + this.debugText((INode)this.selectedNode));
            }
        }

        @Override
        public int getReformattedSelectIndex() {
            assert (this.reformattedText != null);
            return this.reformattedText.length();
        }

        @Override
        public void setReformattedText(@NonNull String text) {
            this.reformattedText = text;
        }
    }

    protected static abstract class HiddenBoundary
    extends Boundary {
        protected final @Nullable ILeafNode precedingNode;
        protected final @Nullable ILeafNode followingNode;
        protected int precedingNodeNewEndOffset;
        protected int followingNodeNewOffset;

        protected HiddenBoundary(@NonNull DeclarativeFormatter formatter, @NonNull String name, @NonNull ILeafNode selectedNode, int selectIndex) {
            super(formatter, name, selectedNode, selectIndex);
            assert (selectedNode.isHidden());
            assert (selectedNode.getOffset() <= selectIndex && selectIndex < selectedNode.getEndOffset());
            this.precedingNode = DeclarativeFormatter.previousDarkNode((INode)selectedNode);
            this.followingNode = DeclarativeFormatter.nextDarkNode((INode)selectedNode);
        }

        @Override
        public void debugPrintln(@NonNull String indent) {
            this.debugPrintlnIdent(indent);
            this.debugPrintlnPrecedingNode(indent);
            this.debugPrintlnSelectedNode(indent);
            this.debugPrintlnFollowingNode(indent);
        }

        protected void debugPrintlnFollowingNode(@NonNull String indent) {
            ILeafNode followingNode2 = this.followingNode;
            if (followingNode2 != null) {
                System.out.println(String.valueOf(indent) + "\tfollowingNode: " + this.debugText((INode)followingNode2) + " => " + this.followingNodeNewOffset + " .. " + (this.followingNodeNewOffset + followingNode2.getLength()));
            } else {
                System.out.println(String.valueOf(indent) + "\tfollowingNode: null");
            }
        }

        protected void debugPrintlnPrecedingNode(@NonNull String indent) {
            ILeafNode precedingNode2 = this.precedingNode;
            if (precedingNode2 != null) {
                System.out.println(String.valueOf(indent) + "\tprecedingNode: " + this.debugText((INode)precedingNode2) + " => " + (this.precedingNodeNewEndOffset - precedingNode2.getLength()) + " .. " + this.precedingNodeNewEndOffset);
            } else {
                System.out.println(String.valueOf(indent) + "\tprecedingNode: null");
            }
        }

        protected void debugPrintlnSelectedNode(@NonNull String indent) {
            System.out.println(String.valueOf(indent) + "\tselectedNode: " + this.debugText((INode)this.selectedNode));
        }

        @Override
        public int getExtendedEndIndex() {
            return this.followingNode != null ? this.followingNode.getTotalEndOffset() : this.selectedNode.getTotalEndOffset();
        }

        @Override
        public int getExtendedStartIndex() {
            return this.precedingNode != null ? this.precedingNode.getTotalOffset() : 0;
        }

        @Override
        public void setLeafNodeAt(@NonNull ILeafNode leafNode, int index) {
            super.setLeafNodeAt(leafNode, index);
            if (leafNode == this.precedingNode) {
                this.precedingNodeNewEndOffset = index;
            }
            if (leafNode == this.followingNode) {
                this.followingNodeNewOffset = index - leafNode.getLength();
            }
        }
    }

    protected static class Position {
        private final int lineNumber;
        private final int columnNumber;

        public Position(int lineNumber, int columnNumber) {
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        public @NonNull Position createPosition(@NonNull String text, int startIndex, int endIndex, boolean isWhite) {
            int lines = this.lineNumber;
            int columns = this.columnNumber;
            int index = startIndex;
            while (index < endIndex) {
                char c;
                if ((c = text.charAt(index++)) == '\n') {
                    ++lines;
                    columns = 0;
                    continue;
                }
                if (c == '\r') continue;
                if (c == '\t') {
                    columns = columns + 4 & 0xFFFFFFFC;
                    continue;
                }
                if (c == ' ' || !isWhite) {
                    ++columns;
                    continue;
                }
                assert (false);
            }
            return new Position(lines, columns);
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public @NonNull String toString() {
            return String.valueOf(this.lineNumber) + ":" + this.columnNumber;
        }
    }

    protected static abstract class WhiteBoundary
    extends HiddenBoundary {
        protected String newWhitespace;

        protected WhiteBoundary(@NonNull DeclarativeFormatter formatter, @NonNull String name, @NonNull ILeafNode selectedNode, int selectIndex) {
            super(formatter, name, selectedNode, selectIndex);
        }

        @Override
        protected void debugPrintlnSelectedNode(@NonNull String indent) {
            if (this.newWhitespace != null) {
                System.out.println(String.valueOf(indent) + "\tselectedNode: " + this.debugText((INode)this.selectedNode) + " => '" + Strings.convertToJavaString((String)this.newWhitespace) + "'");
            } else {
                System.out.println(String.valueOf(indent) + "\tselectedNode: " + this.debugText((INode)this.selectedNode));
            }
        }
    }

    protected static class WhiteEndBoundary
    extends WhiteBoundary {
        private @NonNull Position prePosition;
        private @NonNull Position selectedPosition;
        private @NonNull Position postPosition;
        private int reformattedSelectIndex;

        public WhiteEndBoundary(@NonNull DeclarativeFormatter formatter, @NonNull String name, @NonNull ILeafNode selectedNode, int selectIndex) {
            super(formatter, name, selectedNode, selectIndex);
            String rootText = formatter.getRootText();
            int selectedOffset = selectedNode.getOffset();
            this.prePosition = new Position(0, 0).createPosition(rootText, 0, selectedOffset, false);
            this.selectedPosition = this.prePosition.createPosition(rootText, selectedOffset, selectIndex, true);
            int nextNodeOffset = this.followingNode != null ? this.followingNode.getOffset() : rootText.length();
            this.postPosition = this.selectedPosition.createPosition(rootText, selectIndex, nextNodeOffset, true);
        }

        @Override
        public void debugPrintln(@NonNull String indent) {
            super.debugPrintln(indent);
            System.out.println(String.valueOf(indent) + "\told pre: " + this.prePosition + " at: " + this.selectedPosition + " post: " + this.postPosition);
        }

        @Override
        public int getReformattedSelectIndex() {
            return this.reformattedSelectIndex;
        }

        @Override
        public void setReformattedText(@NonNull String newText) {
            int newLength = newText.length();
            if (this.followingNodeNewOffset != 0 && this.followingNodeNewOffset < newLength) {
                newLength = this.followingNodeNewOffset;
            }
            this.newWhitespace = newText.substring(this.precedingNodeNewEndOffset, newLength);
            Position newPostSelection = this.prePosition.createPosition(this.newWhitespace, 0, this.newWhitespace.length(), true);
            int targetLineNumber = newPostSelection.getLineNumber();
            int targetColumnNumber = newPostSelection.getColumnNumber();
            int mandatoryLines = this.postPosition.getLineNumber() - this.selectedPosition.getLineNumber();
            int mandatoryColumns = mandatoryLines > 0 ? this.postPosition.getColumnNumber() : this.postPosition.getColumnNumber() - this.selectedPosition.getColumnNumber();
            int candidateLineNumber = this.prePosition.getLineNumber();
            int candidateColumnNumber = this.prePosition.getColumnNumber();
            int candidateIndex = 0;
            while (candidateIndex < this.newWhitespace.length()) {
                int postCandidateColumnNumber;
                int postCandidateLineNumber = candidateLineNumber + mandatoryLines;
                int n = postCandidateColumnNumber = mandatoryLines > 0 ? mandatoryColumns : candidateColumnNumber + mandatoryColumns;
                if (postCandidateLineNumber > targetLineNumber || postCandidateLineNumber == targetLineNumber && postCandidateColumnNumber >= targetColumnNumber) break;
                char c = this.newWhitespace.charAt(candidateIndex);
                if (c == '\n') {
                    ++candidateLineNumber;
                    candidateColumnNumber = 0;
                } else if (c != '\r') {
                    if (c == '\t') {
                        candidateColumnNumber = candidateColumnNumber + 4 & 0xFFFFFFFC;
                    } else if (c == ' ') {
                        ++candidateColumnNumber;
                    } else assert (false);
                }
                postCandidateLineNumber = candidateLineNumber + mandatoryLines;
                if (postCandidateLineNumber > targetLineNumber) break;
                ++candidateIndex;
            }
            this.reformattedSelectIndex = this.precedingNodeNewEndOffset + candidateIndex;
        }
    }

    protected static class WhiteStartBoundary
    extends WhiteBoundary {
        protected final @NonNull String oldWhitespace;
        private @NonNull Position prePosition;
        private @NonNull Position selectedPosition;
        private int reformattedSelectIndex;

        public WhiteStartBoundary(@NonNull DeclarativeFormatter formatter, @NonNull String name, @NonNull ILeafNode selectedNode, int selectIndex) {
            super(formatter, name, selectedNode, selectIndex);
            String rootText = formatter.getRootText();
            ILeafNode followingNode2 = this.followingNode;
            this.oldWhitespace = followingNode2 != null ? rootText.substring(selectedNode.getOffset(), followingNode2.getOffset()) : (String)ClassUtil.nonNull((Object)selectedNode.getText());
            int selectedOffset = selectedNode.getOffset();
            this.prePosition = new Position(0, 0).createPosition(rootText, 0, selectedOffset, false);
            this.selectedPosition = this.prePosition.createPosition(rootText, selectedOffset, selectIndex, true);
        }

        @Override
        public void debugPrintln(@NonNull String indent) {
            super.debugPrintln(indent);
            System.out.println(String.valueOf(indent) + "\told columns pre: " + this.prePosition + " at: " + this.selectedPosition);
        }

        protected @NonNull List<@NonNull Integer> getLastFirstNewLineIndexes(@NonNull String whitespace) {
            ArrayList<@NonNull Integer> oldNewLines = new ArrayList<Integer>();
            int i = 0;
            while (i < whitespace.length()) {
                char c = whitespace.charAt(i);
                if (c == '\n') {
                    oldNewLines.add(0, i);
                }
                ++i;
            }
            return oldNewLines;
        }

        @Override
        public int getReformattedSelectIndex() {
            return this.reformattedSelectIndex;
        }

        @Override
        public void setReformattedText(@NonNull String newText) {
            int candidateIndex;
            int newLength = newText.length();
            if (this.followingNodeNewOffset != 0 && this.followingNodeNewOffset < newLength) {
                newLength = this.followingNodeNewOffset;
            }
            int i = this.precedingNodeNewEndOffset;
            while (i < newLength) {
                char c = newText.charAt(i);
                if (!Character.isWhitespace(c)) {
                    newLength = i;
                    break;
                }
                ++i;
            }
            this.newWhitespace = newText.substring(this.precedingNodeNewEndOffset, newLength);
            Position newPostSelection = this.prePosition.createPosition(this.newWhitespace, 0, this.newWhitespace.length(), true);
            int targetLineNumber = newPostSelection.getLineNumber();
            int targetColumnNumber = newPostSelection.getColumnNumber();
            Position candidatePosition = this.selectedPosition;
            int bestIndex = candidateIndex = 0;
            int bestLineNumberOvershoot = Integer.MAX_VALUE;
            int bestColumnNumberOvershoot = Integer.MAX_VALUE;
            while (candidateIndex < this.newWhitespace.length()) {
                Position consequentPosition = candidatePosition.createPosition(this.newWhitespace, candidateIndex, this.newWhitespace.length(), true);
                int lineNumberOverShoot = consequentPosition.getLineNumber() - targetLineNumber;
                int columnNumberOverShoot = consequentPosition.getColumnNumber() - targetColumnNumber;
                boolean isBetter = false;
                if (lineNumberOverShoot >= 0 && lineNumberOverShoot < bestLineNumberOvershoot) {
                    isBetter = true;
                } else if (lineNumberOverShoot == 0 && columnNumberOverShoot >= 0 && columnNumberOverShoot < bestColumnNumberOvershoot) {
                    isBetter = true;
                }
                if (isBetter) {
                    bestIndex = candidateIndex;
                    bestLineNumberOvershoot = lineNumberOverShoot;
                    bestColumnNumberOvershoot = columnNumberOverShoot;
                }
                ++candidateIndex;
            }
            this.reformattedSelectIndex = this.precedingNodeNewEndOffset + bestIndex;
        }
    }
}

