/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.refactoring.nls.KeyValuePair;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.jdt.internal.corext.refactoring.nls.PropertyFileDocumentModel;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class NLSAccessorFieldRenameParticipant
extends RenameParticipant {
    private IField fField;
    private String fNewName;
    private TextFileChange fChange;

    public String getName() {
        return NLSMessages.NLSAccessorFieldRenameParticipant_participantName;
    }

    /*
     * Loose catch block
     */
    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 100);
        try {
            ReplaceEdit edit;
            ITextFileBufferManager manager;
            IPath propertyFilePath;
            IStorage resourceBundle;
            block22: {
                KeyValuePair oldPair;
                PropertyFileDocumentModel model;
                block21: {
                    ICompilationUnit unit = this.fField.getCompilationUnit();
                    if (unit == null) {
                        return null;
                    }
                    IType[] types = unit.getTypes();
                    if (types.length > 1) {
                        return null;
                    }
                    if (!NLSAccessorFieldRenameParticipant.isPotentialNLSAccessor(unit)) {
                        return null;
                    }
                    resourceBundle = NLSHintHelper.getResourceBundle(unit);
                    if (!(resourceBundle instanceof IFile)) {
                        return null;
                    }
                    pm.worked(50);
                    propertyFilePath = resourceBundle.getFullPath();
                    manager = FileBuffers.getTextFileBufferManager();
                    manager.connect(propertyFilePath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 25));
                    IDocument document = manager.getTextFileBuffer(propertyFilePath, LocationKind.IFILE).getDocument();
                    model = new PropertyFileDocumentModel(document);
                    oldPair = model.getKeyValuePair(this.fField.getElementName());
                    if (oldPair != null) break block21;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    manager.disconnect(propertyFilePath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 25));
                    return null;
                }
                String value = oldPair.getValue();
                KeyValuePair newPair = new KeyValuePair(this.fNewName, value);
                edit = model.replace(oldPair, newPair);
                if (edit != null) break block22;
                manager.disconnect(propertyFilePath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 25));
                return null;
            }
            try {
                try {
                    this.fChange = new TextFileChange("", (IFile)resourceBundle);
                    this.fChange.setEdit((TextEdit)edit);
                    String changeDescription = Messages.format(NLSMessages.NLSAccessorFieldRenameParticipant_changeDescription, new Object[]{this.fField.getElementName(), this.fNewName});
                    this.fChange.addTextEditChangeGroup(new TextEditChangeGroup((TextChange)this.fChange, new TextEditGroup(changeDescription, (TextEdit)edit)));
                    ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
                    IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
                    deltaFactory.change((IFile)resourceBundle);
                }
                finally {
                    manager.disconnect(propertyFilePath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 25));
                }
            }
            catch (CoreException e) {
                JavaManipulationPlugin.log(e);
                RefactoringStatus refactoringStatus = RefactoringStatus.createErrorStatus((String)NLSMessages.NLSAccessorFieldRenameParticipant_error_description);
                return refactoringStatus;
            }
        }
        finally {
            pm.done();
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.fChange;
    }

    protected boolean initialize(Object element) {
        this.fField = (IField)element;
        return true;
    }

    public boolean initialize(RefactoringProcessor processor, Object element, RefactoringArguments arguments) {
        this.fNewName = ((RenameArguments)arguments).getNewName();
        return super.initialize(processor, element, arguments);
    }

    private static boolean isPotentialNLSAccessor(ICompilationUnit unit) throws JavaModelException {
        IType type = unit.getTypes()[0];
        if (!type.exists()) {
            return false;
        }
        IField bundleNameField = NLSAccessorFieldRenameParticipant.getBundleNameField(type.getFields());
        if (bundleNameField == null) {
            return false;
        }
        if (!NLSAccessorFieldRenameParticipant.importsOSGIUtil(unit)) {
            return false;
        }
        IInitializer[] iInitializerArray = type.getInitializers();
        int n = iInitializerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IInitializer initializer = iInitializerArray[n2];
            if (Modifier.isStatic((int)initializer.getFlags())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IField getBundleNameField(IField[] fields) {
        IField[] iFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if ("BUNDLE_NAME".equals(field.getElementName())) {
                return field;
            }
            ++n2;
        }
        return null;
    }

    private static boolean importsOSGIUtil(ICompilationUnit unit) throws JavaModelException {
        IImportDeclaration[] iImportDeclarationArray = unit.getImports();
        int n = iImportDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IImportDeclaration importDecl = iImportDeclarationArray[n2];
            if (importDecl.getElementName().startsWith("org.eclipse.osgi.util.")) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

