/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.util.PatternConstructor;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class AddExportPackageMarkerResolution
extends AbstractManifestMarkerResolution {
    public AddExportPackageMarkerResolution(IMarker mark, int type) {
        super(type, mark);
        this.marker = mark;
    }

    public String getLabel() {
        return PDEUIMessages.AddExportPackageResolution_Label;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void createChange(BundleModel model) {
        IBundle bundle = model.getBundle();
        IBundle iBundle = bundle;
        if (iBundle instanceof Bundle) {
            void bun;
            Bundle bundle2 = (Bundle)iBundle;
            Bundle cfr_ignored_0 = (Bundle)iBundle;
            ExportPackageHeader header = (ExportPackageHeader)bun.getManifestHeader("Export-Package");
            if (header == null) {
                bundle.setHeader("Export-Package", "");
                header = (ExportPackageHeader)bun.getManifestHeader("Export-Package");
            }
            this.processPackages(header, false);
        }
    }

    protected void processPackages(ExportPackageHeader header, boolean setInternal) {
        String values = this.marker.getAttribute("packages", null);
        if (values == null) {
            return;
        }
        String[] packages = values.split(",");
        String filter = PDEPlugin.getDefault().getDialogSettings().get("OrganizeManifests.ExportedPackages.packageFilter");
        if (filter == null) {
            filter = "*.internal*";
        }
        Pattern pat = PatternConstructor.createPattern((String)filter, (boolean)false);
        String[] stringArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String packageId = stringArray[n2];
            ExportPackageObject obj = header.addPackage(packageId);
            if (setInternal) {
                obj.setInternal(setInternal);
            } else if (pat.matcher(packageId).matches()) {
                obj.setInternal(true);
            }
            ++n2;
        }
    }
}

