/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.command.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.List;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.edit.provider.IDisposable;

public class DualCompareCommandStack
implements ICompareCommandStack,
IDisposable {
    private static final int IS_SAVE_NEEDED_WILL_BE_TRUE = -2;
    private final BasicCommandStack leftCommandStack;
    private final BasicCommandStack rightCommandStack;
    private final List<BasicCommandStack> commandStackStack;
    private int top;
    private BasicCommandStack mostRecentCommandStack;
    private int saveIndex = -1;
    private final List<CommandStackListener> listeners;
    private final CommandStackListener sideCommandStackListener;

    public DualCompareCommandStack(BasicCommandStack leftCommandStack, BasicCommandStack rightCommandStack) {
        Preconditions.checkArgument((leftCommandStack != rightCommandStack ? 1 : 0) != 0);
        this.leftCommandStack = (BasicCommandStack)Preconditions.checkNotNull((Object)leftCommandStack);
        this.rightCommandStack = (BasicCommandStack)Preconditions.checkNotNull((Object)rightCommandStack);
        this.sideCommandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                DualCompareCommandStack.this.notifyListeners(event.getSource());
            }
        };
        this.leftCommandStack.addCommandStackListener(this.sideCommandStackListener);
        this.rightCommandStack.addCommandStackListener(this.sideCommandStackListener);
        this.listeners = Lists.newArrayList();
        this.commandStackStack = Lists.newArrayList();
        this.top = -1;
    }

    public void dispose() {
        this.leftCommandStack.removeCommandStackListener(this.sideCommandStackListener);
        this.rightCommandStack.removeCommandStackListener(this.sideCommandStackListener);
    }

    protected void notifyListeners(Object source) {
        for (CommandStackListener commandStackListener : this.listeners) {
            commandStackListener.commandStackChanged(new EventObject(source));
        }
    }

    public void execute(Command command) {
        if (command instanceof ICompareCopyCommand && command.canExecute()) {
            this.doExecute(command);
        }
    }

    private void doExecute(Command command) {
        ICompareCopyCommand compareCommand = (ICompareCopyCommand)command;
        BasicCommandStack commandStack = compareCommand.isLeftToRight() ? this.rightCommandStack : this.leftCommandStack;
        commandStack.execute((Command)compareCommand);
        if (commandStack.canUndo()) {
            this.commandStackStack.subList(this.top + 1, this.commandStackStack.size()).clear();
            this.mostRecentCommandStack = commandStack;
            this.commandStackStack.add(commandStack);
            ++this.top;
            if (this.saveIndex >= this.top) {
                this.saveIndex = -2;
            }
        } else {
            this.mostRecentCommandStack = null;
        }
        this.notifyListeners(this);
    }

    public boolean canUndo() {
        return this.top != -1 && this.commandStackStack.get(this.top).canUndo();
    }

    public void undo() {
        if (this.canUndo()) {
            BasicCommandStack commandStack = this.commandStackStack.get(this.top--);
            commandStack.undo();
            if (commandStack.canRedo()) {
                this.mostRecentCommandStack = commandStack;
            } else {
                this.mostRecentCommandStack = null;
                this.flush();
            }
            this.notifyListeners(this);
        }
    }

    public boolean canRedo() {
        return this.top < this.commandStackStack.size() - 1;
    }

    public Command getUndoCommand() {
        Command undoCommand = this.top == -1 || this.top == this.commandStackStack.size() ? null : this.commandStackStack.get(this.top).getUndoCommand();
        return undoCommand;
    }

    public Command getRedoCommand() {
        Command redoCommand = this.top + 1 >= this.commandStackStack.size() ? null : this.commandStackStack.get(this.top + 1).getRedoCommand();
        return redoCommand;
    }

    public Command getMostRecentCommand() {
        if (this.mostRecentCommandStack != null) {
            return this.mostRecentCommandStack.getMostRecentCommand();
        }
        return null;
    }

    public void redo() {
        if (this.canRedo()) {
            BasicCommandStack commandStack = this.commandStackStack.get(++this.top);
            commandStack.redo();
            if (commandStack.canUndo()) {
                this.mostRecentCommandStack = commandStack;
            } else {
                this.mostRecentCommandStack = null;
                this.commandStackStack.subList(this.top--, this.commandStackStack.size()).clear();
            }
            this.notifyListeners(this);
        }
    }

    public void flush() {
        this.commandStackStack.clear();
        this.top = -1;
        this.saveIndex = -1;
        this.mostRecentCommandStack = null;
        this.notifyListeners(this);
    }

    public void addCommandStackListener(CommandStackListener listener) {
        this.listeners.add(listener);
        this.leftCommandStack.addCommandStackListener(listener);
        this.rightCommandStack.addCommandStackListener(listener);
    }

    public void removeCommandStackListener(CommandStackListener listener) {
        this.listeners.remove(listener);
        this.leftCommandStack.removeCommandStackListener(listener);
        this.rightCommandStack.removeCommandStackListener(listener);
    }

    @Override
    public boolean isLeftSaveNeeded() {
        return this.leftCommandStack.isSaveNeeded();
    }

    @Override
    public boolean isRightSaveNeeded() {
        return this.rightCommandStack.isSaveNeeded();
    }

    @Override
    public void leftSaveIsDone() {
        this.leftCommandStack.saveIsDone();
    }

    @Override
    public void rightSaveIsDone() {
        this.rightCommandStack.saveIsDone();
    }
}

