/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.tools.DelegatingUIExecutorService;
import org.eclipse.papyrus.infra.tools.spi.INotificationBuilderFactory;
import org.eclipse.papyrus.infra.tools.util.IExecutorService;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.infra.tools";
    private static Activator plugin;
    public static LogHelper log;
    private DelegatingUIExecutorService uiExecutorService;
    private ServiceTracker<INotificationBuilderFactory, INotificationBuilderFactory> notificationBuilderTracker;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)this);
        this.notificationBuilderTracker = new ServiceTracker(context, INotificationBuilderFactory.class, null);
        this.notificationBuilderTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.notificationBuilderTracker.close();
        if (this.uiExecutorService != null) {
            this.uiExecutorService.shutdown(context);
            this.uiExecutorService = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public synchronized IExecutorService getUIExecutorService() {
        if (this.uiExecutorService == null) {
            this.uiExecutorService = new DelegatingUIExecutorService(this.getBundle().getBundleContext());
        }
        return this.uiExecutorService;
    }

    public INotificationBuilderFactory getNotificationBuilderFactory() {
        return (INotificationBuilderFactory)this.notificationBuilderTracker.getService();
    }
}

