/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.core.rules.invariantstereotype;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.types.core.impl.ConfiguredHintedSpecializationElementType;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.uml.types.core.requests.ApplyProfileRequest;
import org.eclipse.papyrus.uml.types.core.requests.ApplyStereotypeRequest;
import org.eclipse.papyrus.uml.types.core.requests.SetStereotypeValueRequest;
import org.eclipse.papyrus.uml.types.core.requests.UnapplyProfileRequest;
import org.eclipse.papyrus.uml.types.core.requests.UnapplyStereotypeRequest;
import org.eclipse.papyrus.uml.types.core.rules.AbstractUmlRule;
import org.eclipse.papyrus.uml.types.core.rules.invariantstereotype.InvariantStereotypeRuleConfiguration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class InvariantStereotypeRule
extends AbstractUmlRule<InvariantStereotypeRuleConfiguration> {
    public boolean matches(EObject eObject) {
        if (!(eObject instanceof Element)) {
            return false;
        }
        String stereotypeQualifiedName = ((InvariantStereotypeRuleConfiguration)this.invariantRuleConfiguration).getStereotypeQualifiedName();
        if (stereotypeQualifiedName == null) {
            return false;
        }
        Stereotype appliedStereotype = ((Element)eObject).getAppliedStereotype(stereotypeQualifiedName);
        if (appliedStereotype != null) {
            return true;
        }
        if (!((InvariantStereotypeRuleConfiguration)this.invariantRuleConfiguration).isStrict()) {
            for (Stereotype stereotype : ((Element)eObject).getAppliedStereotypes()) {
                for (Stereotype superStereotype : StereotypeUtil.getAllSuperStereotypes((Stereotype)stereotype)) {
                    if (!stereotypeQualifiedName.equals(superStereotype.getQualifiedName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean approveMoveRequest(ConfiguredHintedSpecializationElementType type, MoveRequest request) {
        return true;
    }

    protected boolean approveSetRequest(ConfiguredHintedSpecializationElementType type, SetRequest request) {
        return true;
    }

    protected boolean approveCreationRequest(ConfiguredHintedSpecializationElementType type, CreateElementRequest request) {
        String requiredProfileName = ((InvariantStereotypeRuleConfiguration)this.invariantRuleConfiguration).getRequiredProfile();
        if (requiredProfileName != null) {
            EObject container = request.getContainer();
            if (!(container instanceof Element)) {
                return false;
            }
            Package nearestPackage = ((Element)container).getNearestPackage();
            if (nearestPackage == null) {
                return false;
            }
            Profile appliedProfile = nearestPackage.getAppliedProfile(requiredProfileName, true);
            return appliedProfile != null;
        }
        return true;
    }

    @Override
    protected boolean approveApplyStereotypeRequest(ConfiguredHintedSpecializationElementType type, ApplyStereotypeRequest request) {
        return true;
    }

    @Override
    protected boolean approveUnapplyStereotypeRequest(ConfiguredHintedSpecializationElementType type, UnapplyStereotypeRequest request) {
        return !request.getStereotype().getQualifiedName().equals(((InvariantStereotypeRuleConfiguration)this.invariantRuleConfiguration).getStereotypeQualifiedName());
    }

    @Override
    protected boolean approveApplyProfileRequest(ConfiguredHintedSpecializationElementType type, ApplyProfileRequest request) {
        return true;
    }

    @Override
    protected boolean approveUnapplyProfileRequest(ConfiguredHintedSpecializationElementType type, UnapplyProfileRequest request) {
        String requiredProfileName = ((InvariantStereotypeRuleConfiguration)this.invariantRuleConfiguration).getRequiredProfile();
        return !requiredProfileName.equals(request.getProfile().getQualifiedName());
    }

    @Override
    protected boolean approveSetStereotypeValueRequest(ConfiguredHintedSpecializationElementType type, SetStereotypeValueRequest request) {
        return true;
    }
}

