/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;

public class XWTMaps {
    private static final Map<String, Integer> styles = new HashMap<String, Integer>();
    private static final Map<String, Integer> colors = new HashMap<String, Integer>();
    private static final Map<String, Integer> events = new HashMap<String, Integer>();
    private static final Map<String, Integer> accelerators = new HashMap<String, Integer>();

    private XWTMaps() {
    }

    private static void checkAndInit() {
        if (styles.isEmpty() || colors.isEmpty() || events.isEmpty() || accelerators.isEmpty()) {
            XWTMaps.init();
        }
    }

    private static void init() {
        styles.put("SWT.NONE", 0);
        styles.put("SWT.FILL", 4);
        styles.put("SWT.BORDER", 2048);
        styles.put("SWT.PUSH", 8);
        styles.put("SWT.CHECK", 32);
        styles.put("SWT.RADIO", 16);
        styles.put("SWT.TOGGLE", 2);
        styles.put("SWT.ARROW", 4);
        styles.put("SWT.ARROW_DOWN", 0x1000002);
        styles.put("SWT.ARROW_LEFT", 0x1000003);
        styles.put("SWT.ARROW_RIGHT", 0x1000004);
        styles.put("SWT.ARROW_UP", 0x1000001);
        styles.put("SWT.FLAT", 0x800000);
        styles.put("SWT.DROP_DOWN", 4);
        styles.put("SWT.SIMPLE", 64);
        styles.put("SWT.READ_ONLY", 8);
        styles.put("SWT.LEFT", 16384);
        styles.put("SWT.UP", 128);
        styles.put("SWT.DOWN", 1024);
        styles.put("SWT.CENTER", 0x1000000);
        styles.put("SWT.RIGHT", 131072);
        styles.put("SWT.H_SCROLL", 256);
        styles.put("SWT.V_SCROLL", 512);
        styles.put("SWT.DATE", 32);
        styles.put("SWT.TIME", 128);
        styles.put("SWT.CALENDAR", 1024);
        styles.put("SWT.SHORT", 32768);
        styles.put("SWT.MEDIUM", 65536);
        styles.put("SWT.LONG", 0x10000000);
        styles.put("SWT.WRAP", 64);
        styles.put("SWT.HORIZONTAL", 256);
        styles.put("SWT.VERTICAL", 512);
        styles.put("SWT.SEPARATOR", 2);
        styles.put("SWT.SHADOW_IN", 4);
        styles.put("SWT.SHADOW_NONE", 32);
        styles.put("SWT.SHADOW_OUT", 8);
        styles.put("SWT.NO_TRIM", 8);
        styles.put("SWT.SHELL_TRIM", 1264);
        styles.put("SWT.DIALOG_TRIM", 2144);
        styles.put("SWT.CLOSE", 64);
        styles.put("SWT.MIN", 128);
        styles.put("SWT.MAX", 1024);
        styles.put("SWT.RESIZE", 16);
        styles.put("SWT.TOOL", 4);
        styles.put("SWT.ON_TOP", 16384);
        styles.put("SWT.MODELESS", 0);
        styles.put("SWT.PRIMARY_MODAL", 32768);
        styles.put("SWT.APPLICATION_MODAL", 65536);
        styles.put("SWT.SYSTEM_MODAL", 131072);
        styles.put("SWT.TITLE", 32);
        styles.put("SWT.SINGLE", 4);
        styles.put("SWT.MULTI", 2);
        styles.put("SWT.PASSWORD", 0x400000);
        styles.put("SWT.SEARCH", 128);
        styles.put("SWT.CANCEL", 256);
        XWTMaps.tryPut(styles, "SWT.ICON");
        styles.put("SWT.ICON_ERROR", 1);
        styles.put("SWT.ICON_INFORMATION", 2);
        styles.put("SWT.ICON_QUESTION", 4);
        styles.put("SWT.ICON_WARNING", 8);
        styles.put("SWT.ICON_WORKING", 16);
        XWTMaps.tryPut(styles, "SWT.SHADOW_ETCHED_IN");
        XWTMaps.tryPut(styles, "SWT.SHADOW_ETCHED_OUT");
        XWTMaps.tryPut(styles, "SWT.BALLOON");
        XWTMaps.tryPut(styles, "SWT.NO_BACKGROUND");
        styles.put("SWT.NO_FOCUS", 524288);
        XWTMaps.tryPut(styles, "SWT.NO_MERGE_PAINTS");
        XWTMaps.tryPut(styles, "SWT.NO_REDRAW_RESIZE");
        styles.put("SWT.DOUBLE_BUFFERED", 0x20000000);
        styles.put("SWT.SMOOTH", 65536);
        styles.put("SWT.INDETERMINATE", 2);
        styles.put("SWT.FULL_SELECTION", 65536);
        styles.put("SWT.TOP", 128);
        styles.put("SWT.BOTTOM", 1024);
        styles.put("SWT.NORMAL", 0);
        styles.put("SWT.ITALIC", 2);
        styles.put("SWT.BOLD", 1);
        styles.put("SWT.LEFT_TO_RIGHT", 0x2000000);
        XWTMaps.tryPut(styles, "SWT.RIGHT_TO_LEFT");
        styles.put("SWT.BAR", 2);
        styles.put("SWT.CASCADE", 64);
        XWTMaps.tryPut(styles, "SWT.NO_RADIO_GROUP");
        styles.put("SWT.POP_UP", 8);
        styles.put("SWT.INHERIT_DEFAULT", 1);
        styles.put("SWT.INHERIT_NONE", 0);
        styles.put("SWT.INHERIT_FORCE", 2);
        colors.put("SWT.COLOR_BLACK", 2);
        colors.put("SWT.COLOR_BLUE", 9);
        colors.put("SWT.COLOR_CYAN", 13);
        colors.put("SWT.COLOR_DARK_BLUE", 10);
        colors.put("SWT.COLOR_DARK_CYAN", 14);
        colors.put("SWT.COLOR_DARK_GREEN", 6);
        colors.put("SWT.COLOR_DARK_MAGENTA", 12);
        colors.put("SWT.COLOR_DARK_RED", 4);
        colors.put("SWT.COLOR_DARK_YELLOW", 8);
        colors.put("SWT.COLOR_GRAY", 15);
        colors.put("SWT.COLOR_GREEN", 5);
        colors.put("SWT.COLOR_INFO_BACKGROUND", 29);
        colors.put("SWT.COLOR_INFO_FOREGROUND", 28);
        colors.put("SWT.COLOR_LIST_BACKGROUND", 25);
        colors.put("SWT.COLOR_LIST_FOREGROUND", 24);
        colors.put("SWT.COLOR_LIST_SELECTION", 26);
        colors.put("SWT.COLOR_LIST_SELECTION_TEXT", 27);
        colors.put("SWT.COLOR_MAGENTA", 11);
        colors.put("SWT.COLOR_RED", 3);
        colors.put("SWT.COLOR_TITLE_BACKGROUND", 31);
        colors.put("SWT.COLOR_TITLE_BACKGROUND_GRADIENT", 32);
        colors.put("SWT.COLOR_TITLE_FOREGROUND", 30);
        colors.put("SWT.COLOR_TITLE_INACTIVE_BACKGROUND", 34);
        colors.put("SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT", 35);
        colors.put("SWT.COLOR_TITLE_INACTIVE_FOREGROUND", 33);
        colors.put("SWT.COLOR_WHITE", 1);
        colors.put("SWT.COLOR_WIDGET_BACKGROUND", 22);
        colors.put("SWT.COLOR_WIDGET_BORDER", 23);
        colors.put("SWT.COLOR_WIDGET_DARK_SHADOW", 17);
        colors.put("SWT.COLOR_WIDGET_FOREGROUND", 21);
        colors.put("SWT.COLOR_WIDGET_HIGHLIGHT_SHADOW", 20);
        colors.put("SWT.COLOR_WIDGET_LIGHT_SHADOW", 19);
        colors.put("SWT.COLOR_WIDGET_NORMAL_SHADOW", 18);
        colors.put("SWT.COLOR_YELLOW", 7);
        events.put("swt.activate", 26);
        events.put("swt.arm", 30);
        events.put("swt.close", 21);
        events.put("swt.collapse", 18);
        events.put("swt.deactivate", 27);
        events.put("swt.defaultselection", 14);
        XWTMaps.tryPut(events, "swt.deiconify", "SWT.Deiconify");
        events.put("swt.dispose", 12);
        events.put("swt.dragdetect", 29);
        XWTMaps.tryPut(events, "swt.eraseitem", "SWT.EraseItem");
        events.put("swt.expand", 17);
        events.put("swt.focusin", 15);
        events.put("swt.focusout", 16);
        XWTMaps.tryPut(events, "swt.hardkeydown", "SWT.HardKeyDown");
        XWTMaps.tryPut(events, "swt.hardkeyup", "SWT.HardKeyUp");
        events.put("swt.help", 28);
        events.put("swt.hide", 23);
        XWTMaps.tryPut(events, "swt.iconify", "SWT.Iconify");
        events.put("swt.keydown", 1);
        events.put("swt.keyup", 2);
        XWTMaps.tryPut(events, "swt.measureitem", "SWT.MeasureItem");
        events.put("swt.menudetect", 35);
        events.put("swt.modify", 24);
        events.put("swt.mousedoubleclick", 8);
        events.put("swt.mousedown", 3);
        XWTMaps.tryPut(events, "swt.mouseenter", "SWT.MouseEnter");
        XWTMaps.tryPut(events, "swt.mouseexit", "SWT.MouseExit");
        XWTMaps.tryPut(events, "swt.mousehover", "SWT.MouseHover");
        XWTMaps.tryPut(events, "swt.mousemove", "SWT.MouseMove");
        events.put("swt.mouseup", 4);
        XWTMaps.tryPut(events, "swt.mousewheel", "SWT.MouseWheel");
        events.put("swt.move", 10);
        XWTMaps.tryPut(events, "swt.paint", "SWT.Paint");
        XWTMaps.tryPut(events, "swt.paintitem", "SWT.PaintItem");
        events.put("swt.resize", 11);
        events.put("swt.selection", 13);
        events.put("swt.setdata", 36);
        XWTMaps.tryPut(events, "swt.settings", "SWT.Settings");
        events.put("swt.show", 22);
        events.put("swt.traverse", 31);
        events.put("swt.verify", 25);
        XWTMaps.tryPut(events, "swt.imecomposition", "SWT.ImeComposition");
        accelerators.put("SWT.ALT", 65536);
        accelerators.put("SWT.ARROW_UP", 0x1000001);
        accelerators.put("SWT.ARROW_DOWN", 0x1000002);
        accelerators.put("SWT.ARROW_LEFT", 0x1000003);
        accelerators.put("SWT.ARROW_RIGHT", 0x1000004);
        accelerators.put("SWT.BREAK", 16777302);
        accelerators.put("SWT.CAPS_LOCK", 16777298);
        accelerators.put("SWT.CENTER", 0x1000000);
        accelerators.put("SWT.CTRL", 262144);
        accelerators.put("SWT.DEFAULT", -1);
        XWTMaps.tryPut(accelerators, "SWT.EMBEDDED");
        accelerators.put("SWT.END", 0x1000008);
        accelerators.put("SWT.F1", 0x100000A);
        accelerators.put("SWT.F2", 0x100000B);
        accelerators.put("SWT.F3", 0x100000C);
        accelerators.put("SWT.F4", 0x100000D);
        accelerators.put("SWT.F5", 0x100000E);
        accelerators.put("SWT.F6", 0x100000F);
        accelerators.put("SWT.F7", 0x1000010);
        accelerators.put("SWT.F8", 0x1000011);
        accelerators.put("SWT.F9", 0x1000012);
        accelerators.put("SWT.F10", 0x1000013);
        accelerators.put("SWT.F11", 0x1000014);
        accelerators.put("SWT.F12", 0x1000015);
        accelerators.put("SWT.HELP", 0x1000051);
        accelerators.put("SWT.HOME", 0x1000007);
        accelerators.put("SWT.IMAGE_UNDEFINED", -1);
        accelerators.put("SWT.INSERT", 0x1000009);
        accelerators.put("SWT.KEYPAD_ADD", 16777259);
        accelerators.put("SWT.KEYPAD_CR", 0x1000050);
        accelerators.put("SWT.KEYPAD_DECIMAL", 16777262);
        accelerators.put("SWT.KEYPAD_DIVIDE", 16777263);
        accelerators.put("SWT.KEYPAD_EQUAL", 16777277);
        accelerators.put("SWT.KEYPAD_MULTIPLY", 16777258);
        accelerators.put("SWT.KEYPAD_SUBTRACT", 16777261);
        accelerators.put("SWT.KEYPAD_0", 0x1000030);
        accelerators.put("SWT.KEYPAD_1", 0x1000031);
        accelerators.put("SWT.KEYPAD_2", 16777266);
        accelerators.put("SWT.KEYPAD_3", 0x1000033);
        accelerators.put("SWT.KEYPAD_4", 16777268);
        accelerators.put("SWT.KEYPAD_5", 16777269);
        accelerators.put("SWT.KEYPAD_6", 16777270);
        accelerators.put("SWT.KEYPAD_7", 16777271);
        accelerators.put("SWT.KEYPAD_8", 16777272);
        accelerators.put("SWT.KEYPAD_9", 16777273);
        accelerators.put("SWT.NUM_LOCK", 16777299);
        accelerators.put("SWT.PAUSE", 0x1000055);
        accelerators.put("SWT.PAGE_DOWN", 0x1000006);
        accelerators.put("SWT.PAGE_UP", 0x1000005);
        accelerators.put("SWT.PRINT_SCREEN", 16777303);
        accelerators.put("SWT.SCROLL_LOCK", 16777300);
        accelerators.put("SWT.SHIFT", 131072);
    }

    public static Collection<String> getStyleKeys() {
        XWTMaps.checkAndInit();
        return styles.keySet();
    }

    public static int getStyle(String key) {
        Integer style;
        if (key == null) {
            return 0;
        }
        XWTMaps.checkAndInit();
        Object mapKey = key.toUpperCase();
        if (!((String)mapKey).startsWith("SWT.")) {
            mapKey = "SWT." + (String)mapKey;
        }
        return (style = styles.get(mapKey)) == null ? 0 : style;
    }

    public static Collection<String> getColorKeys() {
        XWTMaps.checkAndInit();
        return colors.keySet();
    }

    public static int getColor(String key) {
        Integer color;
        if (key == null || key.equals("")) {
            return 0;
        }
        XWTMaps.checkAndInit();
        Object mapKey = key.toUpperCase();
        if (!((String)mapKey).startsWith("SWT.")) {
            mapKey = "SWT." + (String)mapKey;
        }
        return (color = colors.get(mapKey)) == null ? 0 : color;
    }

    public static Collection<String> getEventKeys() {
        XWTMaps.checkAndInit();
        return events.keySet();
    }

    public static int getEvent(String key) {
        Integer event;
        if (key == null || key.equals("")) {
            return 0;
        }
        XWTMaps.checkAndInit();
        Object mapKey = key.toLowerCase();
        if (!((String)mapKey).startsWith("swt.")) {
            mapKey = "swt." + (String)mapKey;
        }
        return (event = events.get(mapKey)) == null ? 0 : event;
    }

    public static Collection<String> getAcceleratorKeys() {
        XWTMaps.checkAndInit();
        return accelerators.keySet();
    }

    public static int getAccelerator(String key) {
        Integer accelerator;
        char letter;
        if (key == null || key.equals("")) {
            return 0;
        }
        XWTMaps.checkAndInit();
        if (key.equals("BS")) {
            Integer accelerator2 = 8;
            return accelerator2 == null ? 0 : accelerator2;
        }
        if (key.equals("ENTER")) {
            Integer accelerator3 = 13;
            return accelerator3 == null ? 0 : accelerator3;
        }
        if (key.equals("DEL")) {
            Integer accelerator4 = 127;
            return accelerator4 == null ? 0 : accelerator4;
        }
        if (key.equals("SPACE")) {
            Integer accelerator5 = 32;
            return accelerator5 == null ? 0 : accelerator5;
        }
        if (key.length() == 1 && ((letter = key.charAt(0)) >= 'A' && letter <= 'Z' || letter >= 'a' && letter <= 'z')) {
            Integer accelerator6 = letter;
            return accelerator6 == null ? 0 : accelerator6;
        }
        Object mapKey = key.toUpperCase();
        if (!((String)mapKey).startsWith("SWT.")) {
            mapKey = "SWT." + (String)mapKey;
        }
        return (accelerator = accelerators.get(mapKey)) == null ? 0 : accelerator;
    }

    public static int getValue(String key) {
        int value = XWTMaps.getStyle(key);
        if (value == 0) {
            value = XWTMaps.getColor(key);
        }
        if (value == 0) {
            value = XWTMaps.getEvent(key);
        }
        if (value == 0) {
            value = XWTMaps.getAccelerator(key);
        }
        return value;
    }

    public static String getCombAccelerator(String content) {
        if (content.equals("Alt0")) {
            return "SWT.ALT | SWT.KEYPAD_0";
        }
        if (content.equals("Alt1")) {
            return "SWT.ALT | SWT.KEYPAD_1";
        }
        if (content.equals("Alt2")) {
            return "SWT.ALT | SWT.KEYPAD_2";
        }
        if (content.equals("Alt3")) {
            return "SWT.ALT | SWT.KEYPAD_3";
        }
        if (content.equals("Alt4")) {
            return "SWT.ALT | SWT.KEYPAD_4";
        }
        if (content.equals("Alt5")) {
            return "SWT.ALT | SWT.KEYPAD_5";
        }
        if (content.equals("Alt6")) {
            return "SWT.ALT | SWT.KEYPAD_6";
        }
        if (content.equals("Alt7")) {
            return "SWT.ALT | SWT.KEYPAD_7";
        }
        if (content.equals("Alt8")) {
            return "SWT.ALT | SWT.KEYPAD_8";
        }
        if (content.equals("Alt9")) {
            return "SWT.ALT | SWT.KEYPAD_9";
        }
        if (content.equals("AltBksp")) {
            return "SWT.ALT | BS";
        }
        if (content.equals("AltDownArrow")) {
            return "SWT.ALT | SWT.ARROW_DOWN";
        }
        if (content.equals("AltF1")) {
            return "SWT.ALT | SWT.F1";
        }
        if (content.equals("AltF10")) {
            return "SWT.ALT | SWT.F10";
        }
        if (content.equals("AltF11")) {
            return "SWT.ALT | SWT.F11";
        }
        if (content.equals("AltF12")) {
            return "SWT.ALT | SWT.F12";
        }
        if (content.equals("AltF2")) {
            return "SWT.ALT | SWT.F2";
        }
        if (content.equals("AltF3")) {
            return "SWT.ALT | SWT.F3";
        }
        if (content.equals("AltF4")) {
            return "SWT.ALT | SWT.F4";
        }
        if (content.equals("AltF5")) {
            return "SWT.ALT | SWT.F5";
        }
        if (content.equals("AltF6")) {
            return "SWT.ALT | SWT.F6";
        }
        if (content.equals("AltF7")) {
            return "SWT.ALT | SWT.F7";
        }
        if (content.equals("AltF8")) {
            return "SWT.ALT | SWT.F8";
        }
        if (content.equals("AltF9")) {
            return "SWT.ALT | SWT.F9";
        }
        if (content.equals("AltLeftArrow")) {
            return "SWT.ALT | SWT.ARROW_LEFT";
        }
        if (content.equals("AltRightArrow")) {
            return "SWT.ALT | SWT.ARROW_RIGHT";
        }
        if (content.equals("AltUpArrow")) {
            return "SWT.ALT | SWT.ARROW_UP";
        }
        if (content.equals("AltEnter")) {
            return "SWT.ALT | Enter";
        }
        if (content.equals("AltSpace")) {
            return "SWT.ALT | Space";
        }
        if (content.equals("Ctrl0")) {
            return "SWT.CTRL | SWT.KEYPAD_0";
        }
        if (content.equals("Ctrl1")) {
            return "SWT.CTRL | SWT.KEYPAD_1";
        }
        if (content.equals("Ctrl2")) {
            return "SWT.CTRL | SWT.KEYPAD_2";
        }
        if (content.equals("Ctrl3")) {
            return "SWT.CTRL | SWT.KEYPAD_3";
        }
        if (content.equals("Ctrl4")) {
            return "SWT.CTRL | SWT.KEYPAD_4";
        }
        if (content.equals("Ctrl5")) {
            return "SWT.CTRL | SWT.KEYPAD_5";
        }
        if (content.equals("Ctrl6")) {
            return "SWT.CTRL | SWT.KEYPAD_6";
        }
        if (content.equals("Ctrl7")) {
            return "SWT.CTRL | SWT.KEYPAD_7";
        }
        if (content.equals("Ctrl8")) {
            return "SWT.CTRL | SWT.KEYPAD_8";
        }
        if (content.equals("Ctrl9")) {
            return "SWT.CTRL | SWT.KEYPAD_9";
        }
        if (content.equals("CtrlA")) {
            return "SWT.CTRL | A";
        }
        if (content.equals("CtrlB")) {
            return "SWT.CTRL | B";
        }
        if (content.equals("CtrlC")) {
            return "SWT.CTRL | C";
        }
        if (content.equals("CtrlD")) {
            return "SWT.CTRL | D";
        }
        if (content.equals("CtrlDel")) {
            return "SWT.CTRL | DEL";
        }
        if (content.equals("CtrlEnter")) {
            return "SWT.CTRL | Enter";
        }
        if (content.equals("CtrlSpace")) {
            return "SWT.CTRL | Space";
        }
        if (content.equals("CtrlE")) {
            return "SWT.CTRL | E";
        }
        if (content.equals("CtrlF")) {
            return "SWT.CTRL | F";
        }
        if (content.equals("CtrlF1")) {
            return "SWT.CTRL | SWT.F1";
        }
        if (content.equals("CtrlF10")) {
            return "SWT.CTRL | SWT.F10";
        }
        if (content.equals("CtrlF11")) {
            return "SWT.CTRL | SWT.F11";
        }
        if (content.equals("CtrlF12")) {
            return "SWT.CTRL | SWT.F12";
        }
        if (content.equals("CtrlF2")) {
            return "SWT.CTRL | SWT.F2";
        }
        if (content.equals("CtrlF3")) {
            return "SWT.CTRL | SWT.F3";
        }
        if (content.equals("CtrlF4")) {
            return "SWT.CTRL | SWT.F4";
        }
        if (content.equals("CtrlF5")) {
            return "SWT.CTRL | SWT.F5";
        }
        if (content.equals("CtrlF6")) {
            return "SWT.CTRL | SWT.F6";
        }
        if (content.equals("CtrlF7")) {
            return "SWT.CTRL | SWT.F7";
        }
        if (content.equals("CtrlF8")) {
            return "SWT.CTRL | SWT.F8";
        }
        if (content.equals("CtrlF9")) {
            return "SWT.CTRL | SWT.F9";
        }
        if (content.equals("CtrlG")) {
            return "SWT.CTRL | G";
        }
        if (content.equals("CtrlH")) {
            return "SWT.CTRL | H";
        }
        if (content.equals("CtrlI")) {
            return "SWT.CTRL | I";
        }
        if (content.equals("CtrlIns")) {
            return "SWT.CTRL | SWT.INSERT";
        }
        if (content.equals("CtrlJ")) {
            return "SWT.CTRL | J";
        }
        if (content.equals("CtrlK")) {
            return "SWT.CTRL | K";
        }
        if (content.equals("CtrlL")) {
            return "SWT.CTRL | L";
        }
        if (content.equals("CtrlM")) {
            return "SWT.CTRL | M";
        }
        if (content.equals("CtrlN")) {
            return "SWT.CTRL | N";
        }
        if (content.equals("CtrlO")) {
            return "SWT.CTRL | O";
        }
        if (content.equals("CtrlP")) {
            return "SWT.CTRL | P";
        }
        if (content.equals("CtrlQ")) {
            return "SWT.CTRL | Q";
        }
        if (content.equals("CtrlR")) {
            return "SWT.CTRL | R";
        }
        if (content.equals("CtrlS")) {
            return "SWT.CTRL | S";
        }
        if (content.equals("CtrlShift0")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_0";
        }
        if (content.equals("CtrlShift1")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_1";
        }
        if (content.equals("CtrlShift2")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_2";
        }
        if (content.equals("CtrlShift3")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_3";
        }
        if (content.equals("CtrlShift4")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_4";
        }
        if (content.equals("CtrlShift5")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_5";
        }
        if (content.equals("CtrlShift6")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_6";
        }
        if (content.equals("CtrlShift7")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_7";
        }
        if (content.equals("CtrlShift8")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_8";
        }
        if (content.equals("CtrlShift9")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_9";
        }
        if (content.equals("CtrlShiftA")) {
            return "SWT.CTRL | SWT.SHIFT | A";
        }
        if (content.equals("CtrlShiftB")) {
            return "SWT.CTRL | SWT.SHIFT | B";
        }
        if (content.equals("CtrlShiftC")) {
            return "SWT.CTRL | SWT.SHIFT | C";
        }
        if (content.equals("CtrlShiftD")) {
            return "SWT.CTRL | SWT.SHIFT | D";
        }
        if (content.equals("CtrlShiftE")) {
            return "SWT.CTRL | SWT.SHIFT | E";
        }
        if (content.equals("CtrlShiftF")) {
            return "SWT.CTRL | SWT.SHIFT | F";
        }
        if (content.equals("CtrlShiftF1")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F1";
        }
        if (content.equals("CtrlShiftF10")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F10";
        }
        if (content.equals("CtrlShiftF11")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F11";
        }
        if (content.equals("CtrlShiftF12")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F12";
        }
        if (content.equals("CtrlShiftF2")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F2";
        }
        if (content.equals("CtrlShiftF3")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F3";
        }
        if (content.equals("CtrlShiftF4")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F4";
        }
        if (content.equals("CtrlShiftF5")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F5";
        }
        if (content.equals("CtrlShiftF6")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F6";
        }
        if (content.equals("CtrlShiftF7")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F7";
        }
        if (content.equals("CtrlShiftF8")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F8";
        }
        if (content.equals("CtrlShiftF9")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F9";
        }
        if (content.equals("CtrlShiftH")) {
            return "SWT.CTRL | SWT.SHIFT | H";
        }
        if (content.equals("CtrlShiftI")) {
            return "SWT.CTRL | SWT.SHIFT | I";
        }
        if (content.equals("CtrlShiftJ")) {
            return "SWT.CTRL | SWT.SHIFT | J";
        }
        if (content.equals("CtrlShiftK")) {
            return "SWT.CTRL | SWT.SHIFT | K";
        }
        if (content.equals("CtrlShiftL")) {
            return "SWT.CTRL | SWT.SHIFT | L";
        }
        if (content.equals("CtrlShiftM")) {
            return "SWT.CTRL | SWT.SHIFT | M";
        }
        if (content.equals("CtrlShiftN")) {
            return "SWT.CTRL | SWT.SHIFT | N";
        }
        if (content.equals("CtrlShiftO")) {
            return "SWT.CTRL | SWT.SHIFT | O";
        }
        if (content.equals("CtrlShiftP")) {
            return "SWT.CTRL | SWT.SHIFT | P";
        }
        if (content.equals("CtrlShiftQ")) {
            return "SWT.CTRL | SWT.SHIFT | Q";
        }
        if (content.equals("CtrlShiftR")) {
            return "SWT.CTRL | SWT.SHIFT | R";
        }
        if (content.equals("CtrlShiftS")) {
            return "SWT.CTRL | SWT.SHIFT | S";
        }
        if (content.equals("CtrlShiftT")) {
            return "SWT.CTRL | SWT.SHIFT | T";
        }
        if (content.equals("CtrlShiftU")) {
            return "SWT.CTRL | SWT.SHIFT | U";
        }
        if (content.equals("CtrlShiftV")) {
            return "SWT.CTRL | SWT.SHIFT | V";
        }
        if (content.equals("CtrlShiftW")) {
            return "SWT.CTRL | SWT.SHIFT | W";
        }
        if (content.equals("CtrlShiftX")) {
            return "SWT.CTRL | SWT.SHIFT | X";
        }
        if (content.equals("CtrlShiftY")) {
            return "SWT.CTRL | SWT.SHIFT | Y";
        }
        if (content.equals("CtrlShiftZ")) {
            return "SWT.CTRL | SWT.SHIFT | Z";
        }
        if (content.equals("CtrlShiftEnter")) {
            return "SWT.CTRL | SWT.SHIFT | Enter";
        }
        if (content.equals("CtrlShiftSpace")) {
            return "SWT.CTRL | SWT.SHIFT | Space";
        }
        if (content.equals("CtrlT")) {
            return "SWT.CTRL | T";
        }
        if (content.equals("CtrlU")) {
            return "SWT.CTRL | U";
        }
        if (content.equals("CtrlV")) {
            return "SWT.CTRL | V";
        }
        if (content.equals("CtrlW")) {
            return "SWT.CTRL | W";
        }
        if (content.equals("CtrlX")) {
            return "SWT.CTRL | X";
        }
        if (content.equals("CtrlY")) {
            return "SWT.CTRL | Y";
        }
        if (content.equals("CtrlZ")) {
            return "SWT.CTRL | Z";
        }
        if (content.equals("ShiftDel")) {
            return "SWT.SHIFT | DEL";
        }
        if (content.equals("ShiftF1")) {
            return "SWT.SHIFT | SWT.F1";
        }
        if (content.equals("ShiftF10")) {
            return "SWT.SHIFT | SWT.F10";
        }
        if (content.equals("ShiftF11")) {
            return "SWT.SHIFT | SWT.F11";
        }
        if (content.equals("ShiftF12")) {
            return "SWT.SHIFT | SWT.F12";
        }
        if (content.equals("ShiftF3")) {
            return "SWT.SHIFT | SWT.F2";
        }
        if (content.equals("ShiftF3")) {
            return "SWT.SHIFT | SWT.F3";
        }
        if (content.equals("ShiftF4")) {
            return "SWT.SHIFT | SWT.F4";
        }
        if (content.equals("ShiftF5")) {
            return "SWT.SHIFT | SWT.F5";
        }
        if (content.equals("ShiftF6")) {
            return "SWT.SHIFT | SWT.F6";
        }
        if (content.equals("ShiftF7")) {
            return "SWT.SHIFT | SWT.F7";
        }
        if (content.equals("ShiftF8")) {
            return "SWT.SHIFT | SWT.F8";
        }
        if (content.equals("ShiftF9")) {
            return "SWT.SHIFT | SWT.F9";
        }
        if (content.equals("ShiftIns")) {
            return "SWT.SHIFT | SWT.INSERT";
        }
        if (content.equals("ShiftEnter")) {
            return "SWT.SHIFT | Enter";
        }
        if (content.equals("ShiftSpace")) {
            return "SWT.SHIFT | Space";
        }
        if (content.equals("Enter")) {
            return "Enter";
        }
        if (content.equals("Space")) {
            return "Space";
        }
        return content;
    }

    private static void tryPut(Map<String, Integer> map, String swtConst) {
        XWTMaps.tryPut(map, swtConst, swtConst);
    }

    private static void tryPut(Map<String, Integer> map, String mapKey, String swtConst) {
        try {
            map.put(mapKey, SWT.class.getField(swtConst.substring(swtConst.lastIndexOf(46) + 1, swtConst.length())).getInt(null));
        }
        catch (Exception e) {
            String message = "Failed to register SWT Constant " + swtConst + ". Excecption: " + e.getClass().getName() + " - " + e.getMessage();
            System.out.println(message);
        }
    }
}

