/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.core;

import java.util.HashMap;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.core.Condition;
import org.eclipse.xwt.core.SetterBase;
import org.eclipse.xwt.core.TriggerBase;
import org.eclipse.xwt.internal.core.ScopeManager;
import org.eclipse.xwt.internal.core.UpdateSourceTrigger;

public class MultiTrigger
extends TriggerBase {
    private Condition[] conditions = Condition.EMPTY_ARRAY;
    private SetterBase[] setters;

    public Condition[] getConditions() {
        return this.conditions;
    }

    public void setConditions(Condition[] conditions) {
        this.conditions = conditions;
    }

    public SetterBase[] getSetters() {
        return this.setters;
    }

    public void setSetters(SetterBase[] setters) {
        this.setters = setters;
    }

    @Override
    public void on(Object target) {
    }

    @Override
    public void prepare(Object target) {
        if (this.getConditions().length == 0) {
            return;
        }
        ValueChangeListener changeListener = new ValueChangeListener(target);
        Condition[] conditionArray = this.getConditions();
        int n = conditionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Condition condition = conditionArray[n2];
            String propertyName = condition.getProperty();
            String sourceName = condition.getSourceName();
            Object source = MultiTrigger.getElementByName(target, sourceName);
            if (source == null) {
                throw new XWTException("No element is found with the name = " + sourceName);
            }
            IObservableValue observableValue = ScopeManager.observeValue(source, source, propertyName, UpdateSourceTrigger.PropertyChanged);
            observableValue.addChangeListener((IChangeListener)changeListener);
            ++n2;
        }
    }

    class ValueChangeListener
    extends TriggerBase.AbstractChangeListener {
        public ValueChangeListener(Object element) {
            super(MultiTrigger.this, element);
        }

        public void handleChange(ChangeEvent event) {
            Object[] objectArray = MultiTrigger.this.getConditions();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Condition condition = objectArray[n2];
                if (!condition.evaluate(this.element)) {
                    this.restoreValues();
                    return;
                }
                ++n2;
            }
            if (this.oldvalues != null && !this.oldvalues.isEmpty()) {
                return;
            }
            objectArray = MultiTrigger.this.getSetters();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object setter = objectArray[n2];
                try {
                    Object oldValue = ((SetterBase)setter).applyTo(this.element, true);
                    if (this.oldvalues == null) {
                        this.oldvalues = new HashMap();
                    }
                    this.oldvalues.put(setter, oldValue);
                }
                catch (RuntimeException runtimeException) {}
                ++n2;
            }
        }
    }
}

