/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.spy.preferences.handler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.BundleDefaultsScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.pde.spy.preferences.model.PreferenceEntry;
import org.eclipse.pde.spy.preferences.model.PreferenceNodeEntry;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;

public class ShowAllPreferencesHandler {
    @Execute
    public void execute(Shell shell, IEventBroker eventBroker) {
        HashMap<String, PreferenceNodeEntry> preferenceEntries = new HashMap<String, PreferenceNodeEntry>();
        IEclipsePreferences bundleDefaultsScopePreferences = BundleDefaultsScope.INSTANCE.getNode("");
        IEclipsePreferences configurationScopePreferences = ConfigurationScope.INSTANCE.getNode("");
        IEclipsePreferences defaultScopePreferences = DefaultScope.INSTANCE.getNode("");
        IEclipsePreferences instanceScopePreferences = InstanceScope.INSTANCE.getNode("");
        try {
            bundleDefaultsScopePreferences.accept((IPreferenceNodeVisitor)new PrefereneGatherer(preferenceEntries));
            configurationScopePreferences.accept((IPreferenceNodeVisitor)new PrefereneGatherer(preferenceEntries));
            defaultScopePreferences.accept((IPreferenceNodeVisitor)new PrefereneGatherer(preferenceEntries));
            instanceScopePreferences.accept((IPreferenceNodeVisitor)new PrefereneGatherer(preferenceEntries));
        }
        catch (BackingStoreException e) {
            ErrorDialog.openError((Shell)shell, (String)"BackingStoreException", (String)e.getLocalizedMessage(), (IStatus)Status.error((String)e.getMessage()));
        }
        eventBroker.post("TOPIC_PREFERENCESPY/PREFERENCE/SHOW", preferenceEntries.values());
    }

    private class PrefereneGatherer
    implements IPreferenceNodeVisitor {
        private final Map<String, PreferenceNodeEntry> preferenceEntries;

        public PrefereneGatherer(Map<String, PreferenceNodeEntry> preferenceEntries) {
            this.preferenceEntries = preferenceEntries;
        }

        public boolean visit(IEclipsePreferences node) throws BackingStoreException {
            String[] keys = node.keys();
            if (keys.length <= 0) {
                return true;
            }
            PreferenceNodeEntry preferenceNodeEntry = this.preferenceEntries.get(node.absolutePath());
            if (preferenceNodeEntry == null) {
                preferenceNodeEntry = new PreferenceNodeEntry(node.absolutePath());
                this.preferenceEntries.put(node.absolutePath(), preferenceNodeEntry);
            }
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String value = node.get(key, "*default*");
                PreferenceEntry preferenceEntry = new PreferenceEntry(node.absolutePath(), key, value, value);
                preferenceNodeEntry.addChildren(preferenceEntry);
                ++n2;
            }
            return true;
        }
    }
}

