/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.parts;

import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineShape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.PapyrusLinkLabelDragPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.parsers.ParserUtil;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.BehaviorPropertyNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.figures.ActivityEdgeFigure;
import org.eclipse.papyrus.uml.diagram.activity.figures.WrappedLabel;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.editparts.AbstractLinkLabelEditPart;
import org.eclipse.papyrus.uml.diagram.common.editparts.ILabelRoleProvider;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.UMLTextSelectionEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CornerBentFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ObjectFlowSelectionEditPart
extends AbstractLinkLabelEditPart
implements ILabelRoleProvider {
    public static final String VISUAL_ID = "ObjectFlow_SelectionLabel";
    static final Color THIS_BACK;

    static {
        ObjectFlowSelectionEditPart.registerSnapBackPosition((String)UMLVisualIDRegistry.getType(VISUAL_ID), (Point)new Point(20, 40));
        THIS_BACK = new Color(null, 248, 249, 214);
    }

    public ObjectFlowSelectionEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new UMLTextSelectionEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new PapyrusLinkLabelDragPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new BehaviorPropertyNodeEditPolicy());
    }

    protected Image getLabelIcon() {
        return null;
    }

    public IParser getParser() {
        if (this.parser == null) {
            this.parser = ParserUtil.getParser((IElementType)UMLElementTypes.ObjectFlow_Edge, (EObject)this.getParserElement(), (EditPart)this, (String)VISUAL_ID);
        }
        return this.parser;
    }

    protected IFigure createFigure() {
        IFigure label = this.createFigurePrim();
        this.defaultText = this.getLabelTextHelper(label);
        return label;
    }

    protected IFigure createFigurePrim() {
        return new LinkAndCornerBentWithTextFigure();
    }

    public String getLabelRole() {
        return "Selection";
    }

    public String getIconPathRole() {
        return "";
    }

    public class LinkAndCornerBentWithTextFigure
    extends CornerBentFigure {
        private WrappedLabel fCornerBentContent;
        private PolylineShape fLinkToBehaviorProperty;

        public LinkAndCornerBentWithTextFigure() {
            this.setBackgroundColor(THIS_BACK);
            this.createContents();
        }

        public boolean containsPoint(int x, int y) {
            if (this.isVisible()) {
                return super.containsPoint(x, y);
            }
            return false;
        }

        private void createContents() {
            this.fCornerBentContent = new WrappedLabel();
            this.add((IFigure)this.fCornerBentContent);
            this.fLinkToBehaviorProperty = new PolylineShape();
            this.fLinkToBehaviorProperty.setLineWidth(1);
            this.fLinkToBehaviorProperty.setLineStyle(2);
            this.addFigureListener(new FigureListener(){

                public void figureMoved(IFigure source) {
                    LinkAndCornerBentWithTextFigure.this.refreshLinkToBehaviorProperty();
                }
            });
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.getLinkToBehaviorProperty().setVisible(visible);
        }

        private void refreshLinkToBehaviorProperty() {
            if (this.getLinkToBehaviorProperty().getParent() == null) {
                this.getParent().add((IFigure)this.getLinkToBehaviorProperty());
            }
            if (this.getParent() != null && this.getParent() instanceof ActivityEdgeFigure) {
                Point parentCenter = ObjectFlowSelectionEditPart.this.getReferencePoint();
                Rectangle currentBounds = this.getBounds();
                Point end = BehaviorPropertyNodeEditPolicy.getAppropriateBorderPoint(parentCenter, currentBounds);
                Rectangle linkBounds = new Rectangle(parentCenter, end);
                this.getLinkToBehaviorProperty().setStart(parentCenter.translate(linkBounds.getLocation().getNegated()));
                this.getLinkToBehaviorProperty().setEnd(end.translate(linkBounds.getLocation().getNegated()));
                this.getLinkToBehaviorProperty().setBounds(linkBounds);
            }
        }

        public WrappedLabel getCornerBentContent() {
            return this.fCornerBentContent;
        }

        public PolylineShape getLinkToBehaviorProperty() {
            return this.fLinkToBehaviorProperty;
        }
    }
}

