/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.provisional.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.core.credentials.UserPasswordCredentials;

public class GitRepositoryInfo {
    private final String cloneUri;
    private UserPasswordCredentials credentials;
    private boolean shouldSaveCredentialsInSecureStore;
    private String repositoryName;
    private final List<String> fetchRefSpecs = new ArrayList<String>();
    private List<PushInfo> pushInfos = new ArrayList<PushInfo>();
    private final List<RepositoryConfigProperty> repositoryConfigProperties = new ArrayList<RepositoryConfigProperty>();

    public GitRepositoryInfo(String cloneUri) {
        this.cloneUri = cloneUri;
    }

    public String getCloneUri() {
        return this.cloneUri;
    }

    public void setCredentials(String user, String password) {
        this.credentials = new UserPasswordCredentials(user, password);
    }

    public UserPasswordCredentials getCredentials() {
        return this.credentials;
    }

    public void setShouldSaveCredentialsInSecureStore(boolean shouldSaveCredentialsInSecureStore) {
        this.shouldSaveCredentialsInSecureStore = shouldSaveCredentialsInSecureStore;
    }

    public boolean shouldSaveCredentialsInSecureStore() {
        return this.shouldSaveCredentialsInSecureStore;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void addFetchRefSpec(String fetchRefSpec) {
        this.fetchRefSpecs.add(fetchRefSpec);
    }

    public List<String> getFetchRefSpecs() {
        return this.fetchRefSpecs;
    }

    public void addPushInfo(String pushRefSpec, String pushUri) {
        this.pushInfos.add(new PushInfo(pushRefSpec, pushUri));
    }

    public List<PushInfo> getPushInfos() {
        return this.pushInfos;
    }

    public void addRepositoryConfigProperty(String section, String subsection, String name, String value) {
        this.repositoryConfigProperties.add(new RepositoryConfigProperty(section, subsection, name, value));
    }

    public List<RepositoryConfigProperty> getRepositoryConfigProperties() {
        return this.repositoryConfigProperties;
    }

    public static class PushInfo {
        private String pushRefSpec;
        private String pushUri;

        public PushInfo(String pushRefSpec, String pushUri) {
            this.pushRefSpec = pushRefSpec;
            this.pushUri = pushUri;
        }

        public String getPushRefSpec() {
            return this.pushRefSpec;
        }

        public String getPushUri() {
            return this.pushUri;
        }
    }

    public static class RepositoryConfigProperty {
        private String section;
        private String subsection;
        private String name;
        private String value;

        public RepositoryConfigProperty(String section, String subsection, String name, String value) {
            this.section = section;
            this.subsection = subsection;
            this.name = name;
            this.value = value;
        }

        public String getSection() {
            return this.section;
        }

        public String getSubsection() {
            return this.subsection;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

