--/**
-- * <copyright>
-- *
-- * Copyright (c) 2008 Eclipse.org and others.
-- * All rights reserved.   This program and the accompanying materials
-- * are made available under the terms of the Eclipse Public License v1.0
-- * which accompanies this distribution, and is available at
-- * http://www.eclipse.org/legal/epl-v10.html
-- *
-- * Contributors:
-- *   E.D. Willink - Initial API and implementation
-- *
-- * </copyright>
-- *
-- * $Id: OCLParserErrors.g,v 1.1 2009/01/13 20:31:30 cdamus Exp $
-- */
--
-- Additional ERROR_TOKEN rules for The OCL Parser
--

$Include
	OCLParser.g
$End

$Include
	EssentialOCLErrors.g
$End

$Rules

	classifierContextDeclCS ::= context pathNameCS ERROR_TOKEN
		/.$BeginJava
					reportErrorTokenMessage($getToken(3), OCLParserErrors.MISSING_INV_OR_DEF);
					CSTNode result = createClassifierContextDeclCS(
							(PathNameCS)$getSym(2),
							new BasicEList<InvOrDefCS>()
						);
					setOffsets(result, getIToken($getToken(1)), getIToken($getToken(3)));
					$setResult(result);
		  $EndJava
		./
		
	defExpressionCS ::= typedVariableCS ERROR_TOKEN
		/.$BeginJava
					reportErrorTokenMessage($getToken(2), OCLParserErrors.MISSING_EQUALS);
					VariableCS variableCS = (VariableCS)$getSym(1);
					CSTNode result = createDefExpressionCS(
							variableCS,
							null,
							null
						);
					setOffsets(result, variableCS, getIToken($getToken(2)));
					$setResult(result);
		  $EndJava
		./
	defExpressionCS ::= IDENTIFIER ERROR_Colon
		/.$BeginJava
					VariableCS variableCS = createVariableCS(
								getTokenText($getToken(1)),
								null,
								null
							);
					setOffsets(variableCS, getIToken($getToken(1)), getIToken($getToken(2)));
					CSTNode result = createDefExpressionCS(
							variableCS,
							null,
							null
						);
					setOffsets(result, variableCS, getIToken($getToken(2)));
					$setResult(result);
		  $EndJava
		./

	initOrDerValueCS ::= initOrDerValueCSopt init ERROR_Colon
		/.$BeginJava
					CSTNode result = createInitValueCS(
							(InitOrDerValueCS)$getSym(1),
							null
						);
					if ($getSym(1) != null) {
						setOffsets(result, (CSTNode)$getSym(1), getIToken($getToken(3)));
					} else {
						setOffsets(result, getIToken($getToken(2)), getIToken($getToken(3)));
					}
					$setResult(result);
		  $EndJava
		./
	initOrDerValueCS ::= initOrDerValueCSopt derive ERROR_Colon
		/.$BeginJava
					CSTNode result = createDerValueCS(
							(InitOrDerValueCS)$getSym(1),
							null
						);
					if ($getSym(1) != null) {
						setOffsets(result, (CSTNode)$getSym(1), getIToken($getToken(3)));
					} else {
						setOffsets(result, getIToken($getToken(2)), getIToken($getToken(3)));
					}
					$setResult(result);
		  $EndJava
		./
		
	invOrDefCS ::= inv simpleNameCS ERROR_Colon
		/.$BeginJava
					CSTNode result = createInvCS(
							(SimpleNameCS)$getSym(2),
							null
						);
					setOffsets(result, getIToken($getToken(1)), getIToken($getToken(3)));
					$setResult(result);
		  $EndJava
		./	
	invOrDefCS ::= def simpleNameCS ERROR_Colon
		/.$BeginJava
					CSTNode result = createDefCS(
							(SimpleNameCS)$getSym(2),
							null
						);
					setOffsets(result, getIToken($getToken(1)), getIToken($getToken(3)));
					$setResult(result);
		  $EndJava
		./

	packageDeclarationCS ::= package pathNameCS contextDeclCSmopt ERROR_Empty endpackage
		/.$BeginJava
					CSTNode result = createPackageDeclarationCS(
							(PathNameCS)$getSym(2),
							(EList)$getSym(3)
						);
					setOffsets(result, getIToken($getToken(1)), getIToken($getToken(5)));
					$setResult(result);
		  $EndJava
		./
	packageDeclarationCS ::= package pathNameCS contextDeclCSmopt ERROR_TOKEN
		/.$BeginJava
					reportErrorTokenMessage($getToken(4), OCLParserErrors.MISSING_ENDPACKAGE);
					CSTNode result = createPackageDeclarationCS(
							(PathNameCS)$getSym(2),
							(EList)$getSym(3)
						);
					setOffsets(result, getIToken($getToken(1)), getIToken($getToken(4)));
					$setResult(result);
		  $EndJava
		./
	packageDeclarationCS ::= package ERROR_PathNameCS
		/.$BeginJava
					CSTNode result = createPackageDeclarationCS(
							(PathNameCS)$getSym(2),
							new BasicEList()
						);
					setOffsets(result, getIToken($getToken(1)), getIToken($getToken(2)));
					$setResult(result);
		  $EndJava
		./
		
	prePostOrBodyDeclCS ::= pre simpleNameCS ERROR_Colon
		/.$BeginJava
					CSTNode result = createPrePostOrBodyDeclCS(
							PrePostOrBodyEnum.PRE_LITERAL,
							(SimpleNameCS)$getSym(2),
							createInvalidLiteralExpCS(getTokenText($getToken(3)))
						);
					setOffsets(result, getIToken($getToken(1)), getIToken($getToken(3)));
					$setResult(result);
		  $EndJava
		./
	prePostOrBodyDeclCS ::= post simpleNameCS ERROR_Colon
		/.$BeginJava
					CSTNode result = createPrePostOrBodyDeclCS(
							PrePostOrBodyEnum.POST_LITERAL,
							(SimpleNameCS)$getSym(2),
							createInvalidLiteralExpCS(getTokenText($getToken(3)))
						);
					setOffsets(result, getIToken($getToken(1)), getIToken($getToken(3)));
					$setResult(result);
		  $EndJava
		./
	prePostOrBodyDeclCS ::= body simpleNameCS ERROR_Colon
		/.$BeginJava
					CSTNode result = createPrePostOrBodyDeclCS(
							PrePostOrBodyEnum.BODY_LITERAL,
							(SimpleNameCS)$getSym(2),
							createInvalidLiteralExpCS(getTokenText($getToken(3)))
						);
					setOffsets(result, getIToken($getToken(1)), getIToken($getToken(3)));
					$setResult(result);
		  $EndJava
		./
		
	propertyContextCS ::= context pathNameCS '::' ERROR_SimpleNameCS
		/.$BeginJava
					SimpleNameCS simpleNameCS = (SimpleNameCS)$getSym(4);
					CSTNode result = createPropertyContextCS(
							(PathNameCS)$getSym(2),
							simpleNameCS,
							null,
							null
						);
					setOffsets(result, getIToken($getToken(1)), simpleNameCS);
					$setResult(result);
		  $EndJava
		./
		
$End
