/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.draw2d.decoration;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.uml2.diagram.common.draw2d.decoration.ComposablePolygonDecoration;
import org.eclipse.uml2.diagram.common.draw2d.decoration.CompositeDecoration;
import org.eclipse.uml2.diagram.common.draw2d.decoration.DotDecoration;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Property;

public class AssociationDecoration
extends CompositeDecoration {
    private static final PointList RHOMB;
    private static final PointList ARROW;
    private static final PointList CROSS;
    private ComposablePolygonDecoration myCompositeAggrecationDecoration;
    private ComposablePolygonDecoration mySharedAggrecationDecoration;
    private ComposablePolygonDecoration myNavigableDecoration;
    private ComposablePolygonDecoration myNonNavigableDecoration;
    private DotDecoration myOwnedEndDecoration;

    static {
        int[] nArray = new int[10];
        nArray[0] = -1;
        nArray[1] = 1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -2;
        nArray[8] = -1;
        nArray[9] = 1;
        RHOMB = new PointList(nArray);
        int[] nArray2 = new int[10];
        nArray2[0] = -1;
        nArray2[1] = 1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[8] = -1;
        nArray2[9] = 1;
        ARROW = new PointList(nArray2);
        int[] nArray3 = new int[18];
        nArray3[0] = -1;
        nArray3[2] = -2;
        nArray3[3] = -1;
        nArray3[4] = -1;
        nArray3[6] = -2;
        nArray3[7] = 1;
        nArray3[8] = -1;
        nArray3[11] = 1;
        nArray3[12] = -1;
        nArray3[15] = -1;
        nArray3[16] = -1;
        CROSS = new PointList(nArray3);
    }

    public AssociationDecoration() {
        this.initAggregationDecorations();
        this.initNavigabilityDecorations();
        this.initOwnedEndDecorations();
    }

    private void initAggregationDecorations() {
        this.myCompositeAggrecationDecoration = new ComposablePolygonDecoration();
        this.myCompositeAggrecationDecoration.setTemplate(RHOMB.getCopy());
        this.myCompositeAggrecationDecoration.setBoundPoint(new Point(-2, 0));
        this.myCompositeAggrecationDecoration.setFill(true);
        if (this.getParent() != null && this.getParent().getForegroundColor() != null) {
            this.myCompositeAggrecationDecoration.setBackgroundColor(this.getParent().getForegroundColor());
        }
        this.mySharedAggrecationDecoration = new ComposablePolygonDecoration();
        this.mySharedAggrecationDecoration.setTemplate(RHOMB.getCopy());
        this.mySharedAggrecationDecoration.setBoundPoint(new Point(-2, 0));
        this.mySharedAggrecationDecoration.setFill(true);
        this.mySharedAggrecationDecoration.setBackgroundColor(ColorConstants.white);
    }

    private void initNavigabilityDecorations() {
        this.myNavigableDecoration = new ComposablePolygonDecoration();
        this.myNavigableDecoration.setTemplate(ARROW.getCopy());
        this.myNavigableDecoration.setBoundPoint(new Point(-1, 0));
        this.myNonNavigableDecoration = new ComposablePolygonDecoration();
        this.myNonNavigableDecoration.setScale(4.0, 3.0);
        this.myNonNavigableDecoration.setTemplate(CROSS.getCopy());
        this.myNonNavigableDecoration.setBoundPoint(new Point(-2, 0));
    }

    private void initOwnedEndDecorations() {
        this.myOwnedEndDecoration = new DotDecoration();
        this.myOwnedEndDecoration.setRadius(1);
        this.myOwnedEndDecoration.setFill(true);
    }

    public void updateAggregationKind(AggregationKind kind) {
        if (kind == AggregationKind.COMPOSITE_LITERAL) {
            this.addDecoration(this.myCompositeAggrecationDecoration);
            this.removeDecoration(this.mySharedAggrecationDecoration);
        } else if (kind == AggregationKind.SHARED_LITERAL) {
            this.addDecoration(this.mySharedAggrecationDecoration);
            this.removeDecoration(this.myCompositeAggrecationDecoration);
        } else {
            this.removeDecoration(this.mySharedAggrecationDecoration);
            this.removeDecoration(this.myCompositeAggrecationDecoration);
        }
    }

    public void updateNavigability(Property associationEnd, Property otherEnd, IPreferenceStore store) {
        String navigability = store.getString("org.eclipse.uml2.diagram.clazz.preferences.navigationP_arrows_options");
        if ("org.eclipse.uml2.diagram.clazz.preferences.show_all_arrows_and_xs".equals(navigability)) {
            if (!associationEnd.isNavigable()) {
                this.removeDecoration(this.myNavigableDecoration);
                this.addDecoration(this.myNonNavigableDecoration);
            } else {
                this.removeDecoration(this.myNonNavigableDecoration);
                this.addDecoration(this.myNavigableDecoration);
            }
            return;
        }
        if ("org.eclipse.uml2.diagram.clazz.preferences.supress_all_arrows_and_xs".equals(navigability)) {
            this.removeDecoration(this.myNavigableDecoration);
            this.removeDecoration(this.myNonNavigableDecoration);
            return;
        }
        if (associationEnd.isNavigable() && !otherEnd.isNavigable()) {
            this.addDecoration(this.myNavigableDecoration);
            this.removeDecoration(this.myNonNavigableDecoration);
            return;
        }
        if (!associationEnd.isNavigable() && otherEnd.isNavigable()) {
            this.addDecoration(this.myNonNavigableDecoration);
            this.removeDecoration(this.myNavigableDecoration);
            return;
        }
        this.removeDecoration(this.myNavigableDecoration);
        this.removeDecoration(this.myNonNavigableDecoration);
    }

    public void updateOwnedEnd(Association association, Property end) {
        if (association.getOwnedEnds().contains((Object)end)) {
            this.removeDecoration(this.myOwnedEndDecoration);
        } else {
            this.addDecoration(this.myOwnedEndDecoration);
        }
    }

    public void update(Association association, Property end, Property otherEnd, IPreferenceStore store) {
        this.updateOwnedEnd(association, end);
        this.updateAggregationKind(otherEnd.getAggregation());
        this.updateNavigability(end, otherEnd, store);
    }
}

