/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveViewCommand
extends AbstractTransactionalCommand {
    private final IAdaptable myParent;
    private final IAdaptable myChild;
    private final int myIndex;
    private final PreferencesHint myPreferences;
    private IVisualIDRegistry myVisualIDRegistry;

    public MoveViewCommand(TransactionalEditingDomain editingDomain, IAdaptable parent, IAdaptable child, PreferencesHint preferencesHint) {
        this(editingDomain, parent, child, -1, preferencesHint);
    }

    public MoveViewCommand(TransactionalEditingDomain editingDomain, IAdaptable parent, IAdaptable child, int index, PreferencesHint preferences) {
        super(editingDomain, "Move view", null);
        this.myParent = parent;
        this.myChild = child;
        this.myIndex = index;
        this.myPreferences = preferences;
    }

    public void setVisualIDRegistry(IVisualIDRegistry visualIDRegistry) {
        this.myVisualIDRegistry = visualIDRegistry;
    }

    public List<?> getAffectedFiles() {
        View view = (View)this.myParent.getAdapter(View.class);
        if (view != null) {
            ArrayList<IFile> result = new ArrayList<IFile>();
            IFile file = WorkspaceSynchronizer.getFile((Resource)view.eResource());
            if (file != null) {
                result.add(file);
            }
            return result;
        }
        return super.getAffectedFiles();
    }

    protected boolean checkCanMoveView(View parentView, View childView, EObject child) {
        if (this.myVisualIDRegistry == null) {
            return false;
        }
        int actualVisualId = this.myVisualIDRegistry.getVisualID(childView);
        return this.myVisualIDRegistry.checkNodeVisualID(parentView, child, actualVisualId);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View parentView = (View)this.myParent.getAdapter(View.class);
        View childView = (View)this.myChild.getAdapter(View.class);
        EObject child = childView.getElement();
        if (child instanceof Edge) {
            this.justMoveActualView(parentView, childView);
            return CommandResult.newOKCommandResult();
        }
        if (this.checkCanMoveView(parentView, childView, child)) {
            this.justMoveActualView(parentView, childView);
        } else {
            this.createNewView(parentView, childView, child);
        }
        return CommandResult.newOKCommandResult();
    }

    protected void importStyles(View newView, View childView) {
    }

    protected View basicCreateNewView(View parentView, EObject child) {
        EObjectAdapter semanticAdapter = new EObjectAdapter(child);
        View result = ViewService.getInstance().createView(Node.class, (IAdaptable)semanticAdapter, parentView, null, this.myIndex, true, this.myPreferences);
        return result;
    }

    protected View createNewView(View parentView, View oldChildView, EObject child) {
        View newView = this.basicCreateNewView(parentView, child);
        if (newView == null) {
            return null;
        }
        this.removeViewFromContainer(newView);
        this.justMoveActualView(parentView, oldChildView);
        oldChildView.getPersistedChildren().clear();
        oldChildView.getTransientChildren().clear();
        oldChildView.getSourceEdges().clear();
        oldChildView.getTargetEdges().clear();
        oldChildView.getStyles().clear();
        oldChildView.getStyles().addAll((Collection)newView.getStyles());
        oldChildView.getPersistedChildren().addAll((Collection)newView.getPersistedChildren());
        oldChildView.getTransientChildren().addAll((Collection)newView.getTransientChildren());
        oldChildView.getSourceEdges().addAll((Collection)newView.getSourceEdges());
        oldChildView.getTargetEdges().addAll((Collection)newView.getTargetEdges());
        oldChildView.setType(newView.getType());
        return oldChildView;
    }

    private void justMoveActualView(View parentView, View childView) {
        if (this.myIndex == -1) {
            parentView.insertChild(childView);
        } else {
            parentView.insertChildAt(childView, this.myIndex);
        }
    }

    private void removeViewFromContainer(View view) {
        if (view.eContainer() instanceof View) {
            ((View)view.eContainer()).removeChild(view);
        }
    }
}

