/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractCompilationUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxException;
import org.eclipse.m2m.internal.qvt.oml.blackbox.CompilationUnit;
import org.eclipse.m2m.internal.qvt.oml.blackbox.LoadContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlackboxRegistry {
    private static final String CLASS_ATTR = "class";
    private static final String PROVIDER_ELEMENT = "provider";
    private static final String BLACKBOX_PROVIDER_EXTENSION = "blackboxProvider";
    public static BlackboxRegistry INSTANCE = new BlackboxRegistry();
    private List<AbstractBlackboxProvider> fProviders;

    private BlackboxRegistry() {
        try {
            this.fProviders = BlackboxRegistry.readProviders();
        }
        catch (RuntimeException e) {
            this.fProviders = Collections.emptyList();
            QvtPlugin.log(e);
        }
    }

    public AbstractCompilationUnitDescriptor getCompilationUnitDescriptor(String qualifiedName, ResolutionContext context) {
        for (AbstractBlackboxProvider provider : this.fProviders) {
            AbstractCompilationUnitDescriptor descriptor = provider.getModuleDescriptor(qualifiedName, context);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public CompilationUnit loadCompilationUnit(AbstractCompilationUnitDescriptor descriptor, LoadContext loadContext) throws BlackboxException {
        if (descriptor == null) {
            throw new IllegalArgumentException("Null blackbox descriptor");
        }
        AbstractBlackboxProvider provider = descriptor.getProvider();
        return provider.loadCompilationUnit(descriptor, loadContext);
    }

    public List<AbstractCompilationUnitDescriptor> getCompilationUnitDescriptors(ResolutionContext loadContext) {
        ArrayList<AbstractCompilationUnitDescriptor> result = new ArrayList<AbstractCompilationUnitDescriptor>();
        for (AbstractBlackboxProvider provider : this.fProviders) {
            for (AbstractCompilationUnitDescriptor abstractCompilationUnitDescriptor : provider.getModuleDescriptors(loadContext)) {
                result.add(abstractCompilationUnitDescriptor);
            }
        }
        return result;
    }

    private static List<AbstractBlackboxProvider> readProviders() {
        IConfigurationElement[] configs;
        LinkedList<AbstractBlackboxProvider> providers = new LinkedList<AbstractBlackboxProvider>();
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.m2m.qvt.oml", BLACKBOX_PROVIDER_EXTENSION);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(PROVIDER_ELEMENT)) {
                try {
                    Object extension = element.createExecutableExtension(CLASS_ATTR);
                    if (!(extension instanceof AbstractBlackboxProvider)) {
                        QvtPlugin.log(QvtPlugin.createErrorStatus("Provider must implement AbstractBlackboxProvider interace:" + extension, null));
                    } else {
                        providers.add((AbstractBlackboxProvider)extension);
                    }
                }
                catch (CoreException e) {
                    QvtPlugin.log(e.getStatus());
                }
            }
            ++n2;
        }
        return providers;
    }
}

