/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ToolBarDrawData
extends DrawData {
    public ToolBarDrawData() {
        this.state = new int[1];
    }

    @Override
    void draw(Theme theme, GC gc, Rectangle bounds) {
        int toolbarHandle = theme.toolbarHandle;
        int gtkStyle = this.gtk_widget_get_style(toolbarHandle);
        int drawable = gc.getGCData().drawable;
        theme.transferClipping(gc, gtkStyle);
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        byte[] detail = Converter.wcsToMbcs(null, "toolbar", true);
        this.gtk_render_box(gtkStyle, drawable, this.getStateType(0), 0, null, toolbarHandle, detail, x, y, width, height);
        if (this.clientArea != null) {
            this.clientArea.x = bounds.x;
            this.clientArea.y = bounds.y;
            this.clientArea.width = bounds.width;
            this.clientArea.height = bounds.height;
        }
    }

    @Override
    int getStateType(int part) {
        return 0;
    }

    @Override
    int hit(Theme theme, Point position, Rectangle bounds) {
        return bounds.contains(position) ? 0 : -1;
    }
}

