/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.e4.css;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.extension.e4.css.NatTableWrapper;
import org.eclipse.nebula.widgets.nattable.extension.e4.css.NatTableWrapperElementAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NatTableElementAdapter
extends WidgetElement {
    private static boolean listenerApplied = false;
    List<Node> virtualChildren = new ArrayList<Node>();

    public NatTableElementAdapter(NatTable natTable, final CSSEngine engine) {
        super((Widget)natTable, engine);
        this.addStaticPseudoInstance("normal");
        this.addStaticPseudoInstance("select");
        this.addStaticPseudoInstance("edit");
        this.addStaticPseudoInstance("hover");
        this.addStaticPseudoInstance("select-hover");
        for (String label : natTable.getProvidedLabels()) {
            this.addVirtualChild(label);
        }
        if (!listenerApplied) {
            natTable.getDisplay().addListener(45, new Listener(){

                public void handleEvent(Event event) {
                    if (engine != null && event.widget instanceof NatTable) {
                        engine.applyStyles((Object)event.widget, true);
                    }
                }
            });
            listenerApplied = true;
        }
    }

    public Node getParentNode() {
        NatTable control = this.getControl();
        Composite parent = control.getParent();
        if (parent != null) {
            Element element = this.getElement(parent);
            return element;
        }
        return null;
    }

    protected NatTable getControl() {
        return (NatTable)this.getNativeWidget();
    }

    public NodeList getChildNodes() {
        return this;
    }

    public int getLength() {
        return this.virtualChildren.size();
    }

    public Node item(int index) {
        return this.virtualChildren.get(index);
    }

    public void addVirtualChild(String label) {
        this.virtualChildren.add((Node)((Object)new NatTableWrapperElementAdapter(new NatTableWrapper(this.getControl(), label), this.engine, this)));
    }
}

