/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.formula.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.formula.function.FunctionValue;
import org.eclipse.nebula.widgets.nattable.formula.function.SumFunction;

public class AverageFunction
extends SumFunction {
    public AverageFunction() {
    }

    public AverageFunction(List<FunctionValue> values) {
        super(values);
    }

    @Override
    public BigDecimal getValue() {
        BigDecimal sum = super.getValue();
        if (!this.values.isEmpty()) {
            try {
                return sum.divide(new BigDecimal(this.values.size()));
            }
            catch (ArithmeticException e) {
                if (e.getMessage().startsWith("Non-terminating")) {
                    return sum.divide(new BigDecimal(this.values.size()), 9, RoundingMode.HALF_UP);
                }
                throw e;
            }
        }
        return sum;
    }
}

