/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiRowReorderCommand;

public class GroupMultiRowReorderCommand
extends MultiRowReorderCommand {
    private GroupModel.Group groupToBottom;

    public GroupMultiRowReorderCommand(ILayer layer, List<Integer> fromRowPositions, int toRowPosition, GroupModel.Group groupToBottom) {
        this(layer, fromRowPositions, toRowPosition < layer.getRowCount() ? toRowPosition : toRowPosition - 1, toRowPosition < layer.getRowCount(), groupToBottom);
    }

    public GroupMultiRowReorderCommand(ILayer layer, List<Integer> fromRowPositions, int toRowPosition, boolean reorderToTopEdge, GroupModel.Group groupToBottom) {
        super(layer, fromRowPositions, toRowPosition, reorderToTopEdge);
        this.groupToBottom = groupToBottom;
    }

    protected GroupMultiRowReorderCommand(GroupMultiRowReorderCommand command) {
        super(command);
        this.groupToBottom = command.groupToBottom;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        if (super.convertToTargetLayer(targetLayer)) {
            if (this.groupToBottom != null) {
                int toTopPosition = this.toRowPositionCoordinate.rowPosition - 1;
                int toTopIndex = this.toRowPositionCoordinate.getLayer().getRowIndexByPosition(toTopPosition);
                while (this.groupToBottom.hasMember(toTopIndex)) {
                    --this.toRowPositionCoordinate.rowPosition;
                    toTopIndex = this.toRowPositionCoordinate.getLayer().getRowIndexByPosition(--toTopPosition);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public GroupMultiRowReorderCommand cloneCommand() {
        return new GroupMultiRowReorderCommand(this);
    }
}

