/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hierarchical.action;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.hierarchical.HierarchicalTreeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.reorder.action.ColumnReorderDragMode;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class HierarchicalTreeColumnReorderDragMode
extends ColumnReorderDragMode {
    private HierarchicalTreeLayer treeLayer;
    private Cursor currentCursor;
    protected ColumnGroupModel columnGroupModel;

    public HierarchicalTreeColumnReorderDragMode(HierarchicalTreeLayer treeLayer) {
        this(treeLayer, null);
    }

    public HierarchicalTreeColumnReorderDragMode(HierarchicalTreeLayer treeLayer, ColumnGroupModel model) {
        this.treeLayer = treeLayer;
        this.columnGroupModel = model;
        this.targetOverlayPainter = new HierarchicalColumnReorderOverlayPainter();
    }

    @Override
    public void mouseUp(NatTable natTable, MouseEvent event) {
        this.natTable.setCursor(null);
        super.mouseUp(natTable, event);
    }

    @Override
    protected void fireMoveEndCommand(NatTable natTable, int dragToGridColumnPosition) {
        int toIndex;
        if (dragToGridColumnPosition < natTable.getColumnCount() && (toIndex = natTable.getColumnIndexByPosition(dragToGridColumnPosition)) < 0 && this.dragFromGridColumnPosition < dragToGridColumnPosition) {
            ++dragToGridColumnPosition;
        }
        super.fireMoveEndCommand(natTable, dragToGridColumnPosition);
    }

    @Override
    protected boolean isValidTargetColumnPosition(ILayer natLayer, int dragFromGridColumnPosition, int dragToGridColumnPosition) {
        int fromIndex = natLayer.getColumnIndexByPosition(dragFromGridColumnPosition);
        int toIndex = natLayer.getColumnIndexByPosition(dragToGridColumnPosition);
        if (fromIndex < 0) {
            return false;
        }
        if (toIndex < 0 && dragFromGridColumnPosition < dragToGridColumnPosition) {
            toIndex = natLayer.getColumnIndexByPosition(dragToGridColumnPosition - 1);
        } else if (toIndex < 0 && dragFromGridColumnPosition > dragToGridColumnPosition) {
            return false;
        }
        int fromLevel = this.treeLayer.getLevelByColumnIndex(fromIndex);
        int toLevel = this.treeLayer.getLevelByColumnIndex(toIndex);
        if (fromLevel != toLevel && this.treeLayer.isShowTreeLevelHeader()) {
            return false;
        }
        if (fromLevel != toLevel && !this.treeLayer.isShowTreeLevelHeader() && fromLevel != (toLevel = this.treeLayer.getLevelByColumnIndex(toIndex - 1))) {
            return false;
        }
        if (this.columnGroupModel != null) {
            if (this.columnGroupModel.isPartOfAnUnbreakableGroup(fromIndex)) {
                return ColumnGroupUtils.isInTheSameGroup(fromIndex, toIndex, this.columnGroupModel);
            }
            boolean betweenTwoGroups = false;
            if (this.currentEvent != null) {
                int minX = this.currentEvent.x - 4;
                int maxX = this.currentEvent.x + 4;
                betweenTwoGroups = ColumnGroupUtils.isBetweenTwoGroups(natLayer, minX, maxX, this.columnGroupModel);
            }
            return !this.columnGroupModel.isPartOfAnUnbreakableGroup(toIndex) || betweenTwoGroups;
        }
        return super.isValidTargetColumnPosition(natLayer, dragFromGridColumnPosition, dragToGridColumnPosition);
    }

    private class HierarchicalColumnReorderOverlayPainter
    implements IOverlayPainter {
        private Cursor noOpsCursor;

        private HierarchicalColumnReorderOverlayPainter() {
        }

        @Override
        public void paintOverlay(GC gc, ILayer layer) {
            int dragFromGridColumnPosition = HierarchicalTreeColumnReorderDragMode.this.getDragFromGridColumnPosition();
            if (((HierarchicalTreeColumnReorderDragMode)HierarchicalTreeColumnReorderDragMode.this).currentEvent.x > HierarchicalTreeColumnReorderDragMode.this.natTable.getWidth()) {
                return;
            }
            CellEdgeEnum moveDirection = HierarchicalTreeColumnReorderDragMode.this.getMoveDirection(((HierarchicalTreeColumnReorderDragMode)HierarchicalTreeColumnReorderDragMode.this).currentEvent.x);
            int dragToGridColumnPosition = HierarchicalTreeColumnReorderDragMode.this.getDragToGridColumnPosition(moveDirection, HierarchicalTreeColumnReorderDragMode.this.natTable.getColumnPositionByX(((HierarchicalTreeColumnReorderDragMode)HierarchicalTreeColumnReorderDragMode.this).currentEvent.x));
            if (HierarchicalTreeColumnReorderDragMode.this.isValidTargetColumnPosition(HierarchicalTreeColumnReorderDragMode.this.natTable, dragFromGridColumnPosition, dragToGridColumnPosition)) {
                if (HierarchicalTreeColumnReorderDragMode.this.currentCursor != null) {
                    HierarchicalTreeColumnReorderDragMode.this.natTable.setCursor(null);
                    HierarchicalTreeColumnReorderDragMode.this.currentCursor = null;
                }
                int dragToColumnHandleX = -1;
                if (moveDirection != null) {
                    Rectangle selectedColumnHeaderRect = HierarchicalTreeColumnReorderDragMode.this.getColumnCell(((HierarchicalTreeColumnReorderDragMode)HierarchicalTreeColumnReorderDragMode.this).currentEvent.x).getBounds();
                    switch (moveDirection) {
                        case LEFT: {
                            dragToColumnHandleX = selectedColumnHeaderRect.x;
                            break;
                        }
                        case RIGHT: {
                            dragToColumnHandleX = selectedColumnHeaderRect.x + selectedColumnHeaderRect.width;
                            break;
                        }
                    }
                }
                if (dragToColumnHandleX > 0) {
                    Color orgBgColor = gc.getBackground();
                    gc.setBackground(GUIHelper.COLOR_DARK_GRAY);
                    gc.fillRectangle(dragToColumnHandleX - 1, 0, 2, layer.getHeight());
                    gc.setBackground(orgBgColor);
                }
            } else if (HierarchicalTreeColumnReorderDragMode.this.currentCursor == null) {
                if (this.noOpsCursor == null) {
                    this.noOpsCursor = new Cursor((Device)Display.getDefault(), 20);
                    HierarchicalTreeColumnReorderDragMode.this.natTable.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            HierarchicalColumnReorderOverlayPainter.this.noOpsCursor.dispose();
                        }
                    });
                }
                HierarchicalTreeColumnReorderDragMode.this.natTable.setCursor(this.noOpsCursor);
                HierarchicalTreeColumnReorderDragMode.this.currentCursor = this.noOpsCursor;
            }
        }
    }
}

