/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.IDisplayModeOrdering;

public class DefaultDisplayModeOrdering
implements IDisplayModeOrdering {
    private static final List<DisplayMode> NORMAL_ORDERING = Arrays.asList(DisplayMode.NORMAL);
    private static final List<DisplayMode> SELECT_ORDERING = Arrays.asList(DisplayMode.SELECT, DisplayMode.NORMAL);
    private static final List<DisplayMode> EDIT_ORDERING = Arrays.asList(DisplayMode.EDIT, DisplayMode.NORMAL);
    private static final List<DisplayMode> EMPTY_ORDERING = Collections.emptyList();
    private static final List<DisplayMode> HOVER_ORDERING = Arrays.asList(DisplayMode.HOVER, DisplayMode.NORMAL);
    private static final List<DisplayMode> SELECT_HOVER_ORDERING = Arrays.asList(DisplayMode.SELECT_HOVER, DisplayMode.SELECT, DisplayMode.HOVER, DisplayMode.NORMAL);

    @Override
    public List<DisplayMode> getDisplayModeOrdering(DisplayMode targetDisplayMode) {
        if (DisplayMode.NORMAL.equals((Object)targetDisplayMode)) {
            return NORMAL_ORDERING;
        }
        if (DisplayMode.SELECT.equals((Object)targetDisplayMode)) {
            return SELECT_ORDERING;
        }
        if (DisplayMode.EDIT.equals((Object)targetDisplayMode)) {
            return EDIT_ORDERING;
        }
        if (DisplayMode.HOVER.equals((Object)targetDisplayMode)) {
            return HOVER_ORDERING;
        }
        if (DisplayMode.SELECT_HOVER.equals((Object)targetDisplayMode)) {
            return SELECT_HOVER_ORDERING;
        }
        return EMPTY_ORDERING;
    }
}

