/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style.editor;

import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.editor.AbstractEditorPanel;
import org.eclipse.nebula.widgets.nattable.style.editor.ColorPicker;
import org.eclipse.nebula.widgets.nattable.style.editor.FontPicker;
import org.eclipse.nebula.widgets.nattable.style.editor.HorizontalAlignmentPicker;
import org.eclipse.nebula.widgets.nattable.style.editor.VerticalAlignmentPicker;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CellStyleEditorPanel
extends AbstractEditorPanel<Style> {
    private static final Color DEFAULT_FG_COLOR = GUIHelper.COLOR_BLACK;
    private static final Color DEFAULT_BG_COLOR = GUIHelper.COLOR_WHITE;
    private ColorPicker backgroundColorPicker;
    private ColorPicker foregroundColorPicker;
    private FontPicker fontPicker;
    private HorizontalAlignmentPicker horizontalAlignmentPicker;
    private VerticalAlignmentPicker verticalAlignmentPicker;
    private Color origBgColor;
    private Color origFgColor;
    private HorizontalAlignmentEnum origHAlign;
    private VerticalAlignmentEnum origVAlign;

    public CellStyleEditorPanel(Composite parent, int style) {
        super(parent, style);
        this.initComponents();
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 10;
        this.setLayout((Layout)gridLayout);
        new Label((Composite)this, 0).setText(Messages.getString("CellStyleEditorPanel.backgroundColor"));
        this.backgroundColorPicker = new ColorPicker(this, DEFAULT_BG_COLOR);
        new Label((Composite)this, 0).setText(Messages.getString("CellStyleEditorPanel.foregroundColor"));
        this.foregroundColorPicker = new ColorPicker(this, DEFAULT_FG_COLOR);
        new Label((Composite)this, 0).setText(Messages.getString("CellStyleEditorPanel.font"));
        this.fontPicker = new FontPicker(this, GUIHelper.DEFAULT_FONT);
        new Label((Composite)this, 0).setText(Messages.getString("CellStyleEditorPanel.horizontalAlignment"));
        this.horizontalAlignmentPicker = new HorizontalAlignmentPicker(this, HorizontalAlignmentEnum.CENTER);
        new Label((Composite)this, 0).setText(Messages.getString("CellStyleEditorPanel.verticalAlignment"));
        this.verticalAlignmentPicker = new VerticalAlignmentPicker(this, VerticalAlignmentEnum.MIDDLE);
    }

    @Override
    public String getEditorName() {
        return Messages.getString("CellStyleEditorPanel.editorName");
    }

    @Override
    public void edit(Style style) throws Exception {
        this.origBgColor = style.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, GUIHelper.COLOR_WHITE);
        this.backgroundColorPicker.setSelectedColor(this.origBgColor);
        this.origFgColor = style.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, GUIHelper.COLOR_BLACK);
        this.foregroundColorPicker.setSelectedColor(this.origFgColor);
        this.fontPicker.setOriginalFont(style.getAttributeValue(CellStyleAttributes.FONT));
        this.origHAlign = style.getAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, HorizontalAlignmentEnum.CENTER);
        this.horizontalAlignmentPicker.setSelectedAlignment(this.origHAlign);
        this.origVAlign = style.getAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, VerticalAlignmentEnum.MIDDLE);
        this.verticalAlignmentPicker.setSelectedAlignment(this.origVAlign);
    }

    @Override
    public Style getNewValue() {
        Style newStyle = new Style();
        Color bgColor = this.backgroundColorPicker.getSelectedColor();
        newStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, bgColor);
        Color fgColor = this.foregroundColorPicker.getSelectedColor();
        newStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, fgColor);
        Font font = this.fontPicker.getSelectedFont();
        newStyle.setAttributeValue(CellStyleAttributes.FONT, font);
        HorizontalAlignmentEnum hAlign = this.horizontalAlignmentPicker.getSelectedAlignment();
        newStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, hAlign);
        VerticalAlignmentEnum vAlign = this.verticalAlignmentPicker.getSelectedAlignment();
        newStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, vAlign);
        return newStyle;
    }
}

